///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBFILEPROPERTIESPropertiesSearchMatch;
@class DBFILEPROPERTIESPropertiesSearchResult;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `PropertiesSearchResult` struct.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBFILEPROPERTIESPropertiesSearchResult : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// A list (possibly empty) of matches for the query.
@property (nonatomic, readonly) NSArray<DBFILEPROPERTIESPropertiesSearchMatch *> *matches;

/// Pass the cursor into `propertiesSearchContinue` to continue to receive
/// search results. Cursor will be null when there are no more results.
@property (nonatomic, readonly, copy, nullable) NSString *cursor;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param matches A list (possibly empty) of matches for the query.
/// @param cursor Pass the cursor into `propertiesSearchContinue` to continue to
/// receive search results. Cursor will be null when there are no more results.
///
/// @return An initialized instance.
///
- (instancetype)initWithMatches:(NSArray<DBFILEPROPERTIESPropertiesSearchMatch *> *)matches
                         cursor:(nullable NSString *)cursor;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param matches A list (possibly empty) of matches for the query.
///
/// @return An initialized instance.
///
- (instancetype)initWithMatches:(NSArray<DBFILEPROPERTIESPropertiesSearchMatch *> *)matches;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `PropertiesSearchResult` struct.
///
@interface DBFILEPROPERTIESPropertiesSearchResultSerializer : NSObject

///
/// Serializes `DBFILEPROPERTIESPropertiesSearchResult` instances.
///
/// @param instance An instance of the `DBFILEPROPERTIESPropertiesSearchResult`
/// API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBFILEPROPERTIESPropertiesSearchResult` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBFILEPROPERTIESPropertiesSearchResult *)instance;

///
/// Deserializes `DBFILEPROPERTIESPropertiesSearchResult` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBFILEPROPERTIESPropertiesSearchResult` API object.
///
/// @return An instantiation of the `DBFILEPROPERTIESPropertiesSearchResult`
/// object.
///
+ (DBFILEPROPERTIESPropertiesSearchResult *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
