///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBFILEPROPERTIESLogicalOperator;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `LogicalOperator` union.
///
/// Logical operator to join search queries together.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBFILEPROPERTIESLogicalOperator : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBFILEPROPERTIESLogicalOperatorTag` enum type represents the possible
/// tag states with which the `DBFILEPROPERTIESLogicalOperator` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBFILEPROPERTIESLogicalOperatorTag){
    /// Append a query with an "or" operator.
    DBFILEPROPERTIESLogicalOperatorOrOperator,

    /// (no description).
    DBFILEPROPERTIESLogicalOperatorOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBFILEPROPERTIESLogicalOperatorTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "or_operator".
///
/// Description of the "or_operator" tag state: Append a query with an "or"
/// operator.
///
/// @return An initialized instance.
///
- (instancetype)initWithOrOperator;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "or_operator".
///
/// @return Whether the union's current tag state has value "or_operator".
///
- (BOOL)isOrOperator;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBFILEPROPERTIESLogicalOperator` union.
///
@interface DBFILEPROPERTIESLogicalOperatorSerializer : NSObject

///
/// Serializes `DBFILEPROPERTIESLogicalOperator` instances.
///
/// @param instance An instance of the `DBFILEPROPERTIESLogicalOperator` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBFILEPROPERTIESLogicalOperator` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBFILEPROPERTIESLogicalOperator *)instance;

///
/// Deserializes `DBFILEPROPERTIESLogicalOperator` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBFILEPROPERTIESLogicalOperator` API object.
///
/// @return An instantiation of the `DBFILEPROPERTIESLogicalOperator` object.
///
+ (DBFILEPROPERTIESLogicalOperator *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
