///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBCHECKEchoArg;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `EchoArg` struct.
///
/// EchoArg contains the arguments to be sent to the Dropbox servers.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBCHECKEchoArg : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The string that you'd like to be echoed back to you.
@property (nonatomic, readonly, copy) NSString *query;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param query The string that you'd like to be echoed back to you.
///
/// @return An initialized instance.
///
- (instancetype)initWithQuery:(nullable NSString *)query;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
///
/// @return An initialized instance.
///
- (instancetype)initDefault;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `EchoArg` struct.
///
@interface DBCHECKEchoArgSerializer : NSObject

///
/// Serializes `DBCHECKEchoArg` instances.
///
/// @param instance An instance of the `DBCHECKEchoArg` API object.
///
/// @return A json-compatible dictionary representation of the `DBCHECKEchoArg`
/// API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBCHECKEchoArg *)instance;

///
/// Deserializes `DBCHECKEchoArg` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBCHECKEchoArg` API object.
///
/// @return An instantiation of the `DBCHECKEchoArg` object.
///
+ (DBCHECKEchoArg *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
