//
//  UILabel+Additions.h
//

#import <UIKit/UIKit.h>


@interface UILabel (Additions)






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Numbering text

@property(nonatomic, retain) NSMutableParagraphStyle *paragraphStyle;

/**
 輸入有項目編號的文字，多行顯示時第二行開始會內縮，垂直對齊項目編號後的內容。（項目編號的格式為"1. "）

 @param text 文字內容
 @param leftInset 左側內縮
 */
- (void)setNumberingText:(NSString *)text leftInset:(CGFloat)leftInset;


/**
 輸入有項目編號的文字，多行顯示時第二行開始會內縮，垂直對齊項目編號後的內容。（項目編號的格式為"1. "）

 @param text 文字內容
 @param leftInset 左側內縮
 @param lineSpace 行距
 */
- (void)setNumberingText:(NSString *)text leftInset:(CGFloat)leftInset lineSpace:(CGFloat)lineSpace;


/**
 輸入有項目編號的文字，多行顯示時第二行開始會內縮，垂直對齊項目編號後的內容。（項目編號的格式為"1. "）
 
 @param text 文字內容
 @param leftInset 左側內縮
 @param lineSpace 行距
 @param numberingTextColor 數字編號顏色
 @param contentColor 內容顏色
 */
- (void)setNumberingText:(NSString *)text leftInset:(CGFloat)leftInset lineSpace:(CGFloat)lineSpace numberingTextColor:(UIColor *)numberingTextColor contentColor:(UIColor *)contentColor;

/**
 有項目編號的文字顯示大小，需要呼叫過 setNumberingText:leftInset: 才能使用。

 @param maxWidth 最大寬度
 @return 顯示大小
 */
- (CGSize)sizeOfNumberingTextWithMaxWidth:(CGFloat)maxWidth;






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - general methods


/**
 以目前文字，目前label寬度來計算高度
 
 @param paragraphStle labal paragraph style, if pass nil will use [NSParagraphStyle defaultParagraphStyle]
 @return label height
 */
- (CGFloat)heightForTextWithParagraphStle:(NSParagraphStyle *)paragraphStle;
@end
