//
//  UIDevice+IdentifierAddition.h
//  
//
//  Created by  Eddie  on 2011/11/1.
//  Fixed   by  Howard on 2013/09/06
//  Commented by Howard on 2013/09/06
//  Copyright (c) 2011年 Penpower. All rights reserved.
//

#import <Foundation/Foundation.h>

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface UIDevice (IdentifierAddition)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

/**
 * To get a mac-address string which appends the bundle name 
 * return : a mac-address string which appends the bundle name
 */
+ (NSString *)uniqueDeviceIdentifier;


/**
 * To get a mac-address string
 * return : a mac-address string
 */
+ (NSString *)uniqueGlobalDeviceIdentifier;


/**
 * To get uint integer. The Hex character which is at index of mac-address string is transformed Int value.
 * param index: the index of mac-address
 * return : The Hex character which is at index of mac-address string is transformed Int value
 */
+ (uint)uniqueDeviceIdentifierIntValueToIndex:(NSUInteger)index;

@end
