//
//  NSString+UTF32.h
//  WorldNote
//
//  Created by sanhue cheng on 13/10/2.
//  Modify by Andrew Lai on 14/5/16.
//  Copyright (c) 2013年 Eddie. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface NSString (UTF32)

/**
 * 在Range.location和NSString.length皆是使用UTF-8做計算,當遇到UTF-32時,文字個數不等於length.
 **/
- (NSUInteger)characterCount;

/**
 * 利用輸入的utf32Index, 轉換為對應文字的utf8 range
 *
 * @param utf32Index 在字串中的文字index
 * @return 對應文字的utf8 range
 **/
- (NSRange)rangeOfStringAtUTF32Index:(NSUInteger)utf32Index;

/**
 * 利用輸入的utf32Range, 取得字串
 *
 * @param utf32Range 對應到字串的utf32 range
 * @return 對應到utf32Range的字串
 **/
- (NSString *)substringWithUTF32Range:(NSRange)utf32Range;

/**
 * 在Range.location和NSString.length皆是使用UTF-8做計算,當遇到UTF-32時index會錯亂.
 *
 * @param utf8Index 在UTF-8字串中的文字index
 * @return 在字串裡代表第幾個文字(UTF-32裡的Index),-1表示無對應的文字
 **/
- (NSInteger)utf32IndexFromUTF8Index:(NSUInteger)utf8Index;

/**
 * 將輸入的utf32 range轉換為對應到字串中的utf8 range
 *
 * @param utf32Range 對應到字串的utf32 range
 * @return NSRange 對應到字串中的utf8 range
 **/
- (NSRange)utf8RangeFromUTF32Range:(NSRange)utf32Range;

/**
 * 字串內的文字交換位置
 *
 * @return 交換完文字的字串
 **/
- (NSString *)swapedStringFromIndex:(NSUInteger)fromIndex toIndex:(NSUInteger)toIndex;

@end
