//
//  NSData+AES256.h
//  
//
//  Created by Mike on 13/4/25.
//  
//

#import <Foundation/Foundation.h>
#import <CommonCrypto/CommonCryptor.h>

@interface NSData (AES256)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Methods

- (NSData *)cryptDataWithOperation:(CCOptions)operation key:(NSString *)key initializationVector:(NSData *)initializationVector;
- (NSData *)AES256EncryptDataWithKey:(NSString *)key initializationVector:(NSData *)initializationVector;
- (NSData *)AES256DecryptDataWithKey:(NSString *)key initializationVector:(NSData *)initializationVector;
- (NSData *)AES256EncryptDataWithKey:(NSString *)key;
- (NSData *)AES256DecryptDataWithKey:(NSString *)key;

- (NSData *)AESEncryptDataWithKey:(NSString *)key options:(CCOptions)options;
- (NSData *)AESDecryptDataWithKey:(NSString *)key options:(CCOptions)options;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Methods

+ (NSData *)generateInitializationVector;
+ (void)setShareInitializationVector:(NSData *)shareInitializationVector;
+ (NSData *)shareInitializationVector;

@end
