// NOTE: This file was generated by the ServiceGenerator.

// ----------------------------------------------------------------------------
// API:
//   Drive API (drive/v3)
// Description:
//   Manages files in Drive including uploading, downloading, searching,
//   detecting changes, and updating sharing permissions.
// Documentation:
//   https://developers.google.com/drive/

#if SWIFT_PACKAGE || GTLR_USE_MODULAR_IMPORT
  @import GoogleAPIClientForRESTCore;
#elif GTLR_BUILT_AS_FRAMEWORK
  #import "GTLR/GTLRQuery.h"
#else
  #import "GTLRQuery.h"
#endif

#if GTLR_RUNTIME_VERSION != 3000
#error This file was generated by a different version of ServiceGenerator which is incompatible with this GTLR library source.
#endif

@class GTLRDrive_Channel;
@class GTLRDrive_Comment;
@class GTLRDrive_Drive;
@class GTLRDrive_File;
@class GTLRDrive_Permission;
@class GTLRDrive_Reply;
@class GTLRDrive_Revision;
@class GTLRDrive_TeamDrive;

// Generated comments include content from the discovery document; avoid them
// causing warnings since clang's checks are some what arbitrary.
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdocumentation"

NS_ASSUME_NONNULL_BEGIN

// ----------------------------------------------------------------------------
// Constants - For some of the query classes' properties below.

// ----------------------------------------------------------------------------
// corpus

/**
 *  Files shared to the user's domain.
 *
 *  Value: "domain"
 */
FOUNDATION_EXTERN NSString * const kGTLRDriveCorpusDomain;
/**
 *  Files owned by or shared to the user. If a user has permissions on a Shared
 *  Drive, the files inside it won't be retrieved unless the user has created,
 *  opened, or shared the file.
 *
 *  Value: "user"
 */
FOUNDATION_EXTERN NSString * const kGTLRDriveCorpusUser;

// ----------------------------------------------------------------------------
// Query Classes
//

/**
 *  Parent class for other Drive query classes.
 */
@interface GTLRDriveQuery : GTLRQuery

/** Selector specifying which fields to include in a partial response. */
@property(nonatomic, copy, nullable) NSString *fields;

@end

/**
 *  Gets information about the user, the user's Drive, and system capabilities.
 *
 *  Method: drive.about.get
 *
 *  Authorization scope(s):
 *    @c kGTLRAuthScopeDrive
 *    @c kGTLRAuthScopeDriveAppdata
 *    @c kGTLRAuthScopeDriveFile
 *    @c kGTLRAuthScopeDriveMetadata
 *    @c kGTLRAuthScopeDriveMetadataReadonly
 *    @c kGTLRAuthScopeDrivePhotosReadonly
 *    @c kGTLRAuthScopeDriveReadonly
 */
@interface GTLRDriveQuery_AboutGet : GTLRDriveQuery
// Previous library name was
//   +[GTLQueryDrive queryForAboutGet]

/**
 *  Fetches a @c GTLRDrive_About.
 *
 *  Gets information about the user, the user's Drive, and system capabilities.
 *
 *  @return GTLRDriveQuery_AboutGet
 */
+ (instancetype)query;

@end

/**
 *  Gets the starting pageToken for listing future changes.
 *
 *  Method: drive.changes.getStartPageToken
 *
 *  Authorization scope(s):
 *    @c kGTLRAuthScopeDrive
 *    @c kGTLRAuthScopeDriveAppdata
 *    @c kGTLRAuthScopeDriveFile
 *    @c kGTLRAuthScopeDriveMetadata
 *    @c kGTLRAuthScopeDriveMetadataReadonly
 *    @c kGTLRAuthScopeDrivePhotosReadonly
 *    @c kGTLRAuthScopeDriveReadonly
 */
@interface GTLRDriveQuery_ChangesGetStartPageToken : GTLRDriveQuery
// Previous library name was
//   +[GTLQueryDrive queryForChangesGetStartPageToken]

/**
 *  The ID of the shared drive for which the starting pageToken for listing
 *  future changes from that shared drive is returned.
 */
@property(nonatomic, copy, nullable) NSString *driveId;

/**
 *  Whether the requesting application supports both My Drives and shared
 *  drives.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL supportsAllDrives;

/**
 *  Deprecated use supportsAllDrives instead.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL supportsTeamDrives;

/** Deprecated use driveId instead. */
@property(nonatomic, copy, nullable) NSString *teamDriveId;

/**
 *  Fetches a @c GTLRDrive_StartPageToken.
 *
 *  Gets the starting pageToken for listing future changes.
 *
 *  @return GTLRDriveQuery_ChangesGetStartPageToken
 */
+ (instancetype)query;

@end

/**
 *  Lists the changes for a user or shared drive.
 *
 *  Method: drive.changes.list
 *
 *  Authorization scope(s):
 *    @c kGTLRAuthScopeDrive
 *    @c kGTLRAuthScopeDriveAppdata
 *    @c kGTLRAuthScopeDriveFile
 *    @c kGTLRAuthScopeDriveMetadata
 *    @c kGTLRAuthScopeDriveMetadataReadonly
 *    @c kGTLRAuthScopeDrivePhotosReadonly
 *    @c kGTLRAuthScopeDriveReadonly
 */
@interface GTLRDriveQuery_ChangesList : GTLRDriveQuery
// Previous library name was
//   +[GTLQueryDrive queryForChangesListWithpageToken:]

/**
 *  The shared drive from which changes are returned. If specified the change
 *  IDs will be reflective of the shared drive; use the combined drive ID and
 *  change ID as an identifier.
 */
@property(nonatomic, copy, nullable) NSString *driveId;

/**
 *  Whether changes should include the file resource if the file is still
 *  accessible by the user at the time of the request, even when a file was
 *  removed from the list of changes and there will be no further change entries
 *  for this file.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL includeCorpusRemovals;

/**
 *  Whether both My Drive and shared drive items should be included in results.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL includeItemsFromAllDrives;

/**
 *  Specifies which additional view's permissions to include in the response.
 *  Only 'published' is supported.
 */
@property(nonatomic, copy, nullable) NSString *includePermissionsForView;

/**
 *  Whether to include changes indicating that items have been removed from the
 *  list of changes, for example by deletion or loss of access.
 *
 *  @note If not set, the documented server-side default will be true.
 */
@property(nonatomic, assign) BOOL includeRemoved;

/**
 *  Deprecated use includeItemsFromAllDrives instead.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL includeTeamDriveItems;

/**
 *  The maximum number of changes to return per page.
 *
 *  @note If not set, the documented server-side default will be 100 (from the
 *        range 1..1000).
 */
@property(nonatomic, assign) NSInteger pageSize;

/**
 *  The token for continuing a previous list request on the next page. This
 *  should be set to the value of 'nextPageToken' from the previous response or
 *  to the response from the getStartPageToken method.
 */
@property(nonatomic, copy, nullable) NSString *pageToken;

/**
 *  Whether to restrict the results to changes inside the My Drive hierarchy.
 *  This omits changes to files such as those in the Application Data folder or
 *  shared files which have not been added to My Drive.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL restrictToMyDrive;

/**
 *  A comma-separated list of spaces to query within the user corpus. Supported
 *  values are 'drive', 'appDataFolder' and 'photos'.
 *
 *  @note If not set, the documented server-side default will be drive.
 */
@property(nonatomic, copy, nullable) NSString *spaces;

/**
 *  Whether the requesting application supports both My Drives and shared
 *  drives.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL supportsAllDrives;

/**
 *  Deprecated use supportsAllDrives instead.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL supportsTeamDrives;

/** Deprecated use driveId instead. */
@property(nonatomic, copy, nullable) NSString *teamDriveId;

/**
 *  Fetches a @c GTLRDrive_ChangeList.
 *
 *  Lists the changes for a user or shared drive.
 *
 *  @param pageToken The token for continuing a previous list request on the
 *    next page. This should be set to the value of 'nextPageToken' from the
 *    previous response or to the response from the getStartPageToken method.
 *
 *  @return GTLRDriveQuery_ChangesList
 *
 *  @note Automatic pagination will be done when @c shouldFetchNextPages is
 *        enabled. See @c shouldFetchNextPages on @c GTLRService for more
 *        information.
 */
+ (instancetype)queryWithPageToken:(NSString *)pageToken;

@end

/**
 *  Subscribes to changes for a user.
 *
 *  Method: drive.changes.watch
 *
 *  Authorization scope(s):
 *    @c kGTLRAuthScopeDrive
 *    @c kGTLRAuthScopeDriveAppdata
 *    @c kGTLRAuthScopeDriveFile
 *    @c kGTLRAuthScopeDriveMetadata
 *    @c kGTLRAuthScopeDriveMetadataReadonly
 *    @c kGTLRAuthScopeDrivePhotosReadonly
 *    @c kGTLRAuthScopeDriveReadonly
 */
@interface GTLRDriveQuery_ChangesWatch : GTLRDriveQuery
// Previous library name was
//   +[GTLQueryDrive queryForChangesWatchWithObject:pageToken:]

/**
 *  The shared drive from which changes are returned. If specified the change
 *  IDs will be reflective of the shared drive; use the combined drive ID and
 *  change ID as an identifier.
 */
@property(nonatomic, copy, nullable) NSString *driveId;

/**
 *  Whether changes should include the file resource if the file is still
 *  accessible by the user at the time of the request, even when a file was
 *  removed from the list of changes and there will be no further change entries
 *  for this file.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL includeCorpusRemovals;

/**
 *  Whether both My Drive and shared drive items should be included in results.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL includeItemsFromAllDrives;

/**
 *  Specifies which additional view's permissions to include in the response.
 *  Only 'published' is supported.
 */
@property(nonatomic, copy, nullable) NSString *includePermissionsForView;

/**
 *  Whether to include changes indicating that items have been removed from the
 *  list of changes, for example by deletion or loss of access.
 *
 *  @note If not set, the documented server-side default will be true.
 */
@property(nonatomic, assign) BOOL includeRemoved;

/**
 *  Deprecated use includeItemsFromAllDrives instead.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL includeTeamDriveItems;

/**
 *  The maximum number of changes to return per page.
 *
 *  @note If not set, the documented server-side default will be 100 (from the
 *        range 1..1000).
 */
@property(nonatomic, assign) NSInteger pageSize;

/**
 *  The token for continuing a previous list request on the next page. This
 *  should be set to the value of 'nextPageToken' from the previous response or
 *  to the response from the getStartPageToken method.
 */
@property(nonatomic, copy, nullable) NSString *pageToken;

/**
 *  Whether to restrict the results to changes inside the My Drive hierarchy.
 *  This omits changes to files such as those in the Application Data folder or
 *  shared files which have not been added to My Drive.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL restrictToMyDrive;

/**
 *  A comma-separated list of spaces to query within the user corpus. Supported
 *  values are 'drive', 'appDataFolder' and 'photos'.
 *
 *  @note If not set, the documented server-side default will be drive.
 */
@property(nonatomic, copy, nullable) NSString *spaces;

/**
 *  Whether the requesting application supports both My Drives and shared
 *  drives.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL supportsAllDrives;

/**
 *  Deprecated use supportsAllDrives instead.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL supportsTeamDrives;

/** Deprecated use driveId instead. */
@property(nonatomic, copy, nullable) NSString *teamDriveId;

/**
 *  Fetches a @c GTLRDrive_Channel.
 *
 *  Subscribes to changes for a user.
 *
 *  @param object The @c GTLRDrive_Channel to include in the query.
 *  @param pageToken The token for continuing a previous list request on the
 *    next page. This should be set to the value of 'nextPageToken' from the
 *    previous response or to the response from the getStartPageToken method.
 *
 *  @return GTLRDriveQuery_ChangesWatch
 */
+ (instancetype)queryWithObject:(GTLRDrive_Channel *)object
                      pageToken:(NSString *)pageToken;

@end

/**
 *  Stop watching resources through this channel
 *
 *  Method: drive.channels.stop
 *
 *  Authorization scope(s):
 *    @c kGTLRAuthScopeDrive
 *    @c kGTLRAuthScopeDriveAppdata
 *    @c kGTLRAuthScopeDriveFile
 *    @c kGTLRAuthScopeDriveMetadata
 *    @c kGTLRAuthScopeDriveMetadataReadonly
 *    @c kGTLRAuthScopeDrivePhotosReadonly
 *    @c kGTLRAuthScopeDriveReadonly
 */
@interface GTLRDriveQuery_ChannelsStop : GTLRDriveQuery
// Previous library name was
//   +[GTLQueryDrive queryForChannelsStopWithObject:]

/**
 *  Upon successful completion, the callback's object and error parameters will
 *  be nil. This query does not fetch an object.
 *
 *  Stop watching resources through this channel
 *
 *  @param object The @c GTLRDrive_Channel to include in the query.
 *
 *  @return GTLRDriveQuery_ChannelsStop
 */
+ (instancetype)queryWithObject:(GTLRDrive_Channel *)object;

@end

/**
 *  Creates a new comment on a file.
 *
 *  Method: drive.comments.create
 *
 *  Authorization scope(s):
 *    @c kGTLRAuthScopeDrive
 *    @c kGTLRAuthScopeDriveFile
 */
@interface GTLRDriveQuery_CommentsCreate : GTLRDriveQuery
// Previous library name was
//   +[GTLQueryDrive queryForCommentsCreateWithObject:fileId:]

/** The ID of the file. */
@property(nonatomic, copy, nullable) NSString *fileId;

/**
 *  Fetches a @c GTLRDrive_Comment.
 *
 *  Creates a new comment on a file.
 *
 *  @param object The @c GTLRDrive_Comment to include in the query.
 *  @param fileId The ID of the file.
 *
 *  @return GTLRDriveQuery_CommentsCreate
 */
+ (instancetype)queryWithObject:(GTLRDrive_Comment *)object
                         fileId:(NSString *)fileId;

@end

/**
 *  Deletes a comment.
 *
 *  Method: drive.comments.delete
 *
 *  Authorization scope(s):
 *    @c kGTLRAuthScopeDrive
 *    @c kGTLRAuthScopeDriveFile
 */
@interface GTLRDriveQuery_CommentsDelete : GTLRDriveQuery
// Previous library name was
//   +[GTLQueryDrive queryForCommentsDeleteWithfileId:commentId:]

/** The ID of the comment. */
@property(nonatomic, copy, nullable) NSString *commentId;

/** The ID of the file. */
@property(nonatomic, copy, nullable) NSString *fileId;

/**
 *  Upon successful completion, the callback's object and error parameters will
 *  be nil. This query does not fetch an object.
 *
 *  Deletes a comment.
 *
 *  @param fileId The ID of the file.
 *  @param commentId The ID of the comment.
 *
 *  @return GTLRDriveQuery_CommentsDelete
 */
+ (instancetype)queryWithFileId:(NSString *)fileId
                      commentId:(NSString *)commentId;

@end

/**
 *  Gets a comment by ID.
 *
 *  Method: drive.comments.get
 *
 *  Authorization scope(s):
 *    @c kGTLRAuthScopeDrive
 *    @c kGTLRAuthScopeDriveFile
 *    @c kGTLRAuthScopeDriveReadonly
 */
@interface GTLRDriveQuery_CommentsGet : GTLRDriveQuery
// Previous library name was
//   +[GTLQueryDrive queryForCommentsGetWithfileId:commentId:]

/** The ID of the comment. */
@property(nonatomic, copy, nullable) NSString *commentId;

/** The ID of the file. */
@property(nonatomic, copy, nullable) NSString *fileId;

/**
 *  Whether to return deleted comments. Deleted comments will not include their
 *  original content.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL includeDeleted;

/**
 *  Fetches a @c GTLRDrive_Comment.
 *
 *  Gets a comment by ID.
 *
 *  @param fileId The ID of the file.
 *  @param commentId The ID of the comment.
 *
 *  @return GTLRDriveQuery_CommentsGet
 */
+ (instancetype)queryWithFileId:(NSString *)fileId
                      commentId:(NSString *)commentId;

@end

/**
 *  Lists a file's comments.
 *
 *  Method: drive.comments.list
 *
 *  Authorization scope(s):
 *    @c kGTLRAuthScopeDrive
 *    @c kGTLRAuthScopeDriveFile
 *    @c kGTLRAuthScopeDriveReadonly
 */
@interface GTLRDriveQuery_CommentsList : GTLRDriveQuery
// Previous library name was
//   +[GTLQueryDrive queryForCommentsListWithfileId:]

/** The ID of the file. */
@property(nonatomic, copy, nullable) NSString *fileId;

/**
 *  Whether to include deleted comments. Deleted comments will not include their
 *  original content.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL includeDeleted;

/**
 *  The maximum number of comments to return per page.
 *
 *  @note If not set, the documented server-side default will be 20 (from the
 *        range 1..100).
 */
@property(nonatomic, assign) NSInteger pageSize;

/**
 *  The token for continuing a previous list request on the next page. This
 *  should be set to the value of 'nextPageToken' from the previous response.
 */
@property(nonatomic, copy, nullable) NSString *pageToken;

/**
 *  The minimum value of 'modifiedTime' for the result comments (RFC 3339
 *  date-time).
 */
@property(nonatomic, copy, nullable) NSString *startModifiedTime;

/**
 *  Fetches a @c GTLRDrive_CommentList.
 *
 *  Lists a file's comments.
 *
 *  @param fileId The ID of the file.
 *
 *  @return GTLRDriveQuery_CommentsList
 *
 *  @note Automatic pagination will be done when @c shouldFetchNextPages is
 *        enabled. See @c shouldFetchNextPages on @c GTLRService for more
 *        information.
 */
+ (instancetype)queryWithFileId:(NSString *)fileId;

@end

/**
 *  Updates a comment with patch semantics.
 *
 *  Method: drive.comments.update
 *
 *  Authorization scope(s):
 *    @c kGTLRAuthScopeDrive
 *    @c kGTLRAuthScopeDriveFile
 */
@interface GTLRDriveQuery_CommentsUpdate : GTLRDriveQuery
// Previous library name was
//   +[GTLQueryDrive queryForCommentsUpdateWithObject:fileId:commentId:]

/** The ID of the comment. */
@property(nonatomic, copy, nullable) NSString *commentId;

/** The ID of the file. */
@property(nonatomic, copy, nullable) NSString *fileId;

/**
 *  Fetches a @c GTLRDrive_Comment.
 *
 *  Updates a comment with patch semantics.
 *
 *  @param object The @c GTLRDrive_Comment to include in the query.
 *  @param fileId The ID of the file.
 *  @param commentId The ID of the comment.
 *
 *  @return GTLRDriveQuery_CommentsUpdate
 */
+ (instancetype)queryWithObject:(GTLRDrive_Comment *)object
                         fileId:(NSString *)fileId
                      commentId:(NSString *)commentId;

@end

/**
 *  Creates a new shared drive.
 *
 *  Method: drive.drives.create
 *
 *  Authorization scope(s):
 *    @c kGTLRAuthScopeDrive
 */
@interface GTLRDriveQuery_DrivesCreate : GTLRDriveQuery
// Previous library name was
//   +[GTLQueryDrive queryForDrivesCreateWithObject:requestId:]

/**
 *  An ID, such as a random UUID, which uniquely identifies this user's request
 *  for idempotent creation of a shared drive. A repeated request by the same
 *  user and with the same request ID will avoid creating duplicates by
 *  attempting to create the same shared drive. If the shared drive already
 *  exists a 409 error will be returned.
 */
@property(nonatomic, copy, nullable) NSString *requestId;

/**
 *  Fetches a @c GTLRDrive_Drive.
 *
 *  Creates a new shared drive.
 *
 *  @param object The @c GTLRDrive_Drive to include in the query.
 *  @param requestId An ID, such as a random UUID, which uniquely identifies
 *    this user's request for idempotent creation of a shared drive. A repeated
 *    request by the same user and with the same request ID will avoid creating
 *    duplicates by attempting to create the same shared drive. If the shared
 *    drive already exists a 409 error will be returned.
 *
 *  @return GTLRDriveQuery_DrivesCreate
 */
+ (instancetype)queryWithObject:(GTLRDrive_Drive *)object
                      requestId:(NSString *)requestId;

@end

/**
 *  Permanently deletes a shared drive for which the user is an organizer. The
 *  shared drive cannot contain any untrashed items.
 *
 *  Method: drive.drives.delete
 *
 *  Authorization scope(s):
 *    @c kGTLRAuthScopeDrive
 */
@interface GTLRDriveQuery_DrivesDelete : GTLRDriveQuery
// Previous library name was
//   +[GTLQueryDrive queryForDrivesDeleteWithdriveId:]

/** The ID of the shared drive. */
@property(nonatomic, copy, nullable) NSString *driveId;

/**
 *  Upon successful completion, the callback's object and error parameters will
 *  be nil. This query does not fetch an object.
 *
 *  Permanently deletes a shared drive for which the user is an organizer. The
 *  shared drive cannot contain any untrashed items.
 *
 *  @param driveId The ID of the shared drive.
 *
 *  @return GTLRDriveQuery_DrivesDelete
 */
+ (instancetype)queryWithDriveId:(NSString *)driveId;

@end

/**
 *  Gets a shared drive's metadata by ID.
 *
 *  Method: drive.drives.get
 *
 *  Authorization scope(s):
 *    @c kGTLRAuthScopeDrive
 *    @c kGTLRAuthScopeDriveReadonly
 */
@interface GTLRDriveQuery_DrivesGet : GTLRDriveQuery
// Previous library name was
//   +[GTLQueryDrive queryForDrivesGetWithdriveId:]

/** The ID of the shared drive. */
@property(nonatomic, copy, nullable) NSString *driveId;

/**
 *  Issue the request as a domain administrator; if set to true, then the
 *  requester will be granted access if they are an administrator of the domain
 *  to which the shared drive belongs.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL useDomainAdminAccess;

/**
 *  Fetches a @c GTLRDrive_Drive.
 *
 *  Gets a shared drive's metadata by ID.
 *
 *  @param driveId The ID of the shared drive.
 *
 *  @return GTLRDriveQuery_DrivesGet
 */
+ (instancetype)queryWithDriveId:(NSString *)driveId;

@end

/**
 *  Hides a shared drive from the default view.
 *
 *  Method: drive.drives.hide
 *
 *  Authorization scope(s):
 *    @c kGTLRAuthScopeDrive
 */
@interface GTLRDriveQuery_DrivesHide : GTLRDriveQuery
// Previous library name was
//   +[GTLQueryDrive queryForDrivesHideWithdriveId:]

/** The ID of the shared drive. */
@property(nonatomic, copy, nullable) NSString *driveId;

/**
 *  Fetches a @c GTLRDrive_Drive.
 *
 *  Hides a shared drive from the default view.
 *
 *  @param driveId The ID of the shared drive.
 *
 *  @return GTLRDriveQuery_DrivesHide
 */
+ (instancetype)queryWithDriveId:(NSString *)driveId;

@end

/**
 *  Lists the user's shared drives.
 *
 *  Method: drive.drives.list
 *
 *  Authorization scope(s):
 *    @c kGTLRAuthScopeDrive
 *    @c kGTLRAuthScopeDriveReadonly
 */
@interface GTLRDriveQuery_DrivesList : GTLRDriveQuery
// Previous library name was
//   +[GTLQueryDrive queryForDrivesList]

/**
 *  Maximum number of shared drives to return.
 *
 *  @note If not set, the documented server-side default will be 10 (from the
 *        range 1..100).
 */
@property(nonatomic, assign) NSInteger pageSize;

/** Page token for shared drives. */
@property(nonatomic, copy, nullable) NSString *pageToken;

/** Query string for searching shared drives. */
@property(nonatomic, copy, nullable) NSString *q;

/**
 *  Issue the request as a domain administrator; if set to true, then all shared
 *  drives of the domain in which the requester is an administrator are
 *  returned.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL useDomainAdminAccess;

/**
 *  Fetches a @c GTLRDrive_DriveList.
 *
 *  Lists the user's shared drives.
 *
 *  @return GTLRDriveQuery_DrivesList
 *
 *  @note Automatic pagination will be done when @c shouldFetchNextPages is
 *        enabled. See @c shouldFetchNextPages on @c GTLRService for more
 *        information.
 */
+ (instancetype)query;

@end

/**
 *  Restores a shared drive to the default view.
 *
 *  Method: drive.drives.unhide
 *
 *  Authorization scope(s):
 *    @c kGTLRAuthScopeDrive
 */
@interface GTLRDriveQuery_DrivesUnhide : GTLRDriveQuery
// Previous library name was
//   +[GTLQueryDrive queryForDrivesUnhideWithdriveId:]

/** The ID of the shared drive. */
@property(nonatomic, copy, nullable) NSString *driveId;

/**
 *  Fetches a @c GTLRDrive_Drive.
 *
 *  Restores a shared drive to the default view.
 *
 *  @param driveId The ID of the shared drive.
 *
 *  @return GTLRDriveQuery_DrivesUnhide
 */
+ (instancetype)queryWithDriveId:(NSString *)driveId;

@end

/**
 *  Updates the metadate for a shared drive.
 *
 *  Method: drive.drives.update
 *
 *  Authorization scope(s):
 *    @c kGTLRAuthScopeDrive
 */
@interface GTLRDriveQuery_DrivesUpdate : GTLRDriveQuery
// Previous library name was
//   +[GTLQueryDrive queryForDrivesUpdateWithObject:driveId:]

/** The ID of the shared drive. */
@property(nonatomic, copy, nullable) NSString *driveId;

/**
 *  Issue the request as a domain administrator; if set to true, then the
 *  requester will be granted access if they are an administrator of the domain
 *  to which the shared drive belongs.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL useDomainAdminAccess;

/**
 *  Fetches a @c GTLRDrive_Drive.
 *
 *  Updates the metadate for a shared drive.
 *
 *  @param object The @c GTLRDrive_Drive to include in the query.
 *  @param driveId The ID of the shared drive.
 *
 *  @return GTLRDriveQuery_DrivesUpdate
 */
+ (instancetype)queryWithObject:(GTLRDrive_Drive *)object
                        driveId:(NSString *)driveId;

@end

/**
 *  Creates a copy of a file and applies any requested updates with patch
 *  semantics. Folders cannot be copied.
 *
 *  Method: drive.files.copy
 *
 *  Authorization scope(s):
 *    @c kGTLRAuthScopeDrive
 *    @c kGTLRAuthScopeDriveAppdata
 *    @c kGTLRAuthScopeDriveFile
 *    @c kGTLRAuthScopeDrivePhotosReadonly
 */
@interface GTLRDriveQuery_FilesCopy : GTLRDriveQuery
// Previous library name was
//   +[GTLQueryDrive queryForFilesCopyWithObject:fileId:]

/**
 *  Deprecated. Copying files into multiple folders is no longer supported. Use
 *  shortcuts instead.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL enforceSingleParent;

/** The ID of the file. */
@property(nonatomic, copy, nullable) NSString *fileId;

/**
 *  Whether to ignore the domain's default visibility settings for the created
 *  file. Domain administrators can choose to make all uploaded files visible to
 *  the domain by default; this parameter bypasses that behavior for the
 *  request. Permissions are still inherited from parent folders.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL ignoreDefaultVisibility;

/**
 *  Specifies which additional view's permissions to include in the response.
 *  Only 'published' is supported.
 */
@property(nonatomic, copy, nullable) NSString *includePermissionsForView;

/**
 *  Whether to set the 'keepForever' field in the new head revision. This is
 *  only applicable to files with binary content in Google Drive. Only 200
 *  revisions for the file can be kept forever. If the limit is reached, try
 *  deleting pinned revisions.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL keepRevisionForever;

/**
 *  A language hint for OCR processing during image import (ISO 639-1 code).
 */
@property(nonatomic, copy, nullable) NSString *ocrLanguage;

/**
 *  Whether the requesting application supports both My Drives and shared
 *  drives.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL supportsAllDrives;

/**
 *  Deprecated use supportsAllDrives instead.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL supportsTeamDrives;

/**
 *  Fetches a @c GTLRDrive_File.
 *
 *  Creates a copy of a file and applies any requested updates with patch
 *  semantics. Folders cannot be copied.
 *
 *  @param object The @c GTLRDrive_File to include in the query.
 *  @param fileId The ID of the file.
 *
 *  @return GTLRDriveQuery_FilesCopy
 */
+ (instancetype)queryWithObject:(GTLRDrive_File *)object
                         fileId:(NSString *)fileId;

@end

/**
 *  Creates a new file.
 *
 *  Method: drive.files.create
 *
 *  Authorization scope(s):
 *    @c kGTLRAuthScopeDrive
 *    @c kGTLRAuthScopeDriveAppdata
 *    @c kGTLRAuthScopeDriveFile
 */
@interface GTLRDriveQuery_FilesCreate : GTLRDriveQuery
// Previous library name was
//   +[GTLQueryDrive queryForFilesCreateWithObject:]

/**
 *  Deprecated. Creating files in multiple folders is no longer supported.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL enforceSingleParent;

/**
 *  Whether to ignore the domain's default visibility settings for the created
 *  file. Domain administrators can choose to make all uploaded files visible to
 *  the domain by default; this parameter bypasses that behavior for the
 *  request. Permissions are still inherited from parent folders.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL ignoreDefaultVisibility;

/**
 *  Specifies which additional view's permissions to include in the response.
 *  Only 'published' is supported.
 */
@property(nonatomic, copy, nullable) NSString *includePermissionsForView;

/**
 *  Whether to set the 'keepForever' field in the new head revision. This is
 *  only applicable to files with binary content in Google Drive. Only 200
 *  revisions for the file can be kept forever. If the limit is reached, try
 *  deleting pinned revisions.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL keepRevisionForever;

/**
 *  A language hint for OCR processing during image import (ISO 639-1 code).
 */
@property(nonatomic, copy, nullable) NSString *ocrLanguage;

/**
 *  Whether the requesting application supports both My Drives and shared
 *  drives.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL supportsAllDrives;

/**
 *  Deprecated use supportsAllDrives instead.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL supportsTeamDrives;

/**
 *  Whether to use the uploaded content as indexable text.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL useContentAsIndexableText;

/**
 *  Fetches a @c GTLRDrive_File.
 *
 *  Creates a new file.
 *
 *  @param object The @c GTLRDrive_File to include in the query.
 *  @param uploadParameters The media to include in this query. Maximum size
 *    5120GB. Accepted MIME type: * / *
 *
 *  @return GTLRDriveQuery_FilesCreate
 */
+ (instancetype)queryWithObject:(GTLRDrive_File *)object
               uploadParameters:(nullable GTLRUploadParameters *)uploadParameters;

@end

/**
 *  Permanently deletes a file owned by the user without moving it to the trash.
 *  If the file belongs to a shared drive the user must be an organizer on the
 *  parent. If the target is a folder, all descendants owned by the user are
 *  also deleted.
 *
 *  Method: drive.files.delete
 *
 *  Authorization scope(s):
 *    @c kGTLRAuthScopeDrive
 *    @c kGTLRAuthScopeDriveAppdata
 *    @c kGTLRAuthScopeDriveFile
 */
@interface GTLRDriveQuery_FilesDelete : GTLRDriveQuery
// Previous library name was
//   +[GTLQueryDrive queryForFilesDeleteWithfileId:]

/**
 *  Deprecated. If an item is not in a shared drive and its last parent is
 *  deleted but the item itself is not, the item will be placed under its
 *  owner's root.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL enforceSingleParent;

/** The ID of the file. */
@property(nonatomic, copy, nullable) NSString *fileId;

/**
 *  Whether the requesting application supports both My Drives and shared
 *  drives.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL supportsAllDrives;

/**
 *  Deprecated use supportsAllDrives instead.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL supportsTeamDrives;

/**
 *  Upon successful completion, the callback's object and error parameters will
 *  be nil. This query does not fetch an object.
 *
 *  Permanently deletes a file owned by the user without moving it to the trash.
 *  If the file belongs to a shared drive the user must be an organizer on the
 *  parent. If the target is a folder, all descendants owned by the user are
 *  also deleted.
 *
 *  @param fileId The ID of the file.
 *
 *  @return GTLRDriveQuery_FilesDelete
 */
+ (instancetype)queryWithFileId:(NSString *)fileId;

@end

/**
 *  Permanently deletes all of the user's trashed files.
 *
 *  Method: drive.files.emptyTrash
 *
 *  Authorization scope(s):
 *    @c kGTLRAuthScopeDrive
 */
@interface GTLRDriveQuery_FilesEmptyTrash : GTLRDriveQuery
// Previous library name was
//   +[GTLQueryDrive queryForFilesEmptyTrash]

/**
 *  Deprecated. If an item is not in a shared drive and its last parent is
 *  deleted but the item itself is not, the item will be placed under its
 *  owner's root.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL enforceSingleParent;

/**
 *  Upon successful completion, the callback's object and error parameters will
 *  be nil. This query does not fetch an object.
 *
 *  Permanently deletes all of the user's trashed files.
 *
 *  @return GTLRDriveQuery_FilesEmptyTrash
 */
+ (instancetype)query;

@end

/**
 *  Exports a Google Doc to the requested MIME type and returns the exported
 *  content. Please note that the exported content is limited to 10MB.
 *
 *  Method: drive.files.export
 *
 *  Authorization scope(s):
 *    @c kGTLRAuthScopeDrive
 *    @c kGTLRAuthScopeDriveFile
 *    @c kGTLRAuthScopeDriveReadonly
 */
@interface GTLRDriveQuery_FilesExport : GTLRDriveQuery
// Previous library name was
//   +[GTLQueryDrive queryForFilesExportWithfileId:mimeType:]

/** The ID of the file. */
@property(nonatomic, copy, nullable) NSString *fileId;

/** The MIME type of the format requested for this export. */
@property(nonatomic, copy, nullable) NSString *mimeType;

/**
 *  Fetches the requested resource data as a @c GTLRDataObject.
 *
 *  Exports a Google Doc to the requested MIME type and returns the exported
 *  content. Please note that the exported content is limited to 10MB.
 *
 *  @param fileId The ID of the file.
 *  @param mimeType The MIME type of the format requested for this export.
 *
 *  @return GTLRDriveQuery_FilesExport
 */
+ (instancetype)queryForMediaWithFileId:(NSString *)fileId
                               mimeType:(NSString *)mimeType;

@end

/**
 *  Generates a set of file IDs which can be provided in create or copy
 *  requests.
 *
 *  Method: drive.files.generateIds
 *
 *  Authorization scope(s):
 *    @c kGTLRAuthScopeDrive
 *    @c kGTLRAuthScopeDriveAppdata
 *    @c kGTLRAuthScopeDriveFile
 */
@interface GTLRDriveQuery_FilesGenerateIds : GTLRDriveQuery
// Previous library name was
//   +[GTLQueryDrive queryForFilesGenerateIds]

/**
 *  The number of IDs to return.
 *
 *  @note If not set, the documented server-side default will be 10 (from the
 *        range 1..1000).
 */
@property(nonatomic, assign) NSInteger count;

/**
 *  The space in which the IDs can be used to create new files. Supported values
 *  are 'drive' and 'appDataFolder'.
 *
 *  @note If not set, the documented server-side default will be drive.
 */
@property(nonatomic, copy, nullable) NSString *space;

/**
 *  Fetches a @c GTLRDrive_GeneratedIds.
 *
 *  Generates a set of file IDs which can be provided in create or copy
 *  requests.
 *
 *  @return GTLRDriveQuery_FilesGenerateIds
 */
+ (instancetype)query;

@end

/**
 *  Gets a file's metadata or content by ID.
 *
 *  Method: drive.files.get
 *
 *  Authorization scope(s):
 *    @c kGTLRAuthScopeDrive
 *    @c kGTLRAuthScopeDriveAppdata
 *    @c kGTLRAuthScopeDriveFile
 *    @c kGTLRAuthScopeDriveMetadata
 *    @c kGTLRAuthScopeDriveMetadataReadonly
 *    @c kGTLRAuthScopeDrivePhotosReadonly
 *    @c kGTLRAuthScopeDriveReadonly
 */
@interface GTLRDriveQuery_FilesGet : GTLRDriveQuery
// Previous library name was
//   +[GTLQueryDrive queryForFilesGetWithfileId:]

/**
 *  Whether the user is acknowledging the risk of downloading known malware or
 *  other abusive files. This is only applicable when alt=media.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL acknowledgeAbuse;

/** The ID of the file. */
@property(nonatomic, copy, nullable) NSString *fileId;

/**
 *  Specifies which additional view's permissions to include in the response.
 *  Only 'published' is supported.
 */
@property(nonatomic, copy, nullable) NSString *includePermissionsForView;

/**
 *  Whether the requesting application supports both My Drives and shared
 *  drives.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL supportsAllDrives;

/**
 *  Deprecated use supportsAllDrives instead.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL supportsTeamDrives;

/**
 *  Fetches a @c GTLRDrive_File.
 *
 *  Gets a file's metadata or content by ID.
 *
 *  @param fileId The ID of the file.
 *
 *  @return GTLRDriveQuery_FilesGet
 */
+ (instancetype)queryWithFileId:(NSString *)fileId;

/**
 *  Fetches the requested resource data as a @c GTLRDataObject.
 *
 *  Gets a file's metadata or content by ID.
 *
 *  @param fileId The ID of the file.
 *
 *  @return GTLRDriveQuery_FilesGet
 */
+ (instancetype)queryForMediaWithFileId:(NSString *)fileId;

@end

/**
 *  Lists or searches files.
 *
 *  Method: drive.files.list
 *
 *  Authorization scope(s):
 *    @c kGTLRAuthScopeDrive
 *    @c kGTLRAuthScopeDriveAppdata
 *    @c kGTLRAuthScopeDriveFile
 *    @c kGTLRAuthScopeDriveMetadata
 *    @c kGTLRAuthScopeDriveMetadataReadonly
 *    @c kGTLRAuthScopeDrivePhotosReadonly
 *    @c kGTLRAuthScopeDriveReadonly
 */
@interface GTLRDriveQuery_FilesList : GTLRDriveQuery
// Previous library name was
//   +[GTLQueryDrive queryForFilesList]

/**
 *  Groupings of files to which the query applies. Supported groupings are:
 *  'user' (files created by, opened by, or shared directly with the user),
 *  'drive' (files in the specified shared drive as indicated by the 'driveId'),
 *  'domain' (files shared to the user's domain), and 'allDrives' (A combination
 *  of 'user' and 'drive' for all drives where the user is a member). When able,
 *  use 'user' or 'drive', instead of 'allDrives', for efficiency.
 */
@property(nonatomic, copy, nullable) NSString *corpora;

/**
 *  The source of files to list. Deprecated: use 'corpora' instead.
 *
 *  Likely values:
 *    @arg @c kGTLRDriveCorpusDomain Files shared to the user's domain. (Value:
 *        "domain")
 *    @arg @c kGTLRDriveCorpusUser Files owned by or shared to the user. If a
 *        user has permissions on a Shared Drive, the files inside it won't be
 *        retrieved unless the user has created, opened, or shared the file.
 *        (Value: "user")
 */
@property(nonatomic, copy, nullable) NSString *corpus;

/** ID of the shared drive to search. */
@property(nonatomic, copy, nullable) NSString *driveId;

/**
 *  Whether both My Drive and shared drive items should be included in results.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL includeItemsFromAllDrives;

/**
 *  Specifies which additional view's permissions to include in the response.
 *  Only 'published' is supported.
 */
@property(nonatomic, copy, nullable) NSString *includePermissionsForView;

/**
 *  Deprecated use includeItemsFromAllDrives instead.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL includeTeamDriveItems;

/**
 *  A comma-separated list of sort keys. Valid keys are 'createdTime', 'folder',
 *  'modifiedByMeTime', 'modifiedTime', 'name', 'name_natural',
 *  'quotaBytesUsed', 'recency', 'sharedWithMeTime', 'starred', and
 *  'viewedByMeTime'. Each key sorts ascending by default, but may be reversed
 *  with the 'desc' modifier. Example usage: ?orderBy=folder,modifiedTime
 *  desc,name. Please note that there is a current limitation for users with
 *  approximately one million files in which the requested sort order is
 *  ignored.
 */
@property(nonatomic, copy, nullable) NSString *orderBy;

/**
 *  The maximum number of files to return per page. Partial or empty result
 *  pages are possible even before the end of the files list has been reached.
 *
 *  @note If not set, the documented server-side default will be 100 (from the
 *        range 1..1000).
 */
@property(nonatomic, assign) NSInteger pageSize;

/**
 *  The token for continuing a previous list request on the next page. This
 *  should be set to the value of 'nextPageToken' from the previous response.
 */
@property(nonatomic, copy, nullable) NSString *pageToken;

/**
 *  A query for filtering the file results. See the "Search for Files" guide for
 *  supported syntax.
 */
@property(nonatomic, copy, nullable) NSString *q;

/**
 *  A comma-separated list of spaces to query within the corpus. Supported
 *  values are 'drive', 'appDataFolder' and 'photos'.
 *
 *  @note If not set, the documented server-side default will be drive.
 */
@property(nonatomic, copy, nullable) NSString *spaces;

/**
 *  Whether the requesting application supports both My Drives and shared
 *  drives.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL supportsAllDrives;

/**
 *  Deprecated use supportsAllDrives instead.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL supportsTeamDrives;

/** Deprecated use driveId instead. */
@property(nonatomic, copy, nullable) NSString *teamDriveId;

/**
 *  Fetches a @c GTLRDrive_FileList.
 *
 *  Lists or searches files.
 *
 *  @return GTLRDriveQuery_FilesList
 *
 *  @note Automatic pagination will be done when @c shouldFetchNextPages is
 *        enabled. See @c shouldFetchNextPages on @c GTLRService for more
 *        information.
 */
+ (instancetype)query;

@end

/**
 *  Updates a file's metadata and/or content. This method supports patch
 *  semantics.
 *
 *  Method: drive.files.update
 *
 *  Authorization scope(s):
 *    @c kGTLRAuthScopeDrive
 *    @c kGTLRAuthScopeDriveAppdata
 *    @c kGTLRAuthScopeDriveFile
 *    @c kGTLRAuthScopeDriveMetadata
 *    @c kGTLRAuthScopeDriveScripts
 */
@interface GTLRDriveQuery_FilesUpdate : GTLRDriveQuery
// Previous library name was
//   +[GTLQueryDrive queryForFilesUpdateWithObject:fileId:]

/** A comma-separated list of parent IDs to add. */
@property(nonatomic, copy, nullable) NSString *addParents;

/**
 *  Deprecated. Adding files to multiple folders is no longer supported. Use
 *  shortcuts instead.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL enforceSingleParent;

/** The ID of the file. */
@property(nonatomic, copy, nullable) NSString *fileId;

/**
 *  Specifies which additional view's permissions to include in the response.
 *  Only 'published' is supported.
 */
@property(nonatomic, copy, nullable) NSString *includePermissionsForView;

/**
 *  Whether to set the 'keepForever' field in the new head revision. This is
 *  only applicable to files with binary content in Google Drive. Only 200
 *  revisions for the file can be kept forever. If the limit is reached, try
 *  deleting pinned revisions.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL keepRevisionForever;

/**
 *  A language hint for OCR processing during image import (ISO 639-1 code).
 */
@property(nonatomic, copy, nullable) NSString *ocrLanguage;

/** A comma-separated list of parent IDs to remove. */
@property(nonatomic, copy, nullable) NSString *removeParents;

/**
 *  Whether the requesting application supports both My Drives and shared
 *  drives.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL supportsAllDrives;

/**
 *  Deprecated use supportsAllDrives instead.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL supportsTeamDrives;

/**
 *  Whether to use the uploaded content as indexable text.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL useContentAsIndexableText;

/**
 *  Fetches a @c GTLRDrive_File.
 *
 *  Updates a file's metadata and/or content. This method supports patch
 *  semantics.
 *
 *  @param object The @c GTLRDrive_File to include in the query.
 *  @param fileId The ID of the file.
 *  @param uploadParameters The media to include in this query. Maximum size
 *    5120GB. Accepted MIME type: * / *
 *
 *  @return GTLRDriveQuery_FilesUpdate
 */
+ (instancetype)queryWithObject:(GTLRDrive_File *)object
                         fileId:(NSString *)fileId
               uploadParameters:(nullable GTLRUploadParameters *)uploadParameters;

@end

/**
 *  Subscribes to changes to a file
 *
 *  Method: drive.files.watch
 *
 *  Authorization scope(s):
 *    @c kGTLRAuthScopeDrive
 *    @c kGTLRAuthScopeDriveAppdata
 *    @c kGTLRAuthScopeDriveFile
 *    @c kGTLRAuthScopeDriveMetadata
 *    @c kGTLRAuthScopeDriveMetadataReadonly
 *    @c kGTLRAuthScopeDrivePhotosReadonly
 *    @c kGTLRAuthScopeDriveReadonly
 */
@interface GTLRDriveQuery_FilesWatch : GTLRDriveQuery
// Previous library name was
//   +[GTLQueryDrive queryForFilesWatchWithObject:fileId:]

/**
 *  Whether the user is acknowledging the risk of downloading known malware or
 *  other abusive files. This is only applicable when alt=media.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL acknowledgeAbuse;

/** The ID of the file. */
@property(nonatomic, copy, nullable) NSString *fileId;

/**
 *  Specifies which additional view's permissions to include in the response.
 *  Only 'published' is supported.
 */
@property(nonatomic, copy, nullable) NSString *includePermissionsForView;

/**
 *  Whether the requesting application supports both My Drives and shared
 *  drives.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL supportsAllDrives;

/**
 *  Deprecated use supportsAllDrives instead.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL supportsTeamDrives;

/**
 *  Fetches a @c GTLRDrive_Channel.
 *
 *  Subscribes to changes to a file
 *
 *  @param object The @c GTLRDrive_Channel to include in the query.
 *  @param fileId The ID of the file.
 *
 *  @return GTLRDriveQuery_FilesWatch
 */
+ (instancetype)queryWithObject:(GTLRDrive_Channel *)object
                         fileId:(NSString *)fileId;

/**
 *  Fetches the requested resource data as a @c GTLRDataObject.
 *
 *  Subscribes to changes to a file
 *
 *  @param object The @c GTLRDrive_Channel to include in the query.
 *  @param fileId The ID of the file.
 *
 *  @return GTLRDriveQuery_FilesWatch
 */
+ (instancetype)queryForMediaWithObject:(GTLRDrive_Channel *)object
                                 fileId:(NSString *)fileId;

@end

/**
 *  Creates a permission for a file or shared drive.
 *
 *  Method: drive.permissions.create
 *
 *  Authorization scope(s):
 *    @c kGTLRAuthScopeDrive
 *    @c kGTLRAuthScopeDriveFile
 */
@interface GTLRDriveQuery_PermissionsCreate : GTLRDriveQuery
// Previous library name was
//   +[GTLQueryDrive queryForPermissionsCreateWithObject:fileId:]

/** A plain text custom message to include in the notification email. */
@property(nonatomic, copy, nullable) NSString *emailMessage;

/**
 *  Deprecated. See moveToNewOwnersRoot for details.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL enforceSingleParent;

/** The ID of the file or shared drive. */
@property(nonatomic, copy, nullable) NSString *fileId;

/**
 *  This parameter will only take effect if the item is not in a shared drive
 *  and the request is attempting to transfer the ownership of the item. If set
 *  to true, the item will be moved to the new owner's My Drive root folder and
 *  all prior parents removed. If set to false, parents are not changed.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL moveToNewOwnersRoot;

/**
 *  Whether to send a notification email when sharing to users or groups. This
 *  defaults to true for users and groups, and is not allowed for other
 *  requests. It must not be disabled for ownership transfers.
 */
@property(nonatomic, assign) BOOL sendNotificationEmail;

/**
 *  Whether the requesting application supports both My Drives and shared
 *  drives.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL supportsAllDrives;

/**
 *  Deprecated use supportsAllDrives instead.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL supportsTeamDrives;

/**
 *  Whether to transfer ownership to the specified user and downgrade the
 *  current owner to a writer. This parameter is required as an acknowledgement
 *  of the side effect.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL transferOwnership;

/**
 *  Issue the request as a domain administrator; if set to true, then the
 *  requester will be granted access if the file ID parameter refers to a shared
 *  drive and the requester is an administrator of the domain to which the
 *  shared drive belongs.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL useDomainAdminAccess;

/**
 *  Fetches a @c GTLRDrive_Permission.
 *
 *  Creates a permission for a file or shared drive.
 *
 *  @param object The @c GTLRDrive_Permission to include in the query.
 *  @param fileId The ID of the file or shared drive.
 *
 *  @return GTLRDriveQuery_PermissionsCreate
 */
+ (instancetype)queryWithObject:(GTLRDrive_Permission *)object
                         fileId:(NSString *)fileId;

@end

/**
 *  Deletes a permission.
 *
 *  Method: drive.permissions.delete
 *
 *  Authorization scope(s):
 *    @c kGTLRAuthScopeDrive
 *    @c kGTLRAuthScopeDriveFile
 */
@interface GTLRDriveQuery_PermissionsDelete : GTLRDriveQuery
// Previous library name was
//   +[GTLQueryDrive queryForPermissionsDeleteWithfileId:permissionId:]

/** The ID of the file or shared drive. */
@property(nonatomic, copy, nullable) NSString *fileId;

/** The ID of the permission. */
@property(nonatomic, copy, nullable) NSString *permissionId;

/**
 *  Whether the requesting application supports both My Drives and shared
 *  drives.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL supportsAllDrives;

/**
 *  Deprecated use supportsAllDrives instead.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL supportsTeamDrives;

/**
 *  Issue the request as a domain administrator; if set to true, then the
 *  requester will be granted access if the file ID parameter refers to a shared
 *  drive and the requester is an administrator of the domain to which the
 *  shared drive belongs.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL useDomainAdminAccess;

/**
 *  Upon successful completion, the callback's object and error parameters will
 *  be nil. This query does not fetch an object.
 *
 *  Deletes a permission.
 *
 *  @param fileId The ID of the file or shared drive.
 *  @param permissionId The ID of the permission.
 *
 *  @return GTLRDriveQuery_PermissionsDelete
 */
+ (instancetype)queryWithFileId:(NSString *)fileId
                   permissionId:(NSString *)permissionId;

@end

/**
 *  Gets a permission by ID.
 *
 *  Method: drive.permissions.get
 *
 *  Authorization scope(s):
 *    @c kGTLRAuthScopeDrive
 *    @c kGTLRAuthScopeDriveFile
 *    @c kGTLRAuthScopeDriveMetadata
 *    @c kGTLRAuthScopeDriveMetadataReadonly
 *    @c kGTLRAuthScopeDrivePhotosReadonly
 *    @c kGTLRAuthScopeDriveReadonly
 */
@interface GTLRDriveQuery_PermissionsGet : GTLRDriveQuery
// Previous library name was
//   +[GTLQueryDrive queryForPermissionsGetWithfileId:permissionId:]

/** The ID of the file. */
@property(nonatomic, copy, nullable) NSString *fileId;

/** The ID of the permission. */
@property(nonatomic, copy, nullable) NSString *permissionId;

/**
 *  Whether the requesting application supports both My Drives and shared
 *  drives.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL supportsAllDrives;

/**
 *  Deprecated use supportsAllDrives instead.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL supportsTeamDrives;

/**
 *  Issue the request as a domain administrator; if set to true, then the
 *  requester will be granted access if the file ID parameter refers to a shared
 *  drive and the requester is an administrator of the domain to which the
 *  shared drive belongs.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL useDomainAdminAccess;

/**
 *  Fetches a @c GTLRDrive_Permission.
 *
 *  Gets a permission by ID.
 *
 *  @param fileId The ID of the file.
 *  @param permissionId The ID of the permission.
 *
 *  @return GTLRDriveQuery_PermissionsGet
 */
+ (instancetype)queryWithFileId:(NSString *)fileId
                   permissionId:(NSString *)permissionId;

@end

/**
 *  Lists a file's or shared drive's permissions.
 *
 *  Method: drive.permissions.list
 *
 *  Authorization scope(s):
 *    @c kGTLRAuthScopeDrive
 *    @c kGTLRAuthScopeDriveFile
 *    @c kGTLRAuthScopeDriveMetadata
 *    @c kGTLRAuthScopeDriveMetadataReadonly
 *    @c kGTLRAuthScopeDrivePhotosReadonly
 *    @c kGTLRAuthScopeDriveReadonly
 */
@interface GTLRDriveQuery_PermissionsList : GTLRDriveQuery
// Previous library name was
//   +[GTLQueryDrive queryForPermissionsListWithfileId:]

/** The ID of the file or shared drive. */
@property(nonatomic, copy, nullable) NSString *fileId;

/**
 *  Specifies which additional view's permissions to include in the response.
 *  Only 'published' is supported.
 */
@property(nonatomic, copy, nullable) NSString *includePermissionsForView;

/**
 *  The maximum number of permissions to return per page. When not set for files
 *  in a shared drive, at most 100 results will be returned. When not set for
 *  files that are not in a shared drive, the entire list will be returned.
 *
 *  @note The documented range is 1..100.
 */
@property(nonatomic, assign) NSInteger pageSize;

/**
 *  The token for continuing a previous list request on the next page. This
 *  should be set to the value of 'nextPageToken' from the previous response.
 */
@property(nonatomic, copy, nullable) NSString *pageToken;

/**
 *  Whether the requesting application supports both My Drives and shared
 *  drives.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL supportsAllDrives;

/**
 *  Deprecated use supportsAllDrives instead.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL supportsTeamDrives;

/**
 *  Issue the request as a domain administrator; if set to true, then the
 *  requester will be granted access if the file ID parameter refers to a shared
 *  drive and the requester is an administrator of the domain to which the
 *  shared drive belongs.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL useDomainAdminAccess;

/**
 *  Fetches a @c GTLRDrive_PermissionList.
 *
 *  Lists a file's or shared drive's permissions.
 *
 *  @param fileId The ID of the file or shared drive.
 *
 *  @return GTLRDriveQuery_PermissionsList
 *
 *  @note Automatic pagination will be done when @c shouldFetchNextPages is
 *        enabled. See @c shouldFetchNextPages on @c GTLRService for more
 *        information.
 */
+ (instancetype)queryWithFileId:(NSString *)fileId;

@end

/**
 *  Updates a permission with patch semantics.
 *
 *  Method: drive.permissions.update
 *
 *  Authorization scope(s):
 *    @c kGTLRAuthScopeDrive
 *    @c kGTLRAuthScopeDriveFile
 */
@interface GTLRDriveQuery_PermissionsUpdate : GTLRDriveQuery
// Previous library name was
//   +[GTLQueryDrive queryForPermissionsUpdateWithObject:fileId:permissionId:]

/** The ID of the file or shared drive. */
@property(nonatomic, copy, nullable) NSString *fileId;

/** The ID of the permission. */
@property(nonatomic, copy, nullable) NSString *permissionId;

/**
 *  Whether to remove the expiration date.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL removeExpiration;

/**
 *  Whether the requesting application supports both My Drives and shared
 *  drives.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL supportsAllDrives;

/**
 *  Deprecated use supportsAllDrives instead.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL supportsTeamDrives;

/**
 *  Whether to transfer ownership to the specified user and downgrade the
 *  current owner to a writer. This parameter is required as an acknowledgement
 *  of the side effect.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL transferOwnership;

/**
 *  Issue the request as a domain administrator; if set to true, then the
 *  requester will be granted access if the file ID parameter refers to a shared
 *  drive and the requester is an administrator of the domain to which the
 *  shared drive belongs.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL useDomainAdminAccess;

/**
 *  Fetches a @c GTLRDrive_Permission.
 *
 *  Updates a permission with patch semantics.
 *
 *  @param object The @c GTLRDrive_Permission to include in the query.
 *  @param fileId The ID of the file or shared drive.
 *  @param permissionId The ID of the permission.
 *
 *  @return GTLRDriveQuery_PermissionsUpdate
 */
+ (instancetype)queryWithObject:(GTLRDrive_Permission *)object
                         fileId:(NSString *)fileId
                   permissionId:(NSString *)permissionId;

@end

/**
 *  Creates a new reply to a comment.
 *
 *  Method: drive.replies.create
 *
 *  Authorization scope(s):
 *    @c kGTLRAuthScopeDrive
 *    @c kGTLRAuthScopeDriveFile
 */
@interface GTLRDriveQuery_RepliesCreate : GTLRDriveQuery
// Previous library name was
//   +[GTLQueryDrive queryForRepliesCreateWithObject:fileId:commentId:]

/** The ID of the comment. */
@property(nonatomic, copy, nullable) NSString *commentId;

/** The ID of the file. */
@property(nonatomic, copy, nullable) NSString *fileId;

/**
 *  Fetches a @c GTLRDrive_Reply.
 *
 *  Creates a new reply to a comment.
 *
 *  @param object The @c GTLRDrive_Reply to include in the query.
 *  @param fileId The ID of the file.
 *  @param commentId The ID of the comment.
 *
 *  @return GTLRDriveQuery_RepliesCreate
 */
+ (instancetype)queryWithObject:(GTLRDrive_Reply *)object
                         fileId:(NSString *)fileId
                      commentId:(NSString *)commentId;

@end

/**
 *  Deletes a reply.
 *
 *  Method: drive.replies.delete
 *
 *  Authorization scope(s):
 *    @c kGTLRAuthScopeDrive
 *    @c kGTLRAuthScopeDriveFile
 */
@interface GTLRDriveQuery_RepliesDelete : GTLRDriveQuery
// Previous library name was
//   +[GTLQueryDrive queryForRepliesDeleteWithfileId:commentId:replyId:]

/** The ID of the comment. */
@property(nonatomic, copy, nullable) NSString *commentId;

/** The ID of the file. */
@property(nonatomic, copy, nullable) NSString *fileId;

/** The ID of the reply. */
@property(nonatomic, copy, nullable) NSString *replyId;

/**
 *  Upon successful completion, the callback's object and error parameters will
 *  be nil. This query does not fetch an object.
 *
 *  Deletes a reply.
 *
 *  @param fileId The ID of the file.
 *  @param commentId The ID of the comment.
 *  @param replyId The ID of the reply.
 *
 *  @return GTLRDriveQuery_RepliesDelete
 */
+ (instancetype)queryWithFileId:(NSString *)fileId
                      commentId:(NSString *)commentId
                        replyId:(NSString *)replyId;

@end

/**
 *  Gets a reply by ID.
 *
 *  Method: drive.replies.get
 *
 *  Authorization scope(s):
 *    @c kGTLRAuthScopeDrive
 *    @c kGTLRAuthScopeDriveFile
 *    @c kGTLRAuthScopeDriveReadonly
 */
@interface GTLRDriveQuery_RepliesGet : GTLRDriveQuery
// Previous library name was
//   +[GTLQueryDrive queryForRepliesGetWithfileId:commentId:replyId:]

/** The ID of the comment. */
@property(nonatomic, copy, nullable) NSString *commentId;

/** The ID of the file. */
@property(nonatomic, copy, nullable) NSString *fileId;

/**
 *  Whether to return deleted replies. Deleted replies will not include their
 *  original content.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL includeDeleted;

/** The ID of the reply. */
@property(nonatomic, copy, nullable) NSString *replyId;

/**
 *  Fetches a @c GTLRDrive_Reply.
 *
 *  Gets a reply by ID.
 *
 *  @param fileId The ID of the file.
 *  @param commentId The ID of the comment.
 *  @param replyId The ID of the reply.
 *
 *  @return GTLRDriveQuery_RepliesGet
 */
+ (instancetype)queryWithFileId:(NSString *)fileId
                      commentId:(NSString *)commentId
                        replyId:(NSString *)replyId;

@end

/**
 *  Lists a comment's replies.
 *
 *  Method: drive.replies.list
 *
 *  Authorization scope(s):
 *    @c kGTLRAuthScopeDrive
 *    @c kGTLRAuthScopeDriveFile
 *    @c kGTLRAuthScopeDriveReadonly
 */
@interface GTLRDriveQuery_RepliesList : GTLRDriveQuery
// Previous library name was
//   +[GTLQueryDrive queryForRepliesListWithfileId:commentId:]

/** The ID of the comment. */
@property(nonatomic, copy, nullable) NSString *commentId;

/** The ID of the file. */
@property(nonatomic, copy, nullable) NSString *fileId;

/**
 *  Whether to include deleted replies. Deleted replies will not include their
 *  original content.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL includeDeleted;

/**
 *  The maximum number of replies to return per page.
 *
 *  @note If not set, the documented server-side default will be 20 (from the
 *        range 1..100).
 */
@property(nonatomic, assign) NSInteger pageSize;

/**
 *  The token for continuing a previous list request on the next page. This
 *  should be set to the value of 'nextPageToken' from the previous response.
 */
@property(nonatomic, copy, nullable) NSString *pageToken;

/**
 *  Fetches a @c GTLRDrive_ReplyList.
 *
 *  Lists a comment's replies.
 *
 *  @param fileId The ID of the file.
 *  @param commentId The ID of the comment.
 *
 *  @return GTLRDriveQuery_RepliesList
 *
 *  @note Automatic pagination will be done when @c shouldFetchNextPages is
 *        enabled. See @c shouldFetchNextPages on @c GTLRService for more
 *        information.
 */
+ (instancetype)queryWithFileId:(NSString *)fileId
                      commentId:(NSString *)commentId;

@end

/**
 *  Updates a reply with patch semantics.
 *
 *  Method: drive.replies.update
 *
 *  Authorization scope(s):
 *    @c kGTLRAuthScopeDrive
 *    @c kGTLRAuthScopeDriveFile
 */
@interface GTLRDriveQuery_RepliesUpdate : GTLRDriveQuery
// Previous library name was
//   +[GTLQueryDrive queryForRepliesUpdateWithObject:fileId:commentId:replyId:]

/** The ID of the comment. */
@property(nonatomic, copy, nullable) NSString *commentId;

/** The ID of the file. */
@property(nonatomic, copy, nullable) NSString *fileId;

/** The ID of the reply. */
@property(nonatomic, copy, nullable) NSString *replyId;

/**
 *  Fetches a @c GTLRDrive_Reply.
 *
 *  Updates a reply with patch semantics.
 *
 *  @param object The @c GTLRDrive_Reply to include in the query.
 *  @param fileId The ID of the file.
 *  @param commentId The ID of the comment.
 *  @param replyId The ID of the reply.
 *
 *  @return GTLRDriveQuery_RepliesUpdate
 */
+ (instancetype)queryWithObject:(GTLRDrive_Reply *)object
                         fileId:(NSString *)fileId
                      commentId:(NSString *)commentId
                        replyId:(NSString *)replyId;

@end

/**
 *  Permanently deletes a file version. You can only delete revisions for files
 *  with binary content in Google Drive, like images or videos. Revisions for
 *  other files, like Google Docs or Sheets, and the last remaining file version
 *  can't be deleted.
 *
 *  Method: drive.revisions.delete
 *
 *  Authorization scope(s):
 *    @c kGTLRAuthScopeDrive
 *    @c kGTLRAuthScopeDriveAppdata
 *    @c kGTLRAuthScopeDriveFile
 */
@interface GTLRDriveQuery_RevisionsDelete : GTLRDriveQuery
// Previous library name was
//   +[GTLQueryDrive queryForRevisionsDeleteWithfileId:revisionId:]

/** The ID of the file. */
@property(nonatomic, copy, nullable) NSString *fileId;

/** The ID of the revision. */
@property(nonatomic, copy, nullable) NSString *revisionId;

/**
 *  Upon successful completion, the callback's object and error parameters will
 *  be nil. This query does not fetch an object.
 *
 *  Permanently deletes a file version. You can only delete revisions for files
 *  with binary content in Google Drive, like images or videos. Revisions for
 *  other files, like Google Docs or Sheets, and the last remaining file version
 *  can't be deleted.
 *
 *  @param fileId The ID of the file.
 *  @param revisionId The ID of the revision.
 *
 *  @return GTLRDriveQuery_RevisionsDelete
 */
+ (instancetype)queryWithFileId:(NSString *)fileId
                     revisionId:(NSString *)revisionId;

@end

/**
 *  Gets a revision's metadata or content by ID.
 *
 *  Method: drive.revisions.get
 *
 *  Authorization scope(s):
 *    @c kGTLRAuthScopeDrive
 *    @c kGTLRAuthScopeDriveAppdata
 *    @c kGTLRAuthScopeDriveFile
 *    @c kGTLRAuthScopeDriveMetadata
 *    @c kGTLRAuthScopeDriveMetadataReadonly
 *    @c kGTLRAuthScopeDrivePhotosReadonly
 *    @c kGTLRAuthScopeDriveReadonly
 */
@interface GTLRDriveQuery_RevisionsGet : GTLRDriveQuery
// Previous library name was
//   +[GTLQueryDrive queryForRevisionsGetWithfileId:revisionId:]

/**
 *  Whether the user is acknowledging the risk of downloading known malware or
 *  other abusive files. This is only applicable when alt=media.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL acknowledgeAbuse;

/** The ID of the file. */
@property(nonatomic, copy, nullable) NSString *fileId;

/** The ID of the revision. */
@property(nonatomic, copy, nullable) NSString *revisionId;

/**
 *  Fetches a @c GTLRDrive_Revision.
 *
 *  Gets a revision's metadata or content by ID.
 *
 *  @param fileId The ID of the file.
 *  @param revisionId The ID of the revision.
 *
 *  @return GTLRDriveQuery_RevisionsGet
 */
+ (instancetype)queryWithFileId:(NSString *)fileId
                     revisionId:(NSString *)revisionId;

/**
 *  Fetches the requested resource data as a @c GTLRDataObject.
 *
 *  Gets a revision's metadata or content by ID.
 *
 *  @param fileId The ID of the file.
 *  @param revisionId The ID of the revision.
 *
 *  @return GTLRDriveQuery_RevisionsGet
 */
+ (instancetype)queryForMediaWithFileId:(NSString *)fileId
                             revisionId:(NSString *)revisionId;

@end

/**
 *  Lists a file's revisions.
 *
 *  Method: drive.revisions.list
 *
 *  Authorization scope(s):
 *    @c kGTLRAuthScopeDrive
 *    @c kGTLRAuthScopeDriveAppdata
 *    @c kGTLRAuthScopeDriveFile
 *    @c kGTLRAuthScopeDriveMetadata
 *    @c kGTLRAuthScopeDriveMetadataReadonly
 *    @c kGTLRAuthScopeDrivePhotosReadonly
 *    @c kGTLRAuthScopeDriveReadonly
 */
@interface GTLRDriveQuery_RevisionsList : GTLRDriveQuery
// Previous library name was
//   +[GTLQueryDrive queryForRevisionsListWithfileId:]

/** The ID of the file. */
@property(nonatomic, copy, nullable) NSString *fileId;

/**
 *  The maximum number of revisions to return per page.
 *
 *  @note If not set, the documented server-side default will be 200 (from the
 *        range 1..1000).
 */
@property(nonatomic, assign) NSInteger pageSize;

/**
 *  The token for continuing a previous list request on the next page. This
 *  should be set to the value of 'nextPageToken' from the previous response.
 */
@property(nonatomic, copy, nullable) NSString *pageToken;

/**
 *  Fetches a @c GTLRDrive_RevisionList.
 *
 *  Lists a file's revisions.
 *
 *  @param fileId The ID of the file.
 *
 *  @return GTLRDriveQuery_RevisionsList
 *
 *  @note Automatic pagination will be done when @c shouldFetchNextPages is
 *        enabled. See @c shouldFetchNextPages on @c GTLRService for more
 *        information.
 */
+ (instancetype)queryWithFileId:(NSString *)fileId;

@end

/**
 *  Updates a revision with patch semantics.
 *
 *  Method: drive.revisions.update
 *
 *  Authorization scope(s):
 *    @c kGTLRAuthScopeDrive
 *    @c kGTLRAuthScopeDriveAppdata
 *    @c kGTLRAuthScopeDriveFile
 */
@interface GTLRDriveQuery_RevisionsUpdate : GTLRDriveQuery
// Previous library name was
//   +[GTLQueryDrive queryForRevisionsUpdateWithObject:fileId:revisionId:]

/** The ID of the file. */
@property(nonatomic, copy, nullable) NSString *fileId;

/** The ID of the revision. */
@property(nonatomic, copy, nullable) NSString *revisionId;

/**
 *  Fetches a @c GTLRDrive_Revision.
 *
 *  Updates a revision with patch semantics.
 *
 *  @param object The @c GTLRDrive_Revision to include in the query.
 *  @param fileId The ID of the file.
 *  @param revisionId The ID of the revision.
 *
 *  @return GTLRDriveQuery_RevisionsUpdate
 */
+ (instancetype)queryWithObject:(GTLRDrive_Revision *)object
                         fileId:(NSString *)fileId
                     revisionId:(NSString *)revisionId;

@end

/**
 *  Deprecated use drives.create instead.
 *
 *  Method: drive.teamdrives.create
 *
 *  Authorization scope(s):
 *    @c kGTLRAuthScopeDrive
 */
@interface GTLRDriveQuery_TeamdrivesCreate : GTLRDriveQuery
// Previous library name was
//   +[GTLQueryDrive queryForTeamdrivesCreateWithObject:requestId:]

/**
 *  An ID, such as a random UUID, which uniquely identifies this user's request
 *  for idempotent creation of a Team Drive. A repeated request by the same user
 *  and with the same request ID will avoid creating duplicates by attempting to
 *  create the same Team Drive. If the Team Drive already exists a 409 error
 *  will be returned.
 */
@property(nonatomic, copy, nullable) NSString *requestId;

/**
 *  Fetches a @c GTLRDrive_TeamDrive.
 *
 *  Deprecated use drives.create instead.
 *
 *  @param object The @c GTLRDrive_TeamDrive to include in the query.
 *  @param requestId An ID, such as a random UUID, which uniquely identifies
 *    this user's request for idempotent creation of a Team Drive. A repeated
 *    request by the same user and with the same request ID will avoid creating
 *    duplicates by attempting to create the same Team Drive. If the Team Drive
 *    already exists a 409 error will be returned.
 *
 *  @return GTLRDriveQuery_TeamdrivesCreate
 */
+ (instancetype)queryWithObject:(GTLRDrive_TeamDrive *)object
                      requestId:(NSString *)requestId;

@end

/**
 *  Deprecated use drives.delete instead.
 *
 *  Method: drive.teamdrives.delete
 *
 *  Authorization scope(s):
 *    @c kGTLRAuthScopeDrive
 */
@interface GTLRDriveQuery_TeamdrivesDelete : GTLRDriveQuery
// Previous library name was
//   +[GTLQueryDrive queryForTeamdrivesDeleteWithteamDriveId:]

/** The ID of the Team Drive */
@property(nonatomic, copy, nullable) NSString *teamDriveId;

/**
 *  Upon successful completion, the callback's object and error parameters will
 *  be nil. This query does not fetch an object.
 *
 *  Deprecated use drives.delete instead.
 *
 *  @param teamDriveId The ID of the Team Drive
 *
 *  @return GTLRDriveQuery_TeamdrivesDelete
 */
+ (instancetype)queryWithTeamDriveId:(NSString *)teamDriveId;

@end

/**
 *  Deprecated use drives.get instead.
 *
 *  Method: drive.teamdrives.get
 *
 *  Authorization scope(s):
 *    @c kGTLRAuthScopeDrive
 *    @c kGTLRAuthScopeDriveReadonly
 */
@interface GTLRDriveQuery_TeamdrivesGet : GTLRDriveQuery
// Previous library name was
//   +[GTLQueryDrive queryForTeamdrivesGetWithteamDriveId:]

/** The ID of the Team Drive */
@property(nonatomic, copy, nullable) NSString *teamDriveId;

/**
 *  Issue the request as a domain administrator; if set to true, then the
 *  requester will be granted access if they are an administrator of the domain
 *  to which the Team Drive belongs.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL useDomainAdminAccess;

/**
 *  Fetches a @c GTLRDrive_TeamDrive.
 *
 *  Deprecated use drives.get instead.
 *
 *  @param teamDriveId The ID of the Team Drive
 *
 *  @return GTLRDriveQuery_TeamdrivesGet
 */
+ (instancetype)queryWithTeamDriveId:(NSString *)teamDriveId;

@end

/**
 *  Deprecated use drives.list instead.
 *
 *  Method: drive.teamdrives.list
 *
 *  Authorization scope(s):
 *    @c kGTLRAuthScopeDrive
 *    @c kGTLRAuthScopeDriveReadonly
 */
@interface GTLRDriveQuery_TeamdrivesList : GTLRDriveQuery
// Previous library name was
//   +[GTLQueryDrive queryForTeamdrivesList]

/**
 *  Maximum number of Team Drives to return.
 *
 *  @note If not set, the documented server-side default will be 10 (from the
 *        range 1..100).
 */
@property(nonatomic, assign) NSInteger pageSize;

/** Page token for Team Drives. */
@property(nonatomic, copy, nullable) NSString *pageToken;

/** Query string for searching Team Drives. */
@property(nonatomic, copy, nullable) NSString *q;

/**
 *  Issue the request as a domain administrator; if set to true, then all Team
 *  Drives of the domain in which the requester is an administrator are
 *  returned.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL useDomainAdminAccess;

/**
 *  Fetches a @c GTLRDrive_TeamDriveList.
 *
 *  Deprecated use drives.list instead.
 *
 *  @return GTLRDriveQuery_TeamdrivesList
 *
 *  @note Automatic pagination will be done when @c shouldFetchNextPages is
 *        enabled. See @c shouldFetchNextPages on @c GTLRService for more
 *        information.
 */
+ (instancetype)query;

@end

/**
 *  Deprecated use drives.update instead
 *
 *  Method: drive.teamdrives.update
 *
 *  Authorization scope(s):
 *    @c kGTLRAuthScopeDrive
 */
@interface GTLRDriveQuery_TeamdrivesUpdate : GTLRDriveQuery
// Previous library name was
//   +[GTLQueryDrive queryForTeamdrivesUpdateWithObject:teamDriveId:]

/** The ID of the Team Drive */
@property(nonatomic, copy, nullable) NSString *teamDriveId;

/**
 *  Issue the request as a domain administrator; if set to true, then the
 *  requester will be granted access if they are an administrator of the domain
 *  to which the Team Drive belongs.
 *
 *  @note If not set, the documented server-side default will be false.
 */
@property(nonatomic, assign) BOOL useDomainAdminAccess;

/**
 *  Fetches a @c GTLRDrive_TeamDrive.
 *
 *  Deprecated use drives.update instead
 *
 *  @param object The @c GTLRDrive_TeamDrive to include in the query.
 *  @param teamDriveId The ID of the Team Drive
 *
 *  @return GTLRDriveQuery_TeamdrivesUpdate
 */
+ (instancetype)queryWithObject:(GTLRDrive_TeamDrive *)object
                    teamDriveId:(NSString *)teamDriveId;

@end

NS_ASSUME_NONNULL_END

#pragma clang diagnostic pop
