// Copyright (c) 2014-present, Facebook, Inc. All rights reserved.
//
// You are hereby granted a non-exclusive, worldwide, royalty-free license to use,
// copy, modify, and distribute this software in source code or binary form for use
// in connection with the web services and APIs provided by Facebook.
//
// As with any software that integrates with the Facebook platform, your use of
// this software is subject to the Facebook Developer Principles and Policies
// [http://developers.facebook.com/policy/]. This copyright notice shall be
// included in all copies or substantial portions of the software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
// FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
// COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
// IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
// CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

#import "TargetConditionals.h"

#if !TARGET_OS_TV

#import <UIKit/UIKit.h>

#import "FBSDKBridgeAPIProtocol.h"

@protocol FBSDKPasteboard;

typedef struct
{
  __unsafe_unretained NSString *bridgeArgs;
  __unsafe_unretained NSString *methodArgs;
  __unsafe_unretained NSString *methodVersion;
} FBSDKBridgeAPIProtocolNativeV1OutputKeysStruct;
FOUNDATION_EXPORT const FBSDKBridgeAPIProtocolNativeV1OutputKeysStruct FBSDKBridgeAPIProtocolNativeV1OutputKeys;

typedef struct
{
  __unsafe_unretained NSString *actionID;
  __unsafe_unretained NSString *appIcon;
  __unsafe_unretained NSString *appName;
  __unsafe_unretained NSString *sdkVersion;
} FBSDKBridgeAPIProtocolNativeV1BridgeParameterOutputKeysStruct;
FOUNDATION_EXPORT const FBSDKBridgeAPIProtocolNativeV1BridgeParameterOutputKeysStruct FBSDKBridgeAPIProtocolNativeV1BridgeParameterOutputKeys;

typedef struct
{
  __unsafe_unretained NSString *bridgeArgs;
  __unsafe_unretained NSString *methodResults;
} FBSDKBridgeAPIProtocolNativeV1InputKeysStruct;
FOUNDATION_EXPORT const FBSDKBridgeAPIProtocolNativeV1InputKeysStruct FBSDKBridgeAPIProtocolNativeV1InputKeys;

typedef struct
{
  __unsafe_unretained NSString *actionID;
  __unsafe_unretained NSString *error;
} FBSDKBridgeAPIProtocolNativeV1BridgeParameterInputKeysStruct;
FOUNDATION_EXPORT const FBSDKBridgeAPIProtocolNativeV1BridgeParameterInputKeysStruct FBSDKBridgeAPIProtocolNativeV1BridgeParameterInputKeys;

NS_SWIFT_NAME(BridgeAPIProtocolNativeV1)
@interface FBSDKBridgeAPIProtocolNativeV1 : NSObject <FBSDKBridgeAPIProtocol>

- (instancetype)init NS_UNAVAILABLE;
+ (instancetype)new NS_UNAVAILABLE;

- (instancetype)initWithAppScheme:(NSString *)appScheme;
- (instancetype)initWithAppScheme:(NSString *)appScheme
                       pasteboard:(id<FBSDKPasteboard>)pasteboard
              dataLengthThreshold:(NSUInteger)dataLengthThreshold
                   includeAppIcon:(BOOL)includeAppIcon
NS_DESIGNATED_INITIALIZER;

@property (nonatomic, copy, readonly) NSString *appScheme;
@property (nonatomic, assign, readonly) NSUInteger dataLengthThreshold;
@property (nonatomic, assign, readonly, getter=shouldIncludeAppIcon) BOOL includeAppIcon;
@property (nonatomic, strong, readonly) id<FBSDKPasteboard> pasteboard;

@end

#endif
