//
//  UIViewController+ShareApplication.m
//  
//
//  Created by Howard on 2015/11/2.
//  Copyright © 2015年 Penpower. All rights reserved.
//

#import "UIViewController+ShareApplication.h"

@implementation UIViewController (ShareApplication)


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Method

//================================================================================
//
//================================================================================
- (UIViewController*)topViewControllerWithRootViewController:(UIViewController*)rootViewController
{
    if ([rootViewController isKindOfClass:[UITabBarController class]])
    {
        UITabBarController* tabBarController = (UITabBarController*)rootViewController;
        return [self topViewControllerWithRootViewController:tabBarController.selectedViewController];
    }
    else if ([rootViewController isKindOfClass:[UINavigationController class]])
    {
        UINavigationController* navigationController = (UINavigationController*)rootViewController;
        return [self topViewControllerWithRootViewController:navigationController.visibleViewController];
    }
    else if (rootViewController.presentedViewController) {
        UIViewController* presentedViewController = rootViewController.presentedViewController;
        return [self topViewControllerWithRootViewController:presentedViewController];
    }
    else
    {
        return rootViewController;
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//===============================================================================
//
//===============================================================================
- (CGRect)layoutFrame
{
    CGRect layoutFrame = self.view.bounds;
    
    //////////////////////////////////////////////////
    // 當ParentViewController不為nil，且又不是NavigationController及TabBarController時
    // 表示這個Controller被放在其他Controller中(ex PPScrollTabController)，這時原本的layoutFrame計算結果會有錯
    // 這時就直接回傳self.view.bounds，layoutFrame交由parentViewController來考慮
    
    if (self.parentViewController)
    {
        if ([self.parentViewController isKindOfClass:[UINavigationController class]] == NO &&
            [self.parentViewController isKindOfClass:[UITabBarController class]] == NO)
        {
            return layoutFrame;
        }
    }
    
    //////////////////////////////////////////////////
    
    if(self.navigationController!=nil)
    {
        if(self.navigationController.navigationBarHidden==NO)
        {
            if(self.navigationController.navigationBar.translucent==YES)
            {
                CGRect convertNavigationBarFrame = [self.view convertRect:self.navigationController.navigationBar.bounds fromView:self.navigationController.navigationBar];
                
                layoutFrame.origin.y = (convertNavigationBarFrame.origin.y+convertNavigationBarFrame.size.height);
            }
        }
        else
        {
            if(self.navigationController.modalPresentationStyle==UIModalPresentationFullScreen && (self.wantsFullScreenLayout==YES || [[UIDevice currentDevice].systemVersion floatValue]>=7.0))
            {
                layoutFrame.origin.y = MIN([UIApplication sharedApplication].statusBarFrame.size.width, [UIApplication sharedApplication].statusBarFrame.size.height);
            }
        }
    }
    else
    {
        if(self.modalPresentationStyle==UIModalPresentationFullScreen && (self.wantsFullScreenLayout==YES || [[UIDevice currentDevice].systemVersion floatValue]>=7.0))
        {
            layoutFrame.origin.y = MIN([UIApplication sharedApplication].statusBarFrame.size.width, [UIApplication sharedApplication].statusBarFrame.size.height);
        }
    }
    
    layoutFrame.size.height -= layoutFrame.origin.y;
    
    //////////////////////////////////////////////////
    
    if(self.tabBarController!=nil && self.tabBarController.tabBar.alpha!=0 && self.tabBarController.tabBar.hidden==NO && self.hidesBottomBarWhenPushed==NO)
    {
        CGRect convertTabBarFrame = [self.view convertRect:self.tabBarController.tabBar.bounds fromView:self.tabBarController.tabBar];
        
        layoutFrame.size.height = convertTabBarFrame.origin.y-layoutFrame.origin.y;
    }
    
    //////////////////////////////////////////////////
    
    return layoutFrame;
}

//================================================================================
//
//================================================================================
- (UIViewController *)topMostViewController
{
    return [self topViewControllerWithRootViewController:self];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

//================================================================================
//
//================================================================================
+ (UIViewController *)topMostViewController
{
    return [[UIApplication sharedApplication].keyWindow.rootViewController topMostViewController];
}

@end
