//
//  UIView+Screenshot.m
//
//  Created by Egg on 2015/3/6.
//  Copyright (c) 2015年 com.penpower. All rights reserved.
//

#import "UIView+Screenshot.h"

@implementation UIView(Screenshot)

//================================================================================
//
//================================================================================
- (UIImage *)screenshot
{
    UIGraphicsBeginImageContextWithOptions(self.bounds.size, NO, 0);
    [self.layer renderInContext:UIGraphicsGetCurrentContext()];
    UIImage *image = UIGraphicsGetImageFromCurrentImageContext();
    UIGraphicsEndImageContext();
    
    return image;    
}


//================================================================================
//
//================================================================================
- (UIImage *)screenshotForRect:(CGRect)rect
{
    UIGraphicsBeginImageContextWithOptions(rect.size, NO, 0);
   
    CGContextRef context = UIGraphicsGetCurrentContext();
    CGContextConcatCTM(context, CGAffineTransformMakeTranslation(-rect.origin.x, -rect.origin.y));
    [self.layer renderInContext:context];
    UIImage *image = UIGraphicsGetImageFromCurrentImageContext();
    UIGraphicsEndImageContext();
    
    return image;
}
@end
