//
//  UIImage+PropertyDictionary.m
//  
//
//  Created by Mike on 13/5/20.
//  
//

#import "UIImage+PropertyDictionary.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - UIColorPropertyDictionary_Key

NSString *UIImagePropertyDictionary_Key_CapInsetsTop     = @"CapInsetsTop";
NSString *UIImagePropertyDictionary_Key_CapInsetsLeft    = @"CapInsetsLeft";
NSString *UIImagePropertyDictionary_Key_CapInsetsBottom  = @"CapInsetsBottom";
NSString *UIImagePropertyDictionary_Key_CapInsetsRight   = @"CapInsetsRight";

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation UIImage (PropertyDictionary)

//===============================================================================
//
//===============================================================================
+ (UIEdgeInsets)capInsetsForImageName:(NSString *)name
{
    UIEdgeInsets capInsets = UIEdgeInsetsZero;
    
    @autoreleasepool
    {
        do
        {
            if(name==nil)
            {
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            NSDictionary *capInsetsDictionary = [NSDictionary dictionaryWithContentsOfFile:[[NSBundle mainBundle] pathForResource:name ofType:@"plist"]];
            if(capInsetsDictionary==nil)
            {
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            NSNumber *capInsetsTopNumber = [capInsetsDictionary objectForKey:UIImagePropertyDictionary_Key_CapInsetsTop];
            if(capInsetsTopNumber==nil)
            {
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            NSNumber *capInsetsLeftNumber = [capInsetsDictionary objectForKey:UIImagePropertyDictionary_Key_CapInsetsLeft];
            if(capInsetsLeftNumber==nil)
            {
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            NSNumber *capInsetsBottomNumber = [capInsetsDictionary objectForKey:UIImagePropertyDictionary_Key_CapInsetsBottom];
            if(capInsetsBottomNumber==nil)
            {
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            NSNumber *capInsetsRightNumber = [capInsetsDictionary objectForKey:UIImagePropertyDictionary_Key_CapInsetsRight];
            if(capInsetsRightNumber==nil)
            {
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            capInsets = UIEdgeInsetsMake(capInsetsTopNumber.floatValue,
                                         capInsetsLeftNumber.floatValue,
                                         capInsetsBottomNumber.floatValue,
                                         capInsetsRightNumber.floatValue);
            
        }while(0);
    }
    
    return capInsets;
}

@end
