//
//  UIImage+Exif.m
//  Pods
//
//  Created by sanhue cheng on 25/10/2022.
//

#import "UIImage+Exif.h"

@implementation UIImage (Exif)






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - private


//==============================================================================
//
//==============================================================================
+ (NSDictionary *)dictionaryWithLocation:(CLLocation*)location
{
    if(location==nil)
    {
        return nil;
    }
    
    NSMutableDictionary *result = [NSMutableDictionary dictionary];
    
    CLLocationDegrees latitude = location.coordinate.latitude;
    CLLocationDegrees longitude = location.coordinate.longitude;
    
    NSString *latitudeRef = nil;
    NSString *longitudeRef = nil;
    
    if (latitude < 0.0) {
        latitude *= -1;
        latitudeRef = @"S";
    } else {
        latitudeRef = @"N";
    }
    
    if (longitude < 0.0) {
        longitude *= -1;
        longitudeRef = @"W";
    } else {
        longitudeRef = @"E";
    }
    
//    NSTimeZone      *timeZone   = [NSTimeZone timeZoneWithName:@"UTC"];
//    NSDateFormatter *formatter  = [[NSDateFormatter alloc] init];
//    [formatter setTimeZone:timeZone];
//    [formatter setDateFormat:@"HH:mm:ss.SS"];
//    [result setObject:[formatter stringFromDate:[location timestamp]] forKey:(NSString*)kCGImagePropertyGPSTimeStamp];
//    [formatter release];

    [result setObject:location.timestamp forKey:(NSString*)kCGImagePropertyGPSTimeStamp];
    [result setObject:latitudeRef forKey:(NSString*)kCGImagePropertyGPSLatitudeRef];
    [result setObject:@(latitude) forKey:(NSString*)kCGImagePropertyGPSLatitude];
    
    [result setObject:longitudeRef forKey:(NSString*)kCGImagePropertyGPSLongitudeRef];
    [result setObject:@(longitude) forKey:(NSString*)kCGImagePropertyGPSLongitude];
    
    [result setObject:@(location.horizontalAccuracy) forKey:(NSString*)kCGImagePropertyGPSDOP];
    [result setObject:@(location.altitude) forKey:(NSString*)kCGImagePropertyGPSAltitude];
    
    return result;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - public

//==============================================================================
//
//==============================================================================
+ (NSData *)imageDataWithWithLocation:(CLLocation*)location sourceImageData:(NSData*)sourceImageData
{
    if(location==nil)
    {
        return sourceImageData;
    }
    
    //get all the metadata in the image
    NSDictionary *metadata = [UIImage metaDictionaryFromImageData:sourceImageData];
    NSMutableDictionary *metadataAsMutable = [[metadata mutableCopy]autorelease];

    //    NSLog(@"metadata:%@", metadata);
    
    NSDictionary *GPSDictionary = [UIImage dictionaryWithLocation:location];
    if(GPSDictionary!=nil)
    {
        [metadataAsMutable setObject:GPSDictionary forKey:(NSString *)kCGImagePropertyGPSDictionary];
//        NSLog(@"metadataAsMutable:%@", metadataAsMutable);
    }


    //////////////////////////////////////////////////
    
    return [UIImage imageDataWithWithMetaDictionary:metadataAsMutable sourceImageData:sourceImageData];
}


//==============================================================================
//
//==============================================================================
+ (NSData *)imageDataWithWithMetaDictionary:(NSDictionary *)metaDictionary sourceImageData:(NSData*)sourceImageData
{
    CGImageSourceRef  source  = CGImageSourceCreateWithData((CFDataRef)sourceImageData, nil);
    
    CFStringRef UTI = CGImageSourceGetType(source); //this is the type of image (e.g., public.jpeg)
    
    //this will be the data CGImageDestinationRef will write into
    NSMutableData *dest_data = [NSMutableData data];
    
    CGImageDestinationRef destination = CGImageDestinationCreateWithData((CFMutableDataRef)dest_data,UTI,1,NULL);
    
    if(!destination) {
        NSLog(@"***Could not create image destination ***");
        CFRelease(destination);
        CFRelease(source);
        return nil;
    }
    
    //add the image contained in the image source to the destination, overidding the old metadata with our modified metadata
    CGImageDestinationAddImageFromSource(destination,source,0, (CFDictionaryRef) metaDictionary);
    
    //tell the destination to write the image data and metadata into our data object.
    //It will return false if something goes wrong
    BOOL success = NO;
    success = CGImageDestinationFinalize(destination);
    
    if(!success) {
        NSLog(@"***Could not create data from image destination ***");
        CFRelease(destination);
        CFRelease(source);
        return nil;
    }

    //cleanup
    
    CFRelease(destination);
    CFRelease(source);
    return dest_data;
}



//==============================================================================
//
//==============================================================================
+ (NSDictionary *)metaDictionaryFromImageData:(NSData*)imageData
{
    CGImageSourceRef gpssource  = CGImageSourceCreateWithData((CFDataRef)imageData, nil);
    
    //get all the metadata in the image
    NSDictionary *metadta = (NSDictionary *)CGImageSourceCopyPropertiesAtIndex(gpssource,0,NULL);

    CFRelease(gpssource);
    
    return [metadta autorelease];
}

@end
