//
//  UIImage+Blur.m
//
//  Created by Egg on 2015/3/5.
//  Copyright (c) 2015年 com.penpower. All rights reserved.
//

#import "UIImage+Blur.h"
#import <Accelerate/Accelerate.h>

@implementation UIImage(Blur)

//================================================================================
//
//================================================================================
- (UIImage *)blurByNumberOfPoints:(NSUInteger)numberOfPoints
{
    
    NSInteger index = numberOfPoints * 2 * self.scale + 1;
    int16_t kernel[index];
    for (NSInteger i = 0; i < index; ++i)
    {
        kernel[i] = 1;
    }
    
    UIGraphicsBeginImageContextWithOptions(self.size, NO, self.scale);
    CGContextRef ctx = UIGraphicsGetCurrentContext();
    [self drawAtPoint:CGPointZero];
    
    size_t width = CGBitmapContextGetWidth(ctx);
    size_t height = CGBitmapContextGetHeight(ctx);
    size_t bytesPerRow = CGBitmapContextGetBytesPerRow(ctx);
    
    UInt8 *data = CGBitmapContextGetData(ctx);
    
    vImage_Buffer src = {data, height, width, bytesPerRow};
    
    vImageConvolve_ARGB8888(&src, &src, NULL, 0, 0, kernel , (uint32_t)index, 1, (uint32_t)index, NULL, kvImageEdgeExtend);
    vImageConvolve_ARGB8888(&src, &src, NULL, 0, 0, kernel, 1, (uint32_t)index, (uint32_t)index, NULL, kvImageEdgeExtend);
    
    UIImage *blurImage = UIGraphicsGetImageFromCurrentImageContext();
    UIGraphicsEndImageContext();
    
    return blurImage;
}


//================================================================================
//
//================================================================================
- (UIImage *)gaussianBlur
{
    
    static int16_t gaussianblur_kernel[13] =
    {
        1, 12, 66, 220, 495, 792, 924, 792, 495, 220, 66, 12, 1
    };
    
    UIGraphicsBeginImageContextWithOptions(self.size, NO, self.scale);
    CGContextRef ctx = UIGraphicsGetCurrentContext();
    [self drawAtPoint:CGPointZero];
    
    size_t width = CGBitmapContextGetWidth(ctx);
    size_t height = CGBitmapContextGetHeight(ctx);
//    size_t bitsPerComponent = CGBitmapContextGetBitsPerComponent(ctx);
//    size_t bitsPerPixcel = CGBitmapContextGetBitsPerPixel(ctx);
    size_t bytesPerRow = CGBitmapContextGetBytesPerRow(ctx);
    
    //    NSLog(@"%ld, %ld, %ld, %ld, %ld", width, height, bitsPerComponent, bitsPerPixcel, bytesPerRow);
    
    UInt8 *data = CGBitmapContextGetData(ctx);
    
    vImage_Buffer src = {data, height, width, bytesPerRow};
    
    vImageConvolve_ARGB8888(&src, &src, NULL, 0, 0, gaussianblur_kernel, 13, 1, 4096, NULL, kvImageEdgeExtend);
    vImageConvolve_ARGB8888(&src, &src, NULL, 0, 0, gaussianblur_kernel, 1, 13, 4096, NULL, kvImageEdgeExtend);
    
    UIImage *blurImage = UIGraphicsGetImageFromCurrentImageContext();
    UIGraphicsEndImageContext();
    
    return blurImage;
}


@end
