//
//  UIImage+Blur.h
//
//  Created by Egg on 2015/3/5.
//  Copyright (c) 2015年 com.penpower. All rights reserved.
//

#import <UIKit/UIKit.h>

@interface UIImage(Blur)

/**
 *  Return image with blur effect by number of Points
 *
 *  @param numberOfPoints Blur effect increases as numberOfPoints gets larger.
 *
 *  @return Image with blur effect.
 */
- (UIImage *)blurByNumberOfPoints:(NSUInteger)numberOfPoints;

/**
 *  Return image with gaussian blur.
 *
 *  @return Image
 */
- (UIImage *)gaussianBlur;


@end
