//
//  UIImage+BITMAPPTR.m
//  
//
//  Created by Mike on 13/5/6.
//  
//

#import "UIImage+BITMAPPTR.h"
#import "UIImage+Additions.h"

@implementation UIImage (BITMAPPTR)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Methods

//===============================================================================
//
//===============================================================================
- (NSData *)bmpData
{
    NSData *bmpData = nil;
    
    //////////////////////////////////////////////////
    
    BITMAPPTR bitmapPTR;
    bitmapPTR.pHeader   = NULL;
    bitmapPTR.pQuad     = NULL;
    bitmapPTR.pBmp      = NULL;
    
    if([UIImage createBitmapPTR:&bitmapPTR image:self]==YES)
    {
        bmpData = [UIImage bmpDataWithBitmapPTR:&bitmapPTR];
        
        [UIImage releaseBitmapPTR:&bitmapPTR];
    }
    
    //////////////////////////////////////////////////
    
    return bmpData;
}


//===============================================================================
//
//===============================================================================
- (NSData *)rgbaData
{
    NSData *rgbaData = nil;
    
    CGColorSpaceRef colorSpace = CGColorSpaceCreateDeviceRGB();
    
    if(colorSpace!=NULL)
    {
        CGContextRef context = CGBitmapContextCreate(NULL,
                                                     self.size.width,
                                                     self.size.height,
                                                     8,
                                                     self.size.width*4,
                                                     colorSpace,
                                                     kCGBitmapAlphaInfoMask&kCGImageAlphaNoneSkipLast);//kCGImageAlphaNoneSkipFirst|kCGBitmapByteOrder32Big);//
        
        if(context!=NULL)
        {
            CGContextScaleCTM(context, 1, -1);
            CGContextDrawImage(context, CGRectMake(0, 0, self.size.width, -self.size.height), self.CGImage);
            
            Byte *rgbaBytes = CGBitmapContextGetData(context);
            
            if(rgbaBytes!=NULL)
            {
                rgbaData = [NSData dataWithBytes:rgbaBytes length:CGBitmapContextGetHeight(context)*CGBitmapContextGetBytesPerRow(context)];
            }
            
            CGContextRelease(context);
        }
        
        CGColorSpaceRelease(colorSpace);
    }
    
    return rgbaData;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Methods

//===============================================================================
//
//===============================================================================
+ (BOOL)createBitmapPTR:(PBITMAPPTR)pBitmapPTR width:(CGFloat)width height:(CGFloat)height bitCount:(NSUInteger)bitCount
{
    BOOL result = NO;
    
    do
    {
        if(pBitmapPTR==NULL || (bitCount!=1 && bitCount!=2 && bitCount!=4 && bitCount!=8 && bitCount!=16 && bitCount!=24 && bitCount!=32))
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSUInteger bytesPerRow = [UIImage bytesPerRowWithWidth:width bitCount:bitCount];
        if(bytesPerRow==0)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        uint32_t colorUsed = 0;
        if(bitCount<24)
        {
            colorUsed = 1<<bitCount;
        }
        
        //////////////////////////////////////////////////
        
        CGFloat sizeImage = fabs(height)*bytesPerRow;
        
        pBitmapPTR->pHeader = (PBITMAPINFOHEADER)malloc(sizeof(BITMAPINFOHEADER)+(colorUsed*sizeof(RGBQUAD))+sizeImage);
        
        if(pBitmapPTR->pHeader!=NULL)
        {
            pBitmapPTR->pQuad   = (PRGBQUAD)(((Byte *)(pBitmapPTR->pHeader))+sizeof(BITMAPINFOHEADER));
            pBitmapPTR->pBmp    = (PBYTE)((Byte *)(pBitmapPTR->pQuad)+(colorUsed*sizeof(RGBQUAD)));
            
            //////////////////////////////////////////////////
            //設定BitmapInfoHeader
            
            pBitmapPTR->pHeader->biSize             = sizeof(BITMAPINFOHEADER);
            pBitmapPTR->pHeader->biWidth            = width;
            pBitmapPTR->pHeader->biHeight           = height;
            pBitmapPTR->pHeader->biPlanes           = 1;
            pBitmapPTR->pHeader->biBitCount         = bitCount;
            pBitmapPTR->pHeader->biCompression      = 0;
            pBitmapPTR->pHeader->biSizeImage        = sizeImage;
            pBitmapPTR->pHeader->biXPelsPerMeter    = 0;
            pBitmapPTR->pHeader->biYPelsPerMeter    = 0;
            pBitmapPTR->pHeader->biClrUsed          = colorUsed;
            pBitmapPTR->pHeader->biClrImportant     = 0;
            
            //////////////////////////////////////////////////
            
            switch(pBitmapPTR->pHeader->biBitCount)
            {
                case 1:
                {
                    pBitmapPTR->pQuad[0].rgbBlue        = 0;
                    pBitmapPTR->pQuad[0].rgbGreen       = 0;
                    pBitmapPTR->pQuad[0].rgbRed         = 0;
                    pBitmapPTR->pQuad[0].rgbReserved    = 0;
                    
                    pBitmapPTR->pQuad[1].rgbBlue        = 255;
                    pBitmapPTR->pQuad[1].rgbGreen       = 255;
                    pBitmapPTR->pQuad[1].rgbRed         = 255;
                    pBitmapPTR->pQuad[1].rgbReserved    = 0;
                    
                    break;
                }
                case 2:
                {
                    break;
                }
                case 4:
                {
                    break;
                }
                case 8:
                {
                    break;
                }
                case 24:
                case 32:
                default:
                {
                    //無調色盤
                    break;
                }
            }
        }
        
        //////////////////////////////////////////////////
        
        result = YES;
        
    }while(0);
    
    return result;
}


//===============================================================================
//
//===============================================================================
+ (BOOL)createBitmapPTR:(PBITMAPPTR)pBitmapPTR withBitCount:(NSInteger)bitCount image:(UIImage *)image
{
    BOOL result = NO;
    
    do
    {
        if(pBitmapPTR==NULL || image==nil)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        NSData *rgbaData = [image rgbaData];
        
        if(rgbaData==nil)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        if([UIImage createBitmapPTR:pBitmapPTR width:(NSUInteger)image.size.width height:(NSUInteger)image.size.height bitCount:bitCount]==NO)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        Byte *rgbaBytes = (Byte *)[rgbaData bytes];
        
        
        switch (bitCount)
        {
            case 1:
            {
                break;
            }
            case 24:
            {
                NSUInteger rgbBytesPerRow  = (((pBitmapPTR->pHeader->biWidth*3)+3UL)>>2)<<2;	//bitmap RGB data每一列要是4的倍數
                NSUInteger rgbaBytesPerRow = pBitmapPTR->pHeader->biWidth*4;
                
                for(NSUInteger row=0; row<abs(pBitmapPTR->pHeader->biHeight); row++)
                {
                    for(NSUInteger column=0; column<pBitmapPTR->pHeader->biWidth; column++)
                    {
                        NSUInteger rgbByteIndex    = (row*rgbBytesPerRow)+(column*3);
                        NSUInteger rgbaByteIndex	= (row*rgbaBytesPerRow)+(column*4);
                        
                        //BMP是BGR,所以RGBA要轉換一下
                        pBitmapPTR->pBmp[rgbByteIndex+2] = rgbaBytes[rgbaByteIndex+0];
                        pBitmapPTR->pBmp[rgbByteIndex+1] = rgbaBytes[rgbaByteIndex+1];
                        pBitmapPTR->pBmp[rgbByteIndex+0] = rgbaBytes[rgbaByteIndex+2];
                    }
                }
                
                result = YES;
                break;
            }
            case 32:
            {
                memcpy(pBitmapPTR->pBmp, rgbaBytes, [rgbaData length]);
                
                result = YES;
                break;
            }
            default:
            {
                break;
            }
        }
        
    } while (0);
   
    return result;
}


//===============================================================================
//
//===============================================================================
+ (BOOL)createBitmapPTR:(PBITMAPPTR)pBitmapPTR image:(UIImage *)image
{
    BOOL result = NO;
    
    do
    {
        if(pBitmapPTR==NULL || image==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSData *dataOfRGBA = [image dataOfRGBA];
        if(dataOfRGBA==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([UIImage createBitmapPTR:pBitmapPTR width:(NSInteger)image.size.width height:(NSInteger)image.size.height bitCount:24]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        Byte *bytesOfRGBA = (Byte *)[dataOfRGBA bytes];
        
        NSUInteger bytesPerRowOfRGB  = [UIImage bytesPerRowWithWidth:pBitmapPTR->pHeader->biWidth bitCount:24];
        NSUInteger bytesPerRowOfRGBA = [UIImage bytesPerRowWithWidth:pBitmapPTR->pHeader->biWidth bitCount:32];
        
        for(NSUInteger row=0; row<abs(pBitmapPTR->pHeader->biHeight); row++)
        {
            for(NSUInteger column=0; column<pBitmapPTR->pHeader->biWidth; column++)
            {
                NSUInteger byteIndexOfRGBA	= (row*bytesPerRowOfRGBA)+(column*4);
                NSUInteger byteIndexOfRGB;
                
                if(pBitmapPTR->pHeader->biHeight>0)
                {
                    byteIndexOfRGB = (row*bytesPerRowOfRGB)+(column*3);
                }
                else
                {
                    byteIndexOfRGB = ((abs(pBitmapPTR->pHeader->biHeight)-row-1)*bytesPerRowOfRGB)+(column*3);
                }
                
                //BMP是BGR,所以RGBA要轉換一下
                pBitmapPTR->pBmp[byteIndexOfRGB+2] = bytesOfRGBA[byteIndexOfRGBA+0];
                pBitmapPTR->pBmp[byteIndexOfRGB+1] = bytesOfRGBA[byteIndexOfRGBA+1];
                pBitmapPTR->pBmp[byteIndexOfRGB+0] = bytesOfRGBA[byteIndexOfRGBA+2];
            }
        }
        
        //////////////////////////////////////////////////
        
        result = YES;
        
    }while(0);
    
    return result;
}

//===============================================================================
//
//===============================================================================
+ (BOOL)releaseBitmapPTR:(PBITMAPPTR)pBitmapPTR
{
    BOOL result = NO;
    
    if(pBitmapPTR!=NULL)
    {
        if(pBitmapPTR->pHeader!=NULL)
        {
            free(pBitmapPTR->pHeader);
            pBitmapPTR->pHeader = NULL;
        }
        
        if(pBitmapPTR->pQuad!=NULL)
        {
            pBitmapPTR->pQuad = NULL;
        }
        
        if(pBitmapPTR->pBmp!=NULL)
        {
            pBitmapPTR->pBmp = NULL;
        };
        
        result = YES;
    }
    
    return result;
}

//===============================================================================
//
//===============================================================================
+ (NSData *)bmpDataWithBitmapPTR:(PBITMAPPTR)pBitmapPTR
{
    NSMutableData *bmpData = nil;
    
    do
    {
        if(pBitmapPTR==NULL || pBitmapPTR->pHeader==NULL || pBitmapPTR->pBmp==NULL || (pBitmapPTR->pHeader->biBitCount<24 && pBitmapPTR->pQuad==NULL))
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        bmpData = [[[NSMutableData alloc] init] autorelease];
        
        if(bmpData!=nil)
        {
            BITMAPFILEHEADER bitmapFileHeader;
            bitmapFileHeader.bfType         = BF_TYPE;
            bitmapFileHeader.bfReserved1    = 0;
            bitmapFileHeader.bfReserved2    = 0;
            
            if(pBitmapPTR->pHeader->biBitCount<24)
            {
                bitmapFileHeader.bfOffBits = 14+sizeof(BITMAPINFOHEADER)+((1<<pBitmapPTR->pHeader->biBitCount)*sizeof(RGBQUAD));
            }
            else
            {
                //沒有調色盤
                bitmapFileHeader.bfOffBits = 14+sizeof(BITMAPINFOHEADER);
            }
            
            //////////////////////////////////////////////////
            //核心給的biSizeImage都不對,所以重新自己算一次
            
            pBitmapPTR->pHeader->biSizeImage = (DWORD)[UIImage bytesPerRowWithWidth:pBitmapPTR->pHeader->biWidth bitCount:pBitmapPTR->pHeader->biBitCount]*abs(pBitmapPTR->pHeader->biHeight);
            
            //////////////////////////////////////////////////
            
            bitmapFileHeader.bfSize = bitmapFileHeader.bfOffBits+pBitmapPTR->pHeader->biSizeImage;
            
            //////////////////////////////////////////////////
            //BITMAPFILEHEADER
            
            [bmpData appendBytes:&bitmapFileHeader.bfType       length:sizeof(WORD)];
            [bmpData appendBytes:&bitmapFileHeader.bfSize       length:sizeof(DWORD)];
            [bmpData appendBytes:&bitmapFileHeader.bfReserved1  length:sizeof(WORD)];
            [bmpData appendBytes:&bitmapFileHeader.bfReserved2  length:sizeof(WORD)];
            [bmpData appendBytes:&bitmapFileHeader.bfOffBits    length:sizeof(DWORD)];
            
            //////////////////////////////////////////////////
            //BITMAPINFOHEADER
            
            [bmpData appendBytes:pBitmapPTR->pHeader length:sizeof(BITMAPINFOHEADER)];
            
            //////////////////////////////////////////////////
            //RGBQUAD
            
            if(pBitmapPTR->pHeader->biBitCount<24)
            {
                [bmpData appendBytes:pBitmapPTR->pQuad length:((1<<pBitmapPTR->pHeader->biBitCount)*sizeof(RGBQUAD))];
            }
            
            //////////////////////////////////////////////////
            //Bitmap Array
            
            [bmpData appendBytes:pBitmapPTR->pBmp length:pBitmapPTR->pHeader->biSizeImage];
        }
        
    }while(0);
    
    return bmpData;
}

//===============================================================================
//
//===============================================================================
+ (UIImage *)imageWithBitmapPTR:(PBITMAPPTR)pBitmapPTR
{
    UIImage *image = nil;
    
    do
    {
        if(pBitmapPTR==NULL)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSData *bmpData = [UIImage bmpDataWithBitmapPTR:pBitmapPTR];
        if(bmpData==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        image = [UIImage imageWithData:bmpData];
        
    }while(0);
    
    return image;
}

@end
