//
//  UIColor+BlendColor.m
//

#import "UIColor+BlendColor.h"

@implementation UIColor (BlendColor)

//================================================================================
//
//================================================================================
- (UIColor *)colorWithBlendColor:(UIColor *)color ratio:(CGFloat)ratio
{
    CGFloat r1 = 0.0;
    CGFloat g1 = 0.0;
    CGFloat b1 = 0.0;
    CGFloat a1 = 0.0;
    
    CGFloat r2 = 0.0;
    CGFloat g2 = 0.0;
    CGFloat b2 = 0.0;
    CGFloat a2 = 0.0;
    
    [self getRed:&r1 green:&g1 blue:&b1 alpha:&a1];
    [color getRed:&r2 green:&g2 blue:&b2 alpha:&a2];
    
    CGFloat r0;
    CGFloat g0;
    CGFloat b0;
    CGFloat a0;
    
    
    if(a1 == 0)
    {
        r0 = r2;
        g0 = g2;
        b0 = b2;
        a0 = ratio*a2;
    }
    else if(a2 == 0)
    {
        r0 = r1;
        g0 = g1;
        b0 = b1;
        a0 = (1.0-ratio)*a1;
    }
    else
    {
        r0 = (1.0-ratio)*r1 + ratio*r2;
        g0 = (1.0-ratio)*g1 + ratio*g2;
        b0 = (1.0-ratio)*b1 + ratio*b2;
        a0 = (1.0-ratio)*a1 + ratio*a2;
    }
    
    return [UIColor colorWithRed:r0 green:g0 blue:b0 alpha:a0];
}

@end
