//
//  UIApplication+URL.m
//  
//
//  Created by Mike on 13/12/20.
//  
//

#import "UIApplication+URL.h"

@implementation UIApplication (URL)

//===============================================================================
//
//===============================================================================
+ (NSString *)dialStringFromPhoneNumber:(NSString *)phoneNumber
{
    //轉換分機號碼
    NSString *extSymbol = @",";
	phoneNumber = [phoneNumber stringByReplacingOccurrencesOfString:@"#" withString:extSymbol];
	phoneNumber = [phoneNumber stringByReplacingOccurrencesOfString:@"*" withString:extSymbol];
    
    //////////////////////////////////////////////////
    
	return [[phoneNumber componentsSeparatedByCharactersInSet:[NSCharacterSet whitespaceCharacterSet]] componentsJoinedByString:@""];
}

//===============================================================================
//
//===============================================================================
+ (NSString *)googleMapStringFromAddress:(NSString *)address
{
    NSString *googleMapString = @"";
    
    //////////////////////////////////////////////////
    
    do
    {
        if(address==nil || [address length]==0)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        //移除 newline
        
        googleMapString = [[address componentsSeparatedByCharactersInSet:[NSCharacterSet newlineCharacterSet]] componentsJoinedByString:@" "];
        
        //////////////////////////////////////////////////
        //檢查是否有 '巷' (從後面找)
        
        NSRange range = [googleMapString rangeOfCharacterFromSet:[NSCharacterSet characterSetWithCharactersInString:@"巷"] options:NSBackwardsSearch];
        if(range.length>0)
        {
            //移除 '巷' 後面的地址
            googleMapString = [googleMapString substringToIndex:range.location+1];
        }
        else
        {
            //檢查是否有 '號' (從後面找)
            range = [googleMapString rangeOfCharacterFromSet:[NSCharacterSet characterSetWithCharactersInString:@"號号"] options:NSBackwardsSearch];
            if(range.length>0)
            {
                // 移除 '號' 後面的地址
                googleMapString = [googleMapString substringToIndex:range.location+1];
            }
        }
        
        //////////////////////////////////////////////////
        // !!日本地址特殊處理(從後面開始找'-'，如果'-'的前後都是數字，就把'-'之後最後一個數字以外的字去掉，如西新宿6-8-13住友不動產 => 西新宿6-8-13。)

        range = [googleMapString rangeOfCharacterFromSet:[NSCharacterSet characterSetWithCharactersInString:@"-"] options:NSBackwardsSearch];
        if(range.length>0)
        {
            NSCharacterSet  *numberCharacterSet = [NSCharacterSet characterSetWithCharactersInString:@"0123456789"];
            unichar         prevCharacter       = [googleMapString characterAtIndex:range.location-1];
            unichar         nextCharacter       = [googleMapString characterAtIndex:range.location+1];
            unichar         zipCharacter        = [@"〒" characterAtIndex:0];
            
            // 需要進行處理的條件
            if([googleMapString length]>5                                           &&
               range.location>[googleMapString length]/2                            &&  // '-'的位置超過地址長度的一半
               [googleMapString characterAtIndex:range.location-4]!=zipCharacter    &&  // '-'往前第4個字元不是'〒'
               [googleMapString characterAtIndex:range.location-5]!=zipCharacter    &&  // '-'往前第5個字元不是'〒'
               [numberCharacterSet characterIsMember:prevCharacter]                 &&  // '-'前一個字元是數字
               [numberCharacterSet characterIsMember:nextCharacter]                 )   // '-'後一個字元是數字
            {
                NSUInteger lastCharacterIndex = range.location+1;
                
                for(lastCharacterIndex++; lastCharacterIndex<[googleMapString length]; lastCharacterIndex++)
                {
                    if([numberCharacterSet characterIsMember:[googleMapString characterAtIndex:lastCharacterIndex]]==NO)
                    {
                        break;
                    }
                }
                
                //把'-'之後最後一個數字以外的字去掉
                googleMapString = [googleMapString substringToIndex:lastCharacterIndex];
            }
        }
        
        //////////////////////////////////////////////////
        // 檢查最後是否是空格加逗號
        
        if([googleMapString hasSuffix:@" ,"]==YES)
        {
            googleMapString = [googleMapString substringToIndex:[googleMapString length]-1];
        }
        
    }while(0);
    
    //////////////////////////////////////////////////
    
	return googleMapString;
}

//===============================================================================
//
//===============================================================================
+ (BOOL)canOpenURLType:(UIApplicationURLType)type
{
    BOOL result = NO;
    
    //////////////////////////////////////////////////
    
    do
    {
        UIApplication *application = [UIApplication sharedApplication];
        if(application==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSString *string = nil;
        
        switch(type)
        {
            case UIApplicationURLType_Email:
            {
                string = @"mailto:";
                break;
            }
            case UIApplicationURLType_Facebook:
            {
                string = @"https://m.facebook.com/findfriends/search/?q=";
                break;
            }
            case UIApplicationURLType_FaceTime:
            {
                string = @"facetime://";
                break;
            }
            case UIApplicationURLType_GoogleMap:
            {
                string = @"http://maps.google.com/maps?ie=utf8&q=";
                break;
            }
            case UIApplicationURLType_BaiduMap:
            {
                string = @"http://api.map.baidu.com/geocoder?output=html&address=";
                break;
            }
            case UIApplicationURLType_LinkedIn:
            {
                string = @"http://www.linkedin.com/pub/dir/?";
                break;
            }
            case UIApplicationURLType_NaviCon:
            {
                string = @"navicon://navicon.denso.co.jp/setPOI?ver=1.2&addr=";
                break;
            }
            case UIApplicationURLType_SMS:
            {
                string = @"sms:";
                break;
            }
            case UIApplicationURLType_Tel:
            {
                string = @"tel:";
                break;
            }
            case UIApplicationURLType_Twitter:
            {
                string = @"https://mobile.twitter.com/search?q=";
                break;
            }
            case UIApplicationURLType_Web:
            {
                string = @"http://";
                break;
            }
            case UIApplicationURLType_Skype:
            {
                string = @"skype:";
                
                break;
            }
            case UIApplicationURLType_None:
            default:
            {
                break;
            }
        }
        
        //////////////////////////////////////////////////
        
        if(string!=nil && [string length]>0)
        {
            result = [application canOpenURL:[NSURL URLWithString:string]];
        }
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    return result;
}

//===============================================================================
//
//===============================================================================
+ (BOOL)openURLType:(UIApplicationURLType)type withParameter:(NSString *)parameter
{
    BOOL result = NO;
    NSString *urlParam = nil;
    
    
    do
    {
        //////////////////////////////////////////////////
        
        UIApplication *application = [UIApplication sharedApplication];
        
        if(application==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        // remove scpace characters in prefix
        
        if([parameter length] == 0)
        {
            break;
        }

        urlParam = [NSString stringWithString:parameter];
        
        while ([urlParam hasPrefix:@" "] == YES)
        {
            urlParam = [urlParam substringFromIndex:1];
        }
        
        if(![urlParam length])
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSString *string = nil;
        
        switch(type)
        {
            case UIApplicationURLType_Email:
            {
                string = @"mailto:";
                
                //////////////////////////////////////////////////
                
                if([application canOpenURL:[NSURL URLWithString:string]]==NO)
                {
                    break;
                }
                
                //////////////////////////////////////////////////
                
                string = [string stringByAppendingString:urlParam];
                
                break;
            }
                
            case UIApplicationURLType_Facebook:
            {
                string = @"https://m.facebook.com/findfriends/search/?q=";
                
                //////////////////////////////////////////////////
                
                if([application canOpenURL:[NSURL URLWithString:string]]==NO)
                {
                    break;
                }
                
                //////////////////////////////////////////////////
                
                string = [string stringByAppendingString:[urlParam stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding]];
                
                break;
            }
                
            case UIApplicationURLType_FaceTime:
            {
                string = @"facetime://";
                
                //////////////////////////////////////////////////
                
                if([application canOpenURL:[NSURL URLWithString:string]]==NO)
                {
                    break;
                }
                
                //////////////////////////////////////////////////
                
                string = [string stringByAppendingString:[urlParam stringByReplacingOccurrencesOfString:@" " withString:@""]];
                
                break;
            }
                
            case UIApplicationURLType_GoogleMap:
            {
                string = @"http://maps.google.com/maps?ie=utf8&q=";
                
                //////////////////////////////////////////////////
                
                if([application canOpenURL:[NSURL URLWithString:string]]==NO)
                {
                    break;
                }
                
                //////////////////////////////////////////////////
                
                // !! 使用核心提供的地址字串後，不需要呼叫googleMapStringFromAddress !!
//                parameter = [UIApplication googleMapStringFromAddress:parameter];
                if(urlParam==nil)
                {
                    urlParam = @"";
                }
                
                //////////////////////////////////////////////////
                
                string = [string stringByAppendingString:[urlParam stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding]];
                
                break;
            }
                
            case UIApplicationURLType_BaiduMap:
            {
                string = @"http://api.map.baidu.com/geocoder?output=html&address=";
                
                //////////////////////////////////////////////////
                
                if([application canOpenURL:[NSURL URLWithString:string]]==NO)
                {
                    break;
                }
                
                //////////////////////////////////////////////////
                
                // !! 使用核心提供的地址字串後，不需要呼叫googleMapStringFromAddress !!
//                parameter = [UIApplication googleMapStringFromAddress:parameter];
                if(urlParam==nil)
                {
                    urlParam = @"";
                }
                
                //////////////////////////////////////////////////
                
                string = [string stringByAppendingString:[urlParam stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding]];
                
                break;
            }
                
            case UIApplicationURLType_LinkedIn:
            {
                string = @"http://www.linkedin.com/pub/dir/?";

                //////////////////////////////////////////////////
                
                if([application canOpenURL:[NSURL URLWithString:string]]==NO)
                {
                    break;
                }
                
                //////////////////////////////////////////////////
                
                string = [string stringByAppendingString:[urlParam stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding]];
                
                break;
            }
                
            case UIApplicationURLType_NaviCon:
            {
                string = @"navicon://navicon.denso.co.jp/setPOI?ver=1.2&addr=";
                
                //////////////////////////////////////////////////
                
                if([application canOpenURL:[NSURL URLWithString:string]]==NO)
                {
                    break;
                }
                
                //////////////////////////////////////////////////
                
                string = [string stringByAppendingString:[urlParam stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding]];
                
                break;
            }
                
            case UIApplicationURLType_SMS:
            {
                string = @"sms:";
                
                //////////////////////////////////////////////////
                
                if([application canOpenURL:[NSURL URLWithString:string]]==NO)
                {
                    break;
                }
                
                //////////////////////////////////////////////////
                // !!部份語系號碼數小於3時無法撥號，但會回傳YES，再撥號就會當掉，所以要先濾掉。
                
                if([urlParam length]<3)
                {
                    break;
                }
                
                //////////////////////////////////////////////////
                
                string = [string stringByAppendingString:[UIApplication dialStringFromPhoneNumber:urlParam]];
                
                break;
            }
                
            case UIApplicationURLType_Tel:
            {
                string = @"tel:";
                
                //////////////////////////////////////////////////
                
                if([application canOpenURL:[NSURL URLWithString:string]]==NO)
                {
                    break;
                }
                
                //////////////////////////////////////////////////
                // !!部份語系號碼數小於3時無法撥號，但會回傳YES，再撥號就會當掉，所以要先濾掉。
                
                if([urlParam length]<3)
                {
                    break;
                }
                
                //////////////////////////////////////////////////
                
                string = [string stringByAppendingString:[UIApplication dialStringFromPhoneNumber:urlParam]];
                
                break;
            }
                
            case UIApplicationURLType_Twitter:
            {
                string = @"https://mobile.twitter.com/search?q=";
                
                //////////////////////////////////////////////////
                
                if([application canOpenURL:[NSURL URLWithString:string]]==NO)
                {
                    break;
                }
                
                //////////////////////////////////////////////////
                
                string = [string stringByAppendingString:[urlParam stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding]];
                
                break;
            }
                
            case UIApplicationURLType_Web:
            {
                string = @"http://";
                
                //////////////////////////////////////////////////
                
                if([application canOpenURL:[NSURL URLWithString:string]]==NO)
                {
                    break;
                }
                
                //////////////////////////////////////////////////
                
                if([urlParam rangeOfString:@"//"].length==0)
                {
                    string = [string stringByAppendingString:urlParam];
                }
                else
                {
                    string = urlParam;
                }

                break;
            }
            case UIApplicationURLType_Skype:
            {
                if([[UIApplication sharedApplication] canOpenURL:[NSURL URLWithString:@"skype:"]]==YES)
                {
                    string = [NSString stringWithFormat:@"skype:%@?call",parameter];
                }
      
                break;
            }
            case UIApplicationURLType_None:
            default:
            {
                break;
            }
        }
        
        //////////////////////////////////////////////////
        
        if(string!=nil && [string length]>0)
        {
            result = [application openURL:[NSURL URLWithString:string]];
        }
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    return result;
}

//===============================================================================
//
//===============================================================================
+ (NSString *)parameterForNaviConWithAddress:(NSString *)address appName:(NSString *)appName title:(NSString *)title text:(NSString *)text
{
    NSString *parameter = @"";
    
    //////////////////////////////////////////////////
    
    do
    {
        if(address==nil || [address length]==0)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        parameter = [UIApplication googleMapStringFromAddress:address];
        if(parameter==nil)
        {
            parameter = @"";
        }
        
        //////////////////////////////////////////////////
        
        if(appName!=nil && [appName length]>0)
        {
            parameter = [parameter stringByAppendingFormat:@"&appName=%@", appName];
        }

        if(title!=nil && [title length]>0)
        {
            parameter = [parameter stringByAppendingFormat:@"&title=%@", title];
        }
        
        if(text!=nil && [text length]>0)
        {
            parameter = [parameter stringByAppendingFormat:@"&text=%@", text];
        }
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    return parameter;
}

//===============================================================================
//
//===============================================================================
+ (NSString *)parameterForLinkedInWithFirstName:(NSString *)firstName lastName:(NSString *)lastName
{
    if(![firstName length] && ![lastName length])
    {
        return nil;
    }
    
    return [NSString stringWithFormat:@"first=%@&last=%@", (firstName==nil?@"":firstName), (lastName==nil?@"":lastName)];
}

@end
