//
//  UIActionSheet+Additions.m
//  
//
//  Created by Mike on 13/10/8.
//  
//

#import "UIActionSheet+Additions.h"

static char UIActionSheetAdditions_UserInfo;

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation UIActionSheet (Additions)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - dynamic

@dynamic
userInfo;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Methods

//================================================================================
//
//================================================================================
- (id)userInfo
{
    return objc_getAssociatedObject(self, &UIActionSheetAdditions_UserInfo);
}

//================================================================================
//
//================================================================================
- (void)setUserInfo:(id)userInfo
{
    objc_setAssociatedObject(self, &UIActionSheetAdditions_UserInfo, userInfo, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Methods

+ (BOOL)isVisible
{
    BOOL result = NO;
    
    NSArray *windows = [UIApplication sharedApplication].windows;
    
    for(UIWindow *window in windows)
    {
        NSArray *subviews = window.subviews;
        
        for(UIView *subview in subviews)
        {
            if([subview isKindOfClass:[UIActionSheet class]]==YES)
            {
                if(((UIActionSheet *)subview).isVisible==YES)
                {
                    result = YES;
                    break;
                }
            }
        }
        
        if(result==YES)
        {
            break;
        }
    }
    
    return result;
}

@end
