//
//  PHAsset+Image.m
//  WCNewCardFlowController
//
//  Created by sanhue cheng on 2020/10/8.
//

#import "PHAsset+Image.h"

@implementation PHAsset (Image)


//==============================================================================
// use semaphore to wait for image block complete
//==============================================================================
- (UIImage *)imageWithTagetSize:(CGSize)targetSize
{
    __block UIImage *resultImage = nil;
    __block dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
    [self fetchImageWithTargetSize:targetSize completeHandler:^(UIImage *result) {
        resultImage = [result retain];
        dispatch_semaphore_signal(semaphore);
    }];

    dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
    dispatch_release(semaphore);

    return [resultImage autorelease];
}


//==============================================================================
//
//==============================================================================
- (void)fetchImageWithTargetSize:(CGSize)targetSize completeHandler:(void(^)(UIImage *result))completeHandler
{
    //////////////////////////////////////////////////
    dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
        
        PHImageRequestOptions *imageRequestOptions = [[[PHImageRequestOptions alloc] init] autorelease];
        imageRequestOptions.resizeMode = PHImageRequestOptionsResizeModeExact;
        imageRequestOptions.deliveryMode = PHImageRequestOptionsDeliveryModeHighQualityFormat;
        imageRequestOptions.networkAccessAllowed = YES;
        imageRequestOptions.synchronous = YES;
        
        [[PHImageManager defaultManager] requestImageForAsset:self targetSize:targetSize contentMode:PHImageContentModeAspectFill options:imageRequestOptions resultHandler:^(UIImage * _Nullable result, NSDictionary * _Nullable info) {
            
            if(completeHandler)
            {
                //////////////////////////////////////////////////
                dispatch_async(dispatch_get_main_queue(), ^{
                    completeHandler(result);
                });
            }
        }];
    });
}


//==============================================================================
//
//==============================================================================
- (void)fetchThumbnailImageWithCompleteHandler:(void(^)(UIImage *result))completeHandler
{
    [self fetchImageWithTargetSize:CGSizeMake(150,150) completeHandler:completeHandler];
}
@end
