//
//  CLLocationManager+Permission.m
//  WCAMCaptureViewController
//
//  Created by sanhue cheng on 2021/7/20.
//

#import "CLLocationManager+Permission.h"
#import <CoreLocation/CoreLocation.h>


////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation CLLocationManager (Permission)



//==============================================================================
//
//==============================================================================
+ (void)checkPermissionWithWithViewController:(UIViewController *)viewController completeHandler:(void(^)(BOOL granted))completeHandler
{
    dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
        
        CLAuthorizationStatus status = [CLLocationManager authorizationStatus];
        switch (status) {
            case kCLAuthorizationStatusNotDetermined:
            {
                CLLocationManager *locationManager = [[[CLLocationManager alloc] init] autorelease];
                [locationManager requestWhenInUseAuthorization];
                
                while ([CLLocationManager authorizationStatus]==kCLAuthorizationStatusNotDetermined)
                {
                    [NSThread sleepForTimeInterval:0.1];
                }

                if(completeHandler)
                {
                    status = [CLLocationManager authorizationStatus];
                    BOOL grant = (status==kCLAuthorizationStatusAuthorizedAlways||
                                  status==kCLAuthorizationStatusAuthorizedWhenInUse);
                    //////////////////////////////////////////////////
                    dispatch_async(dispatch_get_main_queue(), ^{
                        completeHandler(grant);
                    });
                }

                break;
            }
            case kCLAuthorizationStatusRestricted:
            case kCLAuthorizationStatusDenied:
            {
                if(completeHandler)
                {
                    //////////////////////////////////////////////////
                    dispatch_async(dispatch_get_main_queue(), ^{
                        completeHandler(NO);
                    });
                }
                break;
            }
            default:
            {
                if(completeHandler)
                {
                    //////////////////////////////////////////////////
                    dispatch_async(dispatch_get_main_queue(), ^{
                        completeHandler(YES);
                    });
                }
                break;
            }
        }
    });


}

@end
