//
//  NSTimer+Additions.m
//  Pods
//
//  Created by Eddie Hu on 2017/4/10.
//
//

#import "NSTimer+Additions.h"

@implementation NSTimer (Additions)


//================================================================================
//
//================================================================================
+ (void)pp_invokeBlock:(NSTimer *)timer
{
    void (^block)(NSTimer *) = timer.userInfo;
    
    if (block)
    {
        block(timer);
    }
}


//================================================================================
//
//================================================================================
+ (NSTimer *)pp_scheduledTimerWithTimeInterval:(NSTimeInterval)interval repeats:(BOOL)repeats block:(void (^)(NSTimer *timer))block
{
    id classObject = [NSTimer class];
    
    if([classObject respondsToSelector:@selector(scheduledTimerWithTimeInterval:repeats:block:)] == YES)
    {
        return [NSTimer scheduledTimerWithTimeInterval:interval repeats:repeats block:block];
    }
    else
    {
        NSTimer *timer = [self scheduledTimerWithTimeInterval:interval
                                                       target:self
                                                     selector:@selector(pp_invokeBlock:)
                                                     userInfo:[[block copy] autorelease]
                                                      repeats:repeats];
        return timer;
    }
}



@end
