//
//  NSThread+Additions.m
//  
//
//  Created by Mike on 13/4/29.
//  
//

#import "NSThread+Additions.h"

@implementation NSThread (Additions)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Methods

//================================================================================
//
//================================================================================
- (BOOL)checkCancel
{
	[NSThread sleepForTimeInterval:0.01];
	
	return [self isCancelled];
}

//================================================================================
//
//================================================================================
- (void)terminate
{
	if([self isFinished]==NO)
	{
		[self cancel];
        
		[NSThread sleepForTimeInterval:0.01];
	}
}


//================================================================================
//
//================================================================================
+ (void)waitWithTimeInterval:(NSTimeInterval)timeInterval
{
    if([NSThread isMainThread] == YES)
    {
        @autoreleasepool
        {
            [[NSRunLoop currentRunLoop] runUntilDate:[NSDate dateWithTimeIntervalSinceNow:timeInterval]];
        }
    }
    else
    {
        [NSThread sleepForTimeInterval:timeInterval];
    }
}

@end
