//
//  NSOperation+Additions.m
//

#import "NSOperation+Additions.h"
#import <objc/runtime.h>

static void *InternalCancel = &InternalCancel;

@implementation NSOperation (Additions)

//================================================================================
//
//================================================================================
- (void)setInternalCancel:(BOOL)internalCancel
{
    objc_setAssociatedObject(self, InternalCancel, @(internalCancel), OBJC_ASSOCIATION_RETAIN_NONATOMIC);
}


//================================================================================
//
//================================================================================
- (BOOL)internalCancel
{
    NSNumber *number = objc_getAssociatedObject(self, InternalCancel);
    return [number boolValue];
}

@end
