//
//  NSObject+Wait.m
//  
//
//  Created by Mike.Shih on 13/10/7.
//  Copyright (c) 2013年 Mike.Shih. All rights reserved.
//

#import "NSObject+Wait.h"

@implementation NSObject (Wait)

//================================================================================
//
//================================================================================
- (void)waitBlock:(BOOL (^)(id object))block
{
    __block id blockSelf = self;
    
    while(block(blockSelf)==NO)
    {
        NSDate *stopDate = [[NSDate alloc] initWithTimeIntervalSinceNow:0.001];
        if(stopDate!=nil)
        {
            [[NSRunLoop currentRunLoop] runUntilDate:stopDate];
            
            [stopDate release];
        }
    }
}

//================================================================================
//
//================================================================================
- (void)waitBlockOnMainThread:(BOOL (^)(id object))block
{
    if([NSThread currentThread]!=[NSThread mainThread])
    {
        [self performSelectorOnMainThread:@selector(waitBlock:)
                               withObject:block
                            waitUntilDone:YES];
    }
    else
    {
        [self waitBlock:block];
    }
}

@end
