//
//  NSDate+TimeSection.h
//  Pods
//
//  Created by sanhue on 2016/12/6.
//
//

#import <Foundation/Foundation.h>

@interface NSDate (TimeSection)

/**
 * 使用日期產生sectionTitle，相當於call |sectionTitleWithDateSeparator:|, dateSeparator==nil
 * 詳細說明請看 |sectionTitleWithDateSeparator:|
 *
 * @return sectionTitle
 */
- (NSString *)sectionTitle;

/**
 * 使用日期產生sectionTitle
 * 規則:
 * 1。與今天同一週的，一天一個title
 * 2。與今天同一個月，但不同週的，為本月
 * 3。與今天不同月份的，以月為單位，一個月一個title
 * @param dateSeparator 指定日期分隔符號，nil表示使用預設@"."
 * @return sectionTitle
 */
- (NSString *)sectionTitleWithDateSeparator:(NSString *)dateSeparator;

@end
