//
//  NSDate+Format.m
//  
//
//  Created by Mike on 13/4/25.
//  
//

#import "NSDate+Format.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

NSString *NSDateFormat_Year     = @"yyyy";
NSString *NSDateFormat_Month    = @"yyyy/MM";
NSString *NSDateFormat_Day      = @"yyyy/MM/dd";
NSString *NSDateFormat_Hour     = @"yyyy/MM/dd HH";
NSString *NSDateFormat_Minute	= @"yyyy/MM/dd HH:mm";
NSString *NSDateFormat_Second   = @"yyyy/MM/dd HH:mm:ss";
NSString *NSDateFormat_MonthAndDay = @"MM/dd";

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation NSDate (Format)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Methods

//================================================================================
//
//================================================================================
- (NSString *)stringWithFormat:(NSString *)format
{
	return [self stringWithFormat:format timeZone:[NSTimeZone localTimeZone]];
}

//================================================================================
//
//================================================================================
- (NSString *)stringWithFormat:(NSString *)format timeZone:(NSTimeZone *)timeZone
{
    return [self stringWithFormat:format timeZone:timeZone locale:[NSLocale localeWithLocaleIdentifier:@"en-US"]];
}


//==============================================================================
//
//==============================================================================
- (NSString *)stringWithFormat:(NSString *)format timeZone:(NSTimeZone *)timeZone locale:(NSLocale *)locale
{
    NSString *string = nil;
    
    do
    {
        if(format==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
        if(dateFormatter!=nil)
        {
            [dateFormatter setDateFormat:format];
            [dateFormatter setTimeZone:timeZone];
            
            dateFormatter.locale = locale;
            
            string = [dateFormatter stringFromDate:self];
            
            [dateFormatter release];
        }
        
    }while(0);
    
    return string;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Methods

//================================================================================
//
//================================================================================
+ (NSDate *)dateFromString:(NSString *)string format:(NSString *)format
{
	return [NSDate dateFromString:string format:format timeZone:[NSTimeZone localTimeZone]];
}

//================================================================================
//
//================================================================================
+ (NSDate *)dateFromString:(NSString *)string format:(NSString *)format timeZone:(NSTimeZone *)timeZone
{
    NSDate *date = nil;
    
    do
    {
        if(string==nil || format==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
        if(dateFormatter!=nil)
        {
            [dateFormatter setDateFormat:format];
            [dateFormatter setTimeZone:timeZone];
            
            // NSLocale 強制英文方式顯示日期，又 HH 是24小時制, (所以不會出現"午前,後")
            dateFormatter.locale = [NSLocale localeWithLocaleIdentifier:@"en-US"];
            
            date = [dateFormatter dateFromString:string];
            
            [dateFormatter release];
        }
        
    }while(0);
    
	return date;
}

@end
