package com.penpower.signature.sample;

import android.app.AlertDialog;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.Toast;

import androidx.appcompat.app.AppCompatActivity;

import com.penpower.signature.Define;
import com.penpower.signature.sdk.PenDeviceInfo;
import com.penpower.signature.veikk.sdk.TabletView;

import java.io.File;
import java.util.Date;

public class MainActivity extends AppCompatActivity {
    private int mImageFormat = Define.IMAGE_FORMAT_PNG;

    private TabletView.EventListener mEventListener = new TabletView.EventListener() {
        @Override
        public void onButtonEvent(int aButtonEvent) {
            if (aButtonEvent == Define.BUTTON_OK) {
                Toast.makeText(MainActivity.this, "BUTTON_OK", Toast.LENGTH_SHORT).show();

                TabletView sdkCanvasView = findViewById(R.id.sdk_canvas_view);
                if (sdkCanvasView != null) {
                    String obbPath = getObbDir().getPath()+File.separator;
                    File dir = new File(obbPath);
                    if (dir != null && dir.exists() == false) {
                        dir.mkdirs();
                    }

                    String fileName = obbPath+"penpower_signature_" + new Date().getTime();
                    switch(mImageFormat) {
                        case Define.IMAGE_FORMAT_JPEG:
                            sdkCanvasView.saveImage(mImageFormat, fileName+".jpg");
                            break;
                        case Define.IMAGE_FORMAT_PNG:
                            sdkCanvasView.saveImage(mImageFormat, fileName+".png");
                            break;
                        case Define.IMAGE_FORMAT_BITMAP:
                            sdkCanvasView.saveImage(mImageFormat, fileName+".bmp");
                            break;
                    }
                    sdkCanvasView.doStrokeClear();
                }
            } else if (aButtonEvent == Define.BUTTON_CANCEL) {
                Toast.makeText(MainActivity.this, "BUTTON_CANCEL", Toast.LENGTH_SHORT).show();

                TabletView sdkCanvasView = findViewById(R.id.sdk_canvas_view);
                if (sdkCanvasView != null) {
                    sdkCanvasView.doStrokeClear();
                }
            }
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        setContentView(R.layout.activity_main);

        TabletView sdkCanvasView = findViewById(R.id.sdk_canvas_view);
        if (sdkCanvasView != null) {
            String obbPath = getObbDir().getPath()+File.separator;
            sdkCanvasView.setFilePath(obbPath);
            sdkCanvasView.saveImageFormat(mImageFormat);
            sdkCanvasView.setStrokeWidth(Define.STROKE_PEN_WIDTH_LEVEL_3);
            sdkCanvasView.setOnEventListener(mEventListener);
            sdkCanvasView.setVisibility(View.VISIBLE);
        }

        Button connectButton = findViewById(R.id.btn_open_device);
        if (connectButton != null) {
            connectButton.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    TabletView sdkCanvasView = findViewById(R.id.sdk_canvas_view);
                    if (sdkCanvasView != null) {
                        if (sdkCanvasView.checkPermission() == true) {
                            boolean isConnect = sdkCanvasView.connect(Define.E640);
                            if (isConnect == false) {
                                Toast.makeText(MainActivity.this, "device not connected!", Toast.LENGTH_SHORT).show();
                            } else {
                                Toast.makeText(MainActivity.this, "device connect success!", Toast.LENGTH_SHORT).show();
                            }
                        } else {
                            Toast.makeText(MainActivity.this, "please grant permission!", Toast.LENGTH_SHORT).show();
                        }
                    }
                }
            });
        }

        Button closeButton = findViewById(R.id.btn_close_device);
        if (closeButton != null) {
            closeButton.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    TabletView sdkCanvasView = findViewById(R.id.sdk_canvas_view);
                    if (sdkCanvasView != null) {
                        sdkCanvasView.disconnect();
                    }
                }
            });
        }

        Button infoButton = findViewById(R.id.btn_device_info);
        if (infoButton != null) {
            infoButton.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    TabletView sdkCanvasView = findViewById(R.id.sdk_canvas_view);
                    if (sdkCanvasView != null) {
                        PenDeviceInfo obj = sdkCanvasView.queryDeviceInfo();
                        if (obj != null) {
                            String msg = "pen-ID:" + obj.mPenID + ",pad-ID:" + obj.mPadID + ",pad-Model:" + obj.mPadType;
                            Toast.makeText(MainActivity.this, msg, Toast.LENGTH_SHORT).show();
                        } else {
                            Toast.makeText(MainActivity.this, "device not connected!", Toast.LENGTH_SHORT).show();
                        }
                    }
                }
            });
        }

        Button penColorButton = findViewById(R.id.btn_pen_color);
        if (penColorButton != null) {
            penColorButton.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    String[] data = {"Block", "Red", "Blue", "Green", "White"};
                    ArrayAdapter adapter = new ArrayAdapter<String>(MainActivity.this, android.R.layout.simple_list_item_1, data);

                    AlertDialog.Builder builder = new AlertDialog.Builder(MainActivity.this);
                    builder.setAdapter(adapter, new DialogInterface.OnClickListener() {
                        @Override
                        public void onClick(DialogInterface dialog, int which) {
                            TabletView sdkCanvasView = findViewById(R.id.sdk_canvas_view);
                            if (sdkCanvasView != null) {
                                switch(which) {
                                    case 0:
                                        sdkCanvasView.setStrokeColor(0xFF000000);
                                        sdkCanvasView.setBackgroundColor(0xFFFFFFFF);
                                        break;
                                    case 1:
                                        sdkCanvasView.setStrokeColor(0xFFFF0000);
                                        sdkCanvasView.setBackgroundColor(0xFFFFFFFF);
                                        break;
                                    case 2:
                                        sdkCanvasView.setStrokeColor(0xFF0000FF);
                                        sdkCanvasView.setBackgroundColor(0xFFFFFFFF);
                                        break;
                                    case 3:
                                        sdkCanvasView.setStrokeColor(0xFF00FF00);
                                        sdkCanvasView.setBackgroundColor(0xFFFFFFFF);
                                        break;
                                    case 4:
                                        sdkCanvasView.setStrokeColor(0xFFFFFFFF);
                                        sdkCanvasView.setBackgroundColor(0xFF000000);
                                        break;
                                }
                            }
                        }
                    });
                    builder.show();
                }
            });
        }

        Button penWidthButton = findViewById(R.id.btn_pen_width);
        if (penWidthButton != null) {
            penWidthButton.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    String[] data = {"1","2","3","4","5"};
                    ArrayAdapter adapter = new ArrayAdapter<String>(MainActivity.this, android.R.layout.simple_list_item_1, data);

                    AlertDialog.Builder builder = new AlertDialog.Builder(MainActivity.this);
                    builder.setAdapter(adapter, new DialogInterface.OnClickListener() {
                        @Override
                        public void onClick(DialogInterface dialog, int which) {
                            TabletView sdkCanvasView = findViewById(R.id.sdk_canvas_view);
                            if (sdkCanvasView != null) {
                                switch(which) {
                                    case 0:
                                        sdkCanvasView.setStrokeWidth(Define.STROKE_PEN_WIDTH_LEVEL_1);
                                        break;
                                    case 1:
                                        sdkCanvasView.setStrokeWidth(Define.STROKE_PEN_WIDTH_LEVEL_2);
                                        break;
                                    case 2:
                                        sdkCanvasView.setStrokeWidth(Define.STROKE_PEN_WIDTH_LEVEL_3);
                                        break;
                                    case 3:
                                        sdkCanvasView.setStrokeWidth(Define.STROKE_PEN_WIDTH_LEVEL_4);
                                        break;
                                    case 4:
                                        sdkCanvasView.setStrokeWidth(Define.STROKE_PEN_WIDTH_LEVEL_5);
                                        break;
                                }
                            }
                        }
                    });
                    builder.show();
                }
            });
        }

        Button imageFormatButton = findViewById(R.id.btn_image_format);
        if (imageFormatButton != null) {
            imageFormatButton.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    String[] data = {"JPG","PNG","BMP"};
                    ArrayAdapter adapter = new ArrayAdapter<String>(MainActivity.this, android.R.layout.simple_list_item_1, data);

                    AlertDialog.Builder builder = new AlertDialog.Builder(MainActivity.this);
                    builder.setAdapter(adapter, new DialogInterface.OnClickListener() {
                        @Override
                        public void onClick(DialogInterface dialog, int which) {
                            TabletView sdkCanvasView = findViewById(R.id.sdk_canvas_view);
                            if (sdkCanvasView != null) {
                                switch(which) {
                                    case 0:
                                        mImageFormat = Define.IMAGE_FORMAT_JPEG;
                                        sdkCanvasView.saveImageFormat(Define.IMAGE_FORMAT_JPEG);
                                        break;
                                    case 1:
                                        mImageFormat = Define.IMAGE_FORMAT_PNG;
                                        sdkCanvasView.saveImageFormat(Define.IMAGE_FORMAT_PNG);
                                        break;
                                    case 2:
                                        mImageFormat = Define.IMAGE_FORMAT_BITMAP;
                                        sdkCanvasView.saveImageFormat(Define.IMAGE_FORMAT_BITMAP);
                                        break;
                                }
                                sdkCanvasView.doStrokeClear();
                            }
                        }
                    });
                    builder.show();
                }
            });
        }

        Button clearButton = findViewById(R.id.btn_clear);
        if (clearButton != null) {
            clearButton.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    TabletView sdkCanvasView = findViewById(R.id.sdk_canvas_view);
                    if (sdkCanvasView != null) {
                        sdkCanvasView.doStrokeClear();
                    }
                }
            });
        }

        Button saveButton = findViewById(R.id.btn_save);
        if (saveButton != null) {
            saveButton.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    TabletView sdkCanvasView = findViewById(R.id.sdk_canvas_view);
                    if (sdkCanvasView != null) {
                        String obbPath = getObbDir().getPath()+File.separator;
                        File dir = new File(obbPath);
                        if (dir != null && dir.exists() == false) {
                            dir.mkdirs();
                        }

                        String fileName = obbPath+"penpower_signature_" + new Date().getTime();
                        switch(mImageFormat) {
                            case Define.IMAGE_FORMAT_JPEG:
                                sdkCanvasView.saveImage(mImageFormat, fileName+".jpg");
                                break;
                            case Define.IMAGE_FORMAT_PNG:
                                sdkCanvasView.saveImage(mImageFormat, fileName+".png");
                                break;
                            case Define.IMAGE_FORMAT_BITMAP:
                                sdkCanvasView.saveImage(mImageFormat, fileName+".bmp");
                                break;
                        }
                        sdkCanvasView.doStrokeClear();
                    }
                }
            });
        }

        CheckBox pressureCheckBox = findViewById(R.id.cb_pen_pressure);
        if (pressureCheckBox != null) {
            pressureCheckBox.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    CheckBox pressureCheckBox = findViewById(R.id.cb_pen_pressure);
                    if (pressureCheckBox != null) {
                        TabletView sdkCanvasView = findViewById(R.id.sdk_canvas_view);
                        if (sdkCanvasView != null) {
                            if (pressureCheckBox.isChecked() == true) {
                                sdkCanvasView.setStrokeStyle(Define.STROKE_STYLE_PRESSURE);
                            } else {
                                sdkCanvasView.setStrokeStyle(Define.STROKE_STYLE_FIXED);
                            }
                        }
                    }
                }
            });
        }

        CheckBox clipCheckBox = findViewById(R.id.cb_stroke_clip);
        if (clipCheckBox != null) {
            clipCheckBox.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    CheckBox clipCheckBox = findViewById(R.id.cb_stroke_clip);
                    if (clipCheckBox != null) {
                        TabletView sdkCanvasView = findViewById(R.id.sdk_canvas_view);
                        if (sdkCanvasView != null) {
                            if (clipCheckBox.isChecked() == true) {
                                sdkCanvasView.setClipStroke(true);
                            } else {
                                sdkCanvasView.setClipStroke(false);
                            }
                        }
                    }
                }
            });
        }
    }

    @Override
    protected void onDestroy() {
        TabletView sdkCanvasView = findViewById(R.id.sdk_canvas_view);
        if (sdkCanvasView != null) {
            sdkCanvasView.disconnect();
        }
        super.onDestroy();
    }
}
