/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.signature.sdk;

import android.graphics.Bitmap;
import android.graphics.Color;

public class BitmapConverter {
    private byte[] Color_palette = new byte[1024];
    private byte[] BMP_File_Header = new byte[14];
    private byte[] DIB_header = new byte[40];
    private byte[] Bitmap_Data = null;

    public byte[] CreateGrayBitmapArray(Bitmap Image) {
        try {
            this.create_parts(Image);
            byte[] bitmap_array = new byte[this.BMP_File_Header.length + this.DIB_header.length + this.Color_palette.length + this.Bitmap_Data.length];
            this.Copy_to_Index(bitmap_array, this.BMP_File_Header, 0);
            this.Copy_to_Index(bitmap_array, this.DIB_header, this.BMP_File_Header.length);
            this.Copy_to_Index(bitmap_array, this.Color_palette, this.BMP_File_Header.length + this.DIB_header.length);
            this.Copy_to_Index(bitmap_array, this.Bitmap_Data, this.BMP_File_Header.length + this.DIB_header.length + this.Color_palette.length);
            return bitmap_array;
        }
        catch (Exception e) {
            return null;
        }
    }

    private byte[] create_palette() {
        byte[] color_palette = new byte[1024];
        for (int i = 0; i < 256; ++i) {
            color_palette[i * 4 + 0] = (byte)i;
            color_palette[i * 4 + 1] = (byte)i;
            color_palette[i * 4 + 2] = (byte)i;
            color_palette[i * 4 + 3] = 0;
        }
        return color_palette;
    }

    private boolean Copy_to_Index(byte[] destination, byte[] source, int index) {
        try {
            for (int i = 0; i < source.length; ++i) {
                destination[i + index] = source[i];
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void create_parts(Bitmap img) {
        this.Bitmap_Data = this.ConvertToGrayscale(img);
        this.Copy_to_Index(this.BMP_File_Header, new byte[]{66, 77}, 0);
        this.Copy_to_Index(this.BMP_File_Header, this.writeInt(this.BMP_File_Header.length + this.DIB_header.length + this.Color_palette.length + this.Bitmap_Data.length), 2);
        this.Copy_to_Index(this.BMP_File_Header, new byte[]{77, 67, 65, 84}, 6);
        this.Copy_to_Index(this.BMP_File_Header, this.writeInt(this.BMP_File_Header.length + this.DIB_header.length + this.Color_palette.length), 10);
        this.Copy_to_Index(this.DIB_header, this.writeInt(this.DIB_header.length), 0);
        this.Copy_to_Index(this.DIB_header, this.writeInt(img.getWidth()), 4);
        this.Copy_to_Index(this.DIB_header, this.writeInt(img.getHeight()), 8);
        this.Copy_to_Index(this.DIB_header, new byte[]{1, 0}, 12);
        this.Copy_to_Index(this.DIB_header, new byte[]{8, 0}, 14);
        this.Copy_to_Index(this.DIB_header, this.writeInt(0), 16);
        this.Copy_to_Index(this.DIB_header, this.writeInt(this.Bitmap_Data.length), 20);
        this.Copy_to_Index(this.DIB_header, this.writeInt(1000), 24);
        this.Copy_to_Index(this.DIB_header, this.writeInt(1000), 28);
        this.Copy_to_Index(this.DIB_header, this.writeInt(256), 32);
        this.Copy_to_Index(this.DIB_header, this.writeInt(0), 36);
        this.Color_palette = this.create_palette();
    }

    private byte[] ConvertToGrayscale(Bitmap Source) {
        Bitmap source = Source;
        int padding = source.getWidth() % 4 != 0 ? 4 - source.getWidth() % 4 : 0;
        byte[] bytes = new byte[source.getWidth() * source.getHeight() + padding * source.getHeight()];
        for (int y = 0; y < source.getHeight(); ++y) {
            for (int x = 0; x < source.getWidth(); ++x) {
                int pixel = source.getPixel(x, y);
                int g = (int)(0.3 * (double)Color.red((int)pixel) + 0.59 * (double)Color.green((int)pixel) + 0.11 * (double)Color.blue((int)pixel));
                bytes[(source.getHeight() - 1 - y) * source.getWidth() + (source.getHeight() - 1 - y) * padding + x] = (byte)g;
            }
            for (int i = 0; i < padding; ++i) {
                bytes[(source.getHeight() - y) * source.getWidth() + (source.getHeight() - 1 - y) * padding + i] = 0;
            }
        }
        return bytes;
    }

    private byte[] writeInt(int value) {
        byte[] b = new byte[]{(byte)(value & 0xFF), (byte)((value & 0xFF00) >> 8), (byte)((value & 0xFF0000) >> 16), (byte)((value & 0xFF000000) >> 24)};
        return b;
    }
}

