#=====================================================
# -*- coding: utf-8 -*-
# author : Julio - PenPower Digital Development Dept.
# Creation : 2024.09.16.
# Target Platform : Python v2.x Runtime Environment
#=====================================================

from ctypes import *
# import ctypes.wintypes
from enum import Enum

#-------------------------------------------------------
# Structure Definitions
class DEVICE_TYPE_ID(Enum):
	NONE_DEVICE         = 0
	PPL398_DEVICE       = 2
	PPLC700_DEVICE      = 3
	PPE640_DEVICE       = 4
	PPL500_DEVICE       = 5
	PPL501F_DEVICE      = 7


class ERROR_ID(Enum):
    RET_PST_SUCCESS                     = 0
    RET_PST_FAIL                        = -1
    RET_PST_MAINWINNOEXIST              = -2
    RET_PST_SIGNWINNOEXIST              = -3
    RET_PST_SIGN_OUTOFMEMORY            = -4
    RET_PST_SIGN_GDIAPIERROR            = -5
    RET_PST_SAVEFAIL                    = -6
    RET_PST_PARAM                       = -7
    RET_PST_INKEMPTY                    = -8
    RET_PST_BmpFileGet                  = -9
    RET_PST_DIBConv                     = -10
    RET_PST_DECODECTRLERROR             = -11
    RET_PST_CALLBACKNULL                = -12
    RET_PST_DEVICEERROR                 = -13
    RET_PST_DEVICENOREADY               = -14
    RET_PST_DEVICEISWORKING             = -15
    RET_PST_APINOTSUPPORT_IN_THIS_OS    = -16
    RET_PST_LOAD_PPAVMODDLL_FAIL        = -17
    RET_PST_NOT_ENABLE_SAVE_VIDEO_DATA  = -18

class INKPOINTDATA(Structure):
    _fields_ = [
        ("btn",         c_int32),
        ("X",           c_short),
        ("Y",           c_short),
        ("Press",       c_short),
        ("bStrokeEnd",  c_bool)
    ]

class PPAXIS(Structure):
    _fields_ = [
        ("axMin",   c_int32),
        ("axMax",   c_int32)
    ]

class PPSDKVERSION(Structure):
    _fields_ = [
        ("sdkVerMajor",   c_int32),
        ("sdkVerMinor",   c_int32)
    ]

SIGNPAD_EVENT_CALLBACK = CFUNCTYPE(None, c_int32)

CSIDL_PERSONAL = 5       # My Documents
SHGFP_TYPE_CURRENT = 0   # Get current, not default value
SIGNPAD_CONFIRM_BUTTON  = 1
SIGNPAD_CANCEL_BUTTON  	= 0
RX_DEVICE_DATA_MAX_SIZE = 32
MAX_PATH = 256
#-------------------------------------------------------
