#=====================================================
# -*- coding: utf-8 -*-
# author : Julio - PenPower Digital Development Dept.
# Creation : 2024.09.16.
# Target Platform : Python v2.x Runtime Environment
#=====================================================

from enum import Enum
from ctypes import *
from structdefs import *

#--------------------------------------------------------------------------
# PPE640 APIs Definitions
#--------------------------------------------------------------------------
#
#==========================================================================
# PPE640_InitialDevice(deviceID, widgetPtr, x, y, nWidth, nHeight)
#==========================================================================
def API_PPE640_InitialDevice():
    dll = CDLL('./libppcpsignpadsdk.so')
    func = dll.PPE640_InitialDevice
    func.argtypes = [c_int32, c_void_p, c_int32, c_int32, c_int32, c_int32]
    func.restype = c_bool
    return func

__PPE640_InitialDevice = API_PPE640_InitialDevice()

def PPE640_InitialDevice(deviceID, widgetPtr, x, y, nWidth, nHeight):
    m_deviceID = c_int32(deviceID)
    m_pWidget = cast(widgetPtr, c_void_p)
    m_x = c_int32(x)
    m_y = c_int32(y)
    m_Width = c_int32(nWidth)
    m_Height = c_int32(nHeight)
    m_bResult = c_bool()
    m_bResult = __PPE640_InitialDevice(m_deviceID, m_pWidget, m_x, m_y, m_Width, m_Height)
    return m_bResult
#==========================================================================
#
#==========================================================================
# PPE640_UnInitialDevice(deviceID)
#==========================================================================
def API_PPE640_UnInitialDevice():
    dll = CDLL('./libppcpsignpadsdk.so')
    func = dll.PPE640_UnInitialDevice
    func.argtypes = [c_int32]
    func.restype = c_int32
    return func

__PPE640_UnInitialDevice = API_PPE640_UnInitialDevice()

def PPE640_UnInitialDevice(deviceID):
    m_deviceID = c_int32(deviceID)
    m_nResult = c_int32()
    m_nResult = __PPE640_UnInitialDevice(m_deviceID)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPE640_AboutBox(widgetPtr)
#==========================================================================
def API_PPE640_AboutBox():
    dll = CDLL('./libppcpsignpadsdk.so')
    func = dll.PPE640_AboutBox
    func.argtypes = [c_void_p]
    return func

__PPE640_AboutBox = API_PPE640_AboutBox()

def PPE640_AboutBox(widgetPtr):
    m_pWidget = cast(widgetPtr, c_void_p)
    __PPE640_AboutBox(m_pWidget)
#==========================================================================
#
#==========================================================================
# PPE640_SetPenColor(deviceID, nR, nG, nB)
#==========================================================================
def API_PPE640_SetPenColor():
    dll = CDLL('./libppcpsignpadsdk.so')
    func = dll.PPE640_SetPenColor
    func.argtypes = [c_int32, c_int32, c_int32, c_int32]
    func.restype = c_int32
    return func

__PPE640_SetPenColor = API_PPE640_SetPenColor()

def PPE640_SetPenColor(deviceID, nR, nG, nB):
    m_deviceID = c_int32(deviceID)
    m_nR = c_int32(nR)
    m_nG = c_int32(nG)
    m_nB = c_int32(nB)
    m_nResult = c_int32()
    m_nResult = __PPE640_SetPenColor(m_deviceID, m_nR, m_nG, m_nB)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPE640_SetPenWidth(deviceID, nWidth)
#==========================================================================
def API_PPE640_SetPenWidth():
    dll = CDLL('./libppcpsignpadsdk.so')
    func = dll.PPE640_SetPenWidth
    func.argtypes = [c_int32, c_int32]
    func.restype = c_int32
    return func

__PPE640_SetPenWidth = API_PPE640_SetPenWidth()

def PPE640_SetPenWidth(deviceID, nWidth):
    m_deviceID = c_int32(deviceID)
    m_nWidth = c_int32(nWidth)
    m_nResult = c_int32()
    m_nResult = __PPE640_SetPenWidth(m_deviceID, m_nWidth)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPE640_SetPenStyle(deviceID, bPressureOn)
#==========================================================================
def API_PPE640_SetPenStyle():
    dll = CDLL('./libppcpsignpadsdk.so')
    func = dll.PPE640_SetPenStyle
    func.argtypes = [c_int32, c_bool]
    func.restype = c_int32
    return func

__PPE640_SetPenStyle = API_PPE640_SetPenStyle()

def PPE640_SetPenStyle(deviceID, bPressureOn):
    m_deviceID = c_int32(deviceID)
    m_bPressureOn = c_bool(bPressureOn)
    m_nResult = c_int32()
    m_nResult = __PPE640_SetPenStyle(m_deviceID, m_bPressureOn)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPE640_Clear(deviceID)
#==========================================================================
def API_PPE640_Clear():
    dll = CDLL('./libppcpsignpadsdk.so')
    func = dll.PPE640_Clear
    func.argtypes = [c_int32]
    func.restype = c_int32
    return func

__PPE640_Clear = API_PPE640_Clear()

def PPE640_Clear(deviceID):
    m_deviceID = c_int32(deviceID)
    m_nResult = c_int32()
    m_nResult = __PPE640_Clear(m_deviceID)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPE640_PacketsBase64Encode(deviceID, nImageTypeID)
#==========================================================================
def API_PPE640_PacketsBase64Encode():
    dll = CDLL('./libppcpsignpadsdk.so')
    func = dll.PPE640_PacketsBase64Encode
    func.argtypes = [c_int32, c_int32]
    func.restype = POINTER(c_char)
    return func

__PPE640_PacketsBase64Encode = API_PPE640_PacketsBase64Encode()

def PPE640_PacketsBase64Encode(deviceID, nImageTypeID):
    m_deviceID = c_int32(deviceID)
    m_nImageTypeID = c_int32(nImageTypeID)
    m_pChar = POINTER(c_char)
    m_pChar = __PPE640_PacketsBase64Encode(m_deviceID, m_nImageTypeID)
    return m_pChar
#==========================================================================
#
#==========================================================================
# PPE640_PacketsBase64EncodeFree(deviceID, pData)
#==========================================================================
def API_PPE640_PacketsBase64EncodeFree():
    dll = CDLL('./libppcpsignpadsdk.so')
    func = dll.PPE640_PacketsBase64EncodeFree
    func.argtypes = [c_int32, c_char_p]
    func.restype = None
    return func

__PPE640_PacketsBase64EncodeFree = API_PPE640_PacketsBase64EncodeFree()

def PPE640_PacketsBase64EncodeFree(deviceID, pData):
    m_deviceID = c_int32(deviceID)
    m_pData = pData
    __PPE640_PacketsBase64EncodeFree(m_deviceID, m_pData)
#==========================================================================
#
#==========================================================================
# PPE640_GetTotalPacketsNumber(deviceID)
#==========================================================================
def PPE640_GetTotalPacketsNumber():
    dll = CDLL('./libppcpsignpadsdk.so')
    func = dll.PPE640_GetTotalPacketsNumber
    func.argtypes = [c_int32]
    func.restype = c_int32
    return func

__PPE640_GetTotalPacketsNumber = PPE640_GetTotalPacketsNumber()

def PPE640_GetTotalPacketsNumber(deviceID):
    m_deviceID = c_int32(deviceID)
    m_nResult = c_int32()
    m_nResult = __PPE640_GetTotalPacketsNumber(m_deviceID)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPE640_Base64Decode(deviceID, nImageTypeID, encodeString, wDecodeFilePath)
#==========================================================================
def API_PPE640_Base64Decode():
    dll = CDLL('./libppcpsignpadsdk.so')
    func = dll.PPE640_Base64Decode
    func.argtypes = [c_int32, c_int32, c_char_p, c_wchar_p]
    func.restype = c_int32
    return func

__PPE640_Base64Decode = API_PPE640_Base64Decode()

def PPE640_Base64Decode(deviceID, nImageTypeID, encodeString, wDecodeFilePath):
    m_deviceID = c_int32(deviceID)
    m_nImageTypeID = c_int32(nImageTypeID)
    m_pEncodeString = c_char_p(encodeString)
    m_pwDecodeFilePath = wDecodeFilePath
    m_nResult = c_int32()
    m_nResult = __PPE640_Base64Decode(m_deviceID, m_nImageTypeID, m_pEncodeString, m_pwDecodeFilePath)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPE640_GetDecodePacketsData(deviceID, nIndex, nTypeID)
#==========================================================================
def API_PPE640_GetDecodePacketsData():
    dll = CDLL('./libppcpsignpadsdk.so')
    func = dll.PPE640_GetDecodePacketsData
    func.argtypes = [c_int32, c_int32, c_int32]
    func.restype = c_int32
    return func

__PPE640_GetDecodePacketsData = API_PPE640_GetDecodePacketsData()

def PPE640_GetDecodePacketsData(deviceID, nIndex, nTypeID):
    m_deviceID = c_int32(deviceID)
    m_nIndex = c_int32(nIndex)
    m_nTypeID = c_int32(nTypeID)
    m_nResult = c_int32()
    m_nResult = __PPE640_GetDecodePacketsData(m_deviceID, m_nIndex, m_nTypeID)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPE640_GetTotalDecodePacketsNumber(deviceID)
#==========================================================================
def API_PPE640_GetTotalDecodePacketsNumber():
    dll = CDLL('./libppcpsignpadsdk.so')
    func = dll.PPE640_GetTotalDecodePacketsNumber
    func.argtypes = [c_int32]
    func.restype = c_int32
    return func

__PPE640_GetTotalDecodePacketsNumber = API_PPE640_GetTotalDecodePacketsNumber()

def PPE640_GetTotalDecodePacketsNumber(deviceID):
    m_deviceID = c_int32(deviceID)
    m_nResult = c_int32()
    m_nResult = __PPE640_GetTotalDecodePacketsNumber(m_deviceID)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPE640_SetSaveCenterImageClip(deviceID, bClipImage, nClipMarginX, nClipMarginY)
#==========================================================================
def API_PPE640_SetSaveCenterImageClip():
    dll = CDLL('./libppcpsignpadsdk.so')
    func = dll.PPE640_SetSaveCenterImageClip
    func.argtypes = [c_int32, c_bool, c_int32, c_int32]
    func.restype = c_int32
    return func

__PPE640_SetSaveCenterImageClip = API_PPE640_SetSaveCenterImageClip()

def PPE640_SetSaveCenterImageClip(deviceID, bClipImage, nClipMarginX, nClipMarginY):
    m_deviceID = c_int32(deviceID)
    m_bClipImage = c_bool(bClipImage)
    m_nClipMarginX = c_int32(nClipMarginX)
    m_nClipMarginY = c_int32(nClipMarginY)
    m_bResult = c_int32()
    m_bResult = __PPE640_SetSaveCenterImageClip(m_deviceID, m_bClipImage, m_nClipMarginX, m_nClipMarginY)
    return m_bResult
#==========================================================================
#
#==========================================================================
# PPE640_SaveDrawingImage(deviceID, nImageTypeID, pwImageFilePath, nDPILevel)
#==========================================================================
def API_PPE640_SaveDrawingImage():
    dll = CDLL('./libppcpsignpadsdk.so')
    func = dll.PPE640_SaveDrawingImage
    func.argtypes = [c_int32, c_int32, c_wchar_p, c_int32]
    func.restype = c_int32
    return func

__PPE640_SaveDrawingImage = API_PPE640_SaveDrawingImage()

def PPE640_SaveDrawingImage(deviceID, nImageTypeID, pwImageFilePath, nDPILevel):
    m_deviceID = c_int32(deviceID)
    m_nImageTypeID = c_int32(nImageTypeID)
    m_pwImageFilePath = pwImageFilePath
    m_nDPILevel = c_int32(nDPILevel)
    m_nResult = c_int32()
    m_nResult = __PPE640_SaveDrawingImage(m_deviceID, m_nImageTypeID, m_pwImageFilePath, m_nDPILevel)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPE640_getPackets(deviceID, currentInkPoint)
#==========================================================================
def API_PPE640_getPackets():
    dll = CDLL('./libppcpsignpadsdk.so')
    func = dll.PPE640_getPackets
    func.argtypes = [c_int32, POINTER(PACKETS)]
    func.restype = c_int32
    return func

__PPE640_getPackets = API_PPE640_getPackets()

def PPE640_getPackets(deviceID, currentInkPoint):
    m_deviceID = c_int32(deviceID)
    m_pCurrentInkPoint = byref(currentInkPoint)
    m_nResult = c_int32()
    m_nResult = __PPE640_getPackets(m_deviceID, m_pCurrentInkPoint)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPE640_GetInkPointTime(deviceID, nIndex)
#==========================================================================
def API_PPE640_GetInkPointTime():
    dll = CDLL('./libppcpsignpadsdk.so')
    func = dll.PPE640_GetInkPointTime
    func.argtypes = [c_int32, c_int32]
    func.restype = POINTER(c_char)
    return func

__PPE640_GetInkPointTime = API_PPE640_GetInkPointTime()

def PPE640_GetInkPointTime(deviceID, nIndex):
    m_deviceID = c_int32(deviceID)
    m_nIndex = c_int32(nIndex)
    m_pChar = POINTER(c_char)
    m_pChar = __PPE640_GetInkPointTime(m_deviceID, m_nIndex)
    return m_pChar
#==========================================================================
#
#==========================================================================
# PPE640_FreeInkPointTime(deviceID, pData)
#==========================================================================
def API_PPE640_FreeInkPointTime():
    dll = CDLL('./libppcpsignpadsdk.so')
    func = dll.PPE640_FreeInkPointTime
    func.argtypes = [c_int32, c_char_p]
    func.restype = None
    return func

__PPE640_FreeInkPointTime = API_PPE640_FreeInkPointTime()

def PPE640_FreeInkPointTime(deviceID, pData):
    m_deviceID = c_int32(deviceID)
    m_pData = pData
    __PPE640_FreeInkPointTime(m_deviceID, m_pData)
#==========================================================================
#
#==========================================================================
# PPE640_getDeviceInfo(deviceID, nIndex, Output)
#==========================================================================
def API_PPE640_getDeviceInfo():
    dll = CDLL('./libppcpsignpadsdk.so')
    func = dll.PPE640_getDeviceInfo
    func.argtypes = [c_int32, c_int32, c_void_p]
    func.restype = c_int32
    return func

__PPE640_getDeviceInfo = API_PPE640_getDeviceInfo()

def PPE640_getDeviceInfo(deviceID, nIndex, Output):
    m_deviceID = c_int32(deviceID)
    m_nIndex = c_int32(nIndex)
    m_pOutput = byref(Output)
    m_nResult = c_int32()
    m_nResult = __PPE640_getDeviceInfo(m_deviceID, m_nIndex, m_pOutput)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPE640_SignatureStatusCallback(deviceID, NOTIFYSIGNSTATUS pSignatureStatusCallback)
#==========================================================================
def API_PPE640_SignatureStatusCallback():
    dll = CDLL('./libppcpsignpadsdk.so')
    func = dll.PPE640_SignatureStatusCallback
    func.argtypes = [c_int32, NOTIFYSIGNSTATUS]
    func.restype = c_int32
    return func

__PPE640_SignatureStatusCallback = API_PPE640_SignatureStatusCallback()

def PPE640_SignatureStatusCallback(deviceID, pSignatureStatusCallback):
    m_deviceID = c_int32(deviceID)
    m_pSignatureStatusCallback = pSignatureStatusCallback
    m_nResult = c_int32()
    m_nResult = __PPE640_SignatureStatusCallback(m_deviceID, m_pSignatureStatusCallback)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPE640_GetHWVersionID(deviceID, pVersion, nMaxCount)
#==========================================================================
def API_PPE640_GetHWVersionID():
    dll = CDLL('./libppcpsignpadsdk.so')
    func = dll.PPE640_GetHWVersionID
    func.argtypes = [c_int32, c_void_p, c_int32]
    func.restype = c_int32
    return func

__PPE640_GetHWVersionID = API_PPE640_GetHWVersionID()

def PPE640_GetHWVersionID(deviceID, pVersion, nMaxCount):
    m_deviceID = c_int32(deviceID)
    m_pVersion = byref(pVersion)
    m_nMaxCount = c_int32(nMaxCount)    
    m_nResult = c_int32()
    m_nResult = __PPE640_GetHWVersionID(m_deviceID, m_pVersion, m_nMaxCount)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPE640_GetHWPadID(deviceID, pPadID, nMaxCount)
#==========================================================================
def API_PPE640_GetHWPadID():
    dll = CDLL('./libppcpsignpadsdk.so')
    func = dll.PPE640_GetHWPadID
    func.argtypes = [c_int32, c_void_p, c_int32]
    func.restype = c_int32
    return func

__PPE640_GetHWPadID = API_PPE640_GetHWPadID()

def PPE640_GetHWPadID(deviceID, pPadID, nMaxCount):
    m_deviceID = c_int32(deviceID)
    m_pPadID = byref(pPadID)
    m_nMaxCount = c_int32(nMaxCount)    
    m_nResult = c_int32()
    m_nResult = __PPE640_GetHWPadID(m_deviceID, m_pPadID, m_nMaxCount)
    return m_nResult
#==========================================================================
