#=====================================================
# -*- coding: utf-8 -*-
# author : Julio - PenPower Digital Development Dept.
# Creation : 2024.09.19.
# Target Platform : Python v2.x Runtime Environment
#=====================================================

from enum import Enum
from ctypes import *
from structdefs import *

#--------------------------------------------------------------------------
# PPL500 APIs Definitions
#--------------------------------------------------------------------------
#
#==========================================================================
# PPL500_InitialDevice(deviceID, widgetPtr, x, y, nWidth, nHeight)
#==========================================================================
def API_PPL500_InitialDevice():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL500_InitialDevice
    func.argtypes = [c_int32, c_void_p, c_int32, c_int32, c_int32, c_int32]
    func.restype = c_bool
    return func

__PPL500_InitialDevice = API_PPL500_InitialDevice()

def PPL500_InitialDevice(deviceID, widgetPtr, x, y, nWidth, nHeight):
    m_deviceID = c_int32(deviceID)
    m_pWidget = cast(widgetPtr, c_void_p)
    m_x = c_int32(x)
    m_y = c_int32(y)
    m_Width = c_int32(nWidth)
    m_Height = c_int32(nHeight)
    m_bResult = c_bool()
    m_bResult = __PPL500_InitialDevice(m_deviceID, m_pWidget, m_x, m_y, m_Width, m_Height)
    return m_bResult
#==========================================================================
#
#==========================================================================
# PPL500_UnInitialDevice(deviceID)
#==========================================================================
def API_PPL500_UnInitialDevice():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL500_UnInitialDevice
    func.argtypes = [c_int32]
    func.restype = c_int32
    return func

__PPL500_UnInitialDevice = API_PPL500_UnInitialDevice()

def PPL500_UnInitialDevice(deviceID):
    m_deviceID = c_int32(deviceID)
    m_nResult = c_int32()
    m_nResult = __PPL500_UnInitialDevice(m_deviceID)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL500_AboutBox(widgetPtr)
#==========================================================================
def API_PPL500_AboutBox():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL500_AboutBox
    func.argtypes = [c_void_p]
    return func

__PPL500_AboutBox = API_PPL500_AboutBox()

def PPL500_AboutBox(widgetPtr):
    m_pWidget = cast(widgetPtr, c_void_p)
    __PPL500_AboutBox(m_pWidget)
#==========================================================================
#
#==========================================================================
# PPL500_SetPenColor(deviceID, nR, nG, nB)
#==========================================================================
def API_PPL500_SetPenColor():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL500_SetPenColor
    func.argtypes = [c_int32, c_int32, c_int32, c_int32]
    func.restype = c_int32
    return func

__PPL500_SetPenColor = API_PPL500_SetPenColor()

def PPL500_SetPenColor(deviceID, nR, nG, nB):
    m_deviceID = c_int32(deviceID)
    m_nR = c_int32(nR)
    m_nG = c_int32(nG)
    m_nB = c_int32(nB)
    m_nResult = c_int32()
    m_nResult = __PPL500_SetPenColor(m_deviceID, m_nR, m_nG, m_nB)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL500_SetPenWidth(deviceID, nWidth)
#==========================================================================
def API_PPL500_SetPenWidth():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL500_SetPenWidth
    func.argtypes = [c_int32, c_int32]
    func.restype = c_int32
    return func

__PPL500_SetPenWidth = API_PPL500_SetPenWidth()

def PPL500_SetPenWidth(deviceID, nWidth):
    m_deviceID = c_int32(deviceID)
    m_nWidth = c_int32(nWidth)
    m_nResult = c_int32()
    m_nResult = __PPL500_SetPenWidth(m_deviceID, m_nWidth)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL500_SetPenStyle(deviceID, bPressureOn)
#==========================================================================
def API_PPL500_SetPenStyle():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL500_SetPenStyle
    func.argtypes = [c_int32, c_bool]
    func.restype = c_int32
    return func

__PPL500_SetPenStyle = API_PPL500_SetPenStyle()

def PPL500_SetPenStyle(deviceID, bPressureOn):
    m_deviceID = c_int32(deviceID)
    m_bPressureOn = c_bool(bPressureOn)
    m_nResult = c_int32()
    m_nResult = __PPL500_SetPenStyle(m_deviceID, m_bPressureOn)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL500_Clear(deviceID)
#==========================================================================
def API_PPL500_Clear():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL500_Clear
    func.argtypes = [c_int32]
    func.restype = c_int32
    return func

__PPL500_Clear = API_PPL500_Clear()

def PPL500_Clear(deviceID):
    m_deviceID = c_int32(deviceID)
    m_nResult = c_int32()
    m_nResult = __PPL500_Clear(m_deviceID)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL500_Base64Encode(deviceID, nImageTypeID)
#==========================================================================
def API_PPL500_Base64Encode():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL500_Base64Encode
    func.argtypes = [c_int32, c_int32]
    func.restype = POINTER(c_char)
    return func

__PPL500_Base64Encode = API_PPL500_Base64Encode()

def PPL500_Base64Encode(deviceID, nImageTypeID):
    m_deviceID = c_int32(deviceID)
    m_nImageTypeID = c_int32(nImageTypeID)
    m_pChar = POINTER(c_char)
    m_pChar = __PPL500_Base64Encode(m_deviceID, m_nImageTypeID)
    return m_pChar
#==========================================================================
#
#==========================================================================
# PPL500_Base64EncodeFree(deviceID, pData)
#==========================================================================
def API_PPL500_Base64EncodeFree():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL500_Base64EncodeFree
    func.argtypes = [c_int32, c_char_p]
    func.restype = None
    return func

__PPL500_Base64EncodeFree = API_PPL500_Base64EncodeFree()

def PPL500_Base64EncodeFree(deviceID, pData):
    m_deviceID = c_int32(deviceID)
    m_pData = pData
    __PPL500_Base64EncodeFree(m_deviceID, m_pData)
#==========================================================================
#
#==========================================================================
# PPL500_GetTotalInkPointsNumber(deviceID)
#==========================================================================
def PPL500_GetTotalInkPointsNumber():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL500_GetTotalInkPointsNumber
    func.argtypes = [c_int32]
    func.restype = c_int32
    return func

__PPL500_GetTotalInkPointsNumber = PPL500_GetTotalInkPointsNumber()

def PPL500_GetTotalInkPointsNumber(deviceID):
    m_deviceID = c_int32(deviceID)
    m_nResult = c_int32()
    m_nResult = __PPL500_GetTotalInkPointsNumber(m_deviceID)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL500_Base64Decode(deviceID, nImageTypeID, encodeString, wDecodeFilePath)
#==========================================================================
def API_PPL500_Base64Decode():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL500_Base64Decode
    func.argtypes = [c_int32, c_int32, c_char_p, c_wchar_p]
    func.restype = c_int32
    return func

__PPL500_Base64Decode = API_PPL500_Base64Decode()

def PPL500_Base64Decode(deviceID, nImageTypeID, encodeString, wDecodeFilePath):
    m_deviceID = c_int32(deviceID)
    m_nImageTypeID = c_int32(nImageTypeID)
    m_pEncodeString = c_char_p(encodeString)
    m_pwDecodeFilePath = wDecodeFilePath
    m_nResult = c_int32()
    m_nResult = __PPL500_Base64Decode(m_deviceID, m_nImageTypeID, m_pEncodeString, m_pwDecodeFilePath)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL500_GetDecodeInkPointData(deviceID, nIndex, nTypeID)
#==========================================================================
def API_PPL500_GetDecodeInkPointData():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL500_GetDecodeInkPointData
    func.argtypes = [c_int32, c_int32, c_int32]
    func.restype = c_int32
    return func

__PPL500_GetDecodeInkPointData = API_PPL500_GetDecodeInkPointData()

def PPL500_GetDecodeInkPointData(deviceID, nIndex, nTypeID):
    m_deviceID = c_int32(deviceID)
    m_nIndex = c_int32(nIndex)
    m_nTypeID = c_int32(nTypeID)
    m_nResult = c_int32()
    m_nResult = __PPL500_GetDecodeInkPointData(m_deviceID, m_nIndex, m_nTypeID)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL500_GetTotalDecodeInkPointsNumber(deviceID)
#==========================================================================
def API_PPL500_GetTotalDecodeInkPointsNumber():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL500_GetTotalDecodeInkPointsNumber
    func.argtypes = [c_int32]
    func.restype = c_int32
    return func

__PPL500_GetTotalDecodeInkPointsNumber = API_PPL500_GetTotalDecodeInkPointsNumber()

def PPL500_GetTotalDecodeInkPointsNumber(deviceID):
    m_deviceID = c_int32(deviceID)
    m_nResult = c_int32()
    m_nResult = __PPL500_GetTotalDecodeInkPointsNumber(m_deviceID)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL500_SetSaveClipImageMargin(deviceID, bClipImage, nClipMarginX, nClipMarginY)
#==========================================================================
def API_PPL500_SetSaveClipImageMargin():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL500_SetSaveClipImageMargin
    func.argtypes = [c_int32, c_bool, c_int32, c_int32]
    func.restype = c_int32
    return func

__PPL500_SetSaveClipImageMargin = API_PPL500_SetSaveClipImageMargin()

def PPL500_SetSaveClipImageMargin(deviceID, bClipImage, nClipMarginX, nClipMarginY):
    m_deviceID = c_int32(deviceID)
    m_bClipImage = c_bool(bClipImage)
    m_nClipMarginX = c_int32(nClipMarginX)
    m_nClipMarginY = c_int32(nClipMarginY)
    m_bResult = c_int32()
    m_bResult = __PPL500_SetSaveClipImageMargin(m_deviceID, m_bClipImage, m_nClipMarginX, m_nClipMarginY)
    return m_bResult
#==========================================================================
#
#==========================================================================
# PPL500_SaveDrawingImage(deviceID, nImageTypeID, pwImageFilePath, nDPILevel)
#==========================================================================
def API_PPL500_SaveDrawingImage():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL500_SaveDrawingImage
    func.argtypes = [c_int32, c_int32, c_wchar_p, c_int32]
    func.restype = c_int32
    return func

__PPL500_SaveDrawingImage = API_PPL500_SaveDrawingImage()

def PPL500_SaveDrawingImage(deviceID, nImageTypeID, pwImageFilePath, nDPILevel):
    m_deviceID = c_int32(deviceID)
    m_nImageTypeID = c_int32(nImageTypeID)
    m_pwImageFilePath = pwImageFilePath
    m_nDPILevel = c_int32(nDPILevel)
    m_nResult = c_int32()
    m_nResult = __PPL500_SaveDrawingImage(m_deviceID, m_nImageTypeID, m_pwImageFilePath, m_nDPILevel)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL500_GetInkPointData(deviceID, currentInkPoint)
#==========================================================================
def API_PPL500_GetInkPointData():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL500_GetInkPointData
    func.argtypes = [c_int32, POINTER(INKPOINTDATA)]
    func.restype = c_int32
    return func

__PPL500_GetInkPointData = API_PPL500_GetInkPointData()

def PPL500_GetInkPointData(deviceID, currentInkPoint):
    m_deviceID = c_int32(deviceID)
    m_pCurrentInkPoint = byref(currentInkPoint)
    m_nResult = c_int32()
    m_nResult = __PPL500_GetInkPointData(m_deviceID, m_pCurrentInkPoint)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL500_GetInkPointDataTimeInfo(deviceID, nIndex)
#==========================================================================
def API_PPL500_GetInkPointDataTimeInfo():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL500_GetInkPointDataTimeInfo
    func.argtypes = [c_int32, c_int32]
    func.restype = POINTER(c_char)
    return func

__PPL500_GetInkPointDataTimeInfo = API_PPL500_GetInkPointDataTimeInfo()

def PPL500_GetInkPointDataTimeInfo(deviceID, nIndex):
    m_deviceID = c_int32(deviceID)
    m_nIndex = c_int32(nIndex)
    m_pChar = POINTER(c_char)
    m_pChar = __PPL500_GetInkPointDataTimeInfo(m_deviceID, m_nIndex)
    return m_pChar
#==========================================================================
#
#==========================================================================
# PPL500_FreeInkPointDataTimeInfo(deviceID, pData)
#==========================================================================
def API_PPL500_FreeInkPointDataTimeInfo():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL500_FreeInkPointDataTimeInfo
    func.argtypes = [c_int32, c_char_p]
    func.restype = None
    return func

__PPL500_FreeInkPointDataTimeInfo = API_PPL500_FreeInkPointDataTimeInfo()

def PPL500_FreeInkPointDataTimeInfo(deviceID, pData):
    m_deviceID = c_int32(deviceID)
    m_pData = pData
    __PPL500_FreeInkPointDataTimeInfo(m_deviceID, m_pData)
#==========================================================================
#
#==========================================================================
# PPL500_GetDeviceInfo(deviceID, nIndex, Output)
#==========================================================================
def API_PPL500_GetDeviceInfo():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL500_GetDeviceInfo
    func.argtypes = [c_int32, c_int32, c_void_p]
    func.restype = c_int32
    return func

__PPL500_GetDeviceInfo = API_PPL500_GetDeviceInfo()

def PPL500_GetDeviceInfo(deviceID, nIndex, Output):
    m_deviceID = c_int32(deviceID)
    m_nIndex = c_int32(nIndex)
    m_pOutput = byref(Output)
    m_nResult = c_int32()
    m_nResult = __PPL500_GetDeviceInfo(m_deviceID, m_nIndex, m_pOutput)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL500_SignPadEventCallback(deviceID, SIGNPAD_EVENT_CALLBACK pSignPadEventCallback)
#==========================================================================
def API_PPL500_SignPadEventCallback():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL500_SignPadEventCallback
    func.argtypes = [c_int32, SIGNPAD_EVENT_CALLBACK]
    func.restype = c_int32
    return func

__PPL500_SignPadEventCallback = API_PPL500_SignPadEventCallback()

def PPL500_SignPadEventCallback(deviceID, pSignPadEventCallback):
    m_deviceID = c_int32(deviceID)
    m_pSignPadEventCallback = pSignPadEventCallback
    m_nResult = c_int32()
    m_nResult = __PPL500_SignPadEventCallback(m_deviceID, m_pSignPadEventCallback)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL500_GetHWPenID(deviceID, pPenID, nMaxCount)
#==========================================================================
def API_PPL500_GetHWPenID():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL500_GetHWPenID
    func.argtypes = [c_int32, c_void_p, c_int32]
    func.restype = c_int32
    return func

__PPL500_GetHWPenID = API_PPL500_GetHWPenID()

def PPL500_GetHWPenID(deviceID, pPenID, nMaxCount):
    m_deviceID = c_int32(deviceID)
    m_pPenID = byref(pPenID)
    m_nMaxCount = c_int32(nMaxCount)
    m_nResult = c_int32()
    m_nResult = __PPL500_GetHWPenID(m_deviceID, m_pPenID, m_nMaxCount)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL500_GetHWVersion(deviceID, pVersion, nMaxCount)
#==========================================================================
def API_PPL500_GetHWVersion():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL500_GetHWVersion
    func.argtypes = [c_int32, c_void_p, c_int32]
    func.restype = c_int32
    return func

__PPL500_GetHWVersion = API_PPL500_GetHWVersion()

def PPL500_GetHWVersion(deviceID, pVersion, nMaxCount):
    m_deviceID = c_int32(deviceID)
    m_pVersion = byref(pVersion)
    m_nMaxCount = c_int32(nMaxCount)    
    m_nResult = c_int32()
    m_nResult = __PPL500_GetHWVersion(m_deviceID, m_pVersion, m_nMaxCount)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL500_GetHWPadID(deviceID, pPadID, nMaxCount)
#==========================================================================
def API_PPL500_GetHWPadID():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL500_GetHWPadID
    func.argtypes = [c_int32, c_void_p, c_int32]
    func.restype = c_int32
    return func

__PPL500_GetHWPadID = API_PPL500_GetHWPadID()

def PPL500_GetHWPadID(deviceID, pPadID, nMaxCount):
    m_deviceID = c_int32(deviceID)
    m_pPadID = byref(pPadID)
    m_nMaxCount = c_int32(nMaxCount)    
    m_nResult = c_int32()
    m_nResult = __PPL500_GetHWPadID(m_deviceID, m_pPadID, m_nMaxCount)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL500_DisplayHWVersion(deviceID, bOn)
#==========================================================================
def API_PPL500_DisplayHWVersion():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL500_DisplayHWVersion
    func.argtypes = [c_int32, c_bool]
    func.restype = c_int32
    return func

__PPL500_DisplayHWVersion = API_PPL500_DisplayHWVersion()

def PPL500_DisplayHWVersion(deviceID, bOn):
    m_deviceID = c_int32(deviceID)
    m_bOn = c_bool(bOn)
    m_nResult = c_int32()
    m_nResult = __PPL500_DisplayHWVersion(m_deviceID, m_bOn)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL500_OpenLCD(deviceID, bOn)
#==========================================================================
def API_PPL500_OpenLCD():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL500_OpenLCD
    func.argtypes = [c_int32, c_bool]
    func.restype = c_int32
    return func

__PPL500_OpenLCD = API_PPL500_OpenLCD()

def PPL500_OpenLCD(deviceID, bOn):
    m_deviceID = c_int32(deviceID)
    m_bOn = c_bool(bOn)
    m_nResult = c_int32()
    m_nResult = __PPL500_OpenLCD(m_deviceID, m_bOn)
    return m_nResult
#==========================================================================
