#=====================================================
# -*- coding: utf-8 -*-
# author : Julio - PenPower Digital Development Dept.
# Creation : 2024.09.19.
# Target Platform : Python v2.x Runtime Environment
#=====================================================

from enum import Enum
from ctypes import *
from structdefs import *

#--------------------------------------------------------------------------
# PPLC700 APIs Definitions
#--------------------------------------------------------------------------
#
#==========================================================================
# PPLC700_InitialDevice(deviceID, widgetPtr, x, y, nWidth, nHeight)
#==========================================================================
def API_PPLC700_InitialDevice():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPLC700_InitialDevice
    func.argtypes = [c_int32, c_void_p, c_int32, c_int32, c_int32, c_int32]
    func.restype = c_bool
    return func

__PPLC700_InitialDevice = API_PPLC700_InitialDevice()

def PPLC700_InitialDevice(deviceID, widgetPtr, x, y, nWidth, nHeight):
    m_deviceID = c_int32(deviceID)
    m_pWidget = cast(widgetPtr, c_void_p)
    m_x = c_int32(x)
    m_y = c_int32(y)
    m_Width = c_int32(nWidth)
    m_Height = c_int32(nHeight)
    m_bResult = c_bool()
    m_bResult = __PPLC700_InitialDevice(m_deviceID, m_pWidget, m_x, m_y, m_Width, m_Height)
    return m_bResult
#==========================================================================
#
#==========================================================================
# PPLC700_UnInitialDevice(deviceID)
#==========================================================================
def API_PPLC700_UnInitialDevice():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPLC700_UnInitialDevice
    func.argtypes = [c_int32]
    func.restype = c_int32
    return func

__PPLC700_UnInitialDevice = API_PPLC700_UnInitialDevice()

def PPLC700_UnInitialDevice(deviceID):
    m_deviceID = c_int32(deviceID)
    m_nResult = c_int32()
    m_nResult = __PPLC700_UnInitialDevice(m_deviceID)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPLC700_AboutBox(widgetPtr)
#==========================================================================
def API_PPLC700_AboutBox():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPLC700_AboutBox
    func.argtypes = [c_void_p]
    return func

__PPLC700_AboutBox = API_PPLC700_AboutBox()

def PPLC700_AboutBox(widgetPtr):
    m_pWidget = cast(widgetPtr, c_void_p)
    __PPLC700_AboutBox(m_pWidget)
#==========================================================================
#
#==========================================================================
# PPLC700_SetPenColor(deviceID, nR, nG, nB)
#==========================================================================
def API_PPLC700_SetPenColor():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPLC700_SetPenColor
    func.argtypes = [c_int32, c_int32, c_int32, c_int32]
    func.restype = c_int32
    return func

__PPLC700_SetPenColor = API_PPLC700_SetPenColor()

def PPLC700_SetPenColor(deviceID, nR, nG, nB):
    m_deviceID = c_int32(deviceID)
    m_nR = c_int32(nR)
    m_nG = c_int32(nG)
    m_nB = c_int32(nB)
    m_nResult = c_int32()
    m_nResult = __PPLC700_SetPenColor(m_deviceID, m_nR, m_nG, m_nB)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPLC700_SetPenWidth(deviceID, nWidth)
#==========================================================================
def API_PPLC700_SetPenWidth():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPLC700_SetPenWidth
    func.argtypes = [c_int32, c_int32]
    func.restype = c_int32
    return func

__PPLC700_SetPenWidth = API_PPLC700_SetPenWidth()

def PPLC700_SetPenWidth(deviceID, nWidth):
    m_deviceID = c_int32(deviceID)
    m_nWidth = c_int32(nWidth)
    m_nResult = c_int32()
    m_nResult = __PPLC700_SetPenWidth(m_deviceID, m_nWidth)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPLC700_SetPenStyle(deviceID, bPressureOn)
#==========================================================================
def API_PPLC700_SetPenStyle():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPLC700_SetPenStyle
    func.argtypes = [c_int32, c_bool]
    func.restype = c_int32
    return func

__PPLC700_SetPenStyle = API_PPLC700_SetPenStyle()

def PPLC700_SetPenStyle(deviceID, bPressureOn):
    m_deviceID = c_int32(deviceID)
    m_bPressureOn = c_bool(bPressureOn)
    m_nResult = c_int32()
    m_nResult = __PPLC700_SetPenStyle(m_deviceID, m_bPressureOn)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPLC700_Clear(deviceID)
#==========================================================================
def API_PPLC700_Clear():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPLC700_Clear
    func.argtypes = [c_int32]
    func.restype = c_int32
    return func

__PPLC700_Clear = API_PPLC700_Clear()

def PPLC700_Clear(deviceID):
    m_deviceID = c_int32(deviceID)
    m_nResult = c_int32()
    m_nResult = __PPLC700_Clear(m_deviceID)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPLC700_Base64Encode(deviceID, nImageTypeID)
#==========================================================================
def API_PPLC700_Base64Encode():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPLC700_Base64Encode
    func.argtypes = [c_int32, c_int32]
    func.restype = POINTER(c_char)
    return func

__PPLC700_Base64Encode = API_PPLC700_Base64Encode()

def PPLC700_Base64Encode(deviceID, nImageTypeID):
    m_deviceID = c_int32(deviceID)
    m_nImageTypeID = c_int32(nImageTypeID)
    m_pChar = POINTER(c_char)
    m_pChar = __PPLC700_Base64Encode(m_deviceID, m_nImageTypeID)
    return m_pChar
#==========================================================================
#
#==========================================================================
# PPLC700_Base64EncodeFree(deviceID, pData)
#==========================================================================
def API_PPLC700_Base64EncodeFree():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPLC700_Base64EncodeFree
    func.argtypes = [c_int32, c_char_p]
    func.restype = None
    return func

__PPLC700_Base64EncodeFree = API_PPLC700_Base64EncodeFree()

def PPLC700_Base64EncodeFree(deviceID, pData):
    m_deviceID = c_int32(deviceID)
    m_pData = pData
    __PPLC700_Base64EncodeFree(m_deviceID, m_pData)
#==========================================================================
#
#==========================================================================
# PPLC700_GetTotalInkPointsNumber(deviceID)
#==========================================================================
def PPLC700_GetTotalInkPointsNumber():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPLC700_GetTotalInkPointsNumber
    func.argtypes = [c_int32]
    func.restype = c_int32
    return func

__PPLC700_GetTotalInkPointsNumber = PPLC700_GetTotalInkPointsNumber()

def PPLC700_GetTotalInkPointsNumber(deviceID):
    m_deviceID = c_int32(deviceID)
    m_nResult = c_int32()
    m_nResult = __PPLC700_GetTotalInkPointsNumber(m_deviceID)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPLC700_Base64Decode(deviceID, nImageTypeID, encodeString, wDecodeFilePath)
#==========================================================================
def API_PPLC700_Base64Decode():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPLC700_Base64Decode
    func.argtypes = [c_int32, c_int32, c_char_p, c_wchar_p]
    func.restype = c_int32
    return func

__PPLC700_Base64Decode = API_PPLC700_Base64Decode()

def PPLC700_Base64Decode(deviceID, nImageTypeID, encodeString, wDecodeFilePath):
    m_deviceID = c_int32(deviceID)
    m_nImageTypeID = c_int32(nImageTypeID)
    m_pEncodeString = c_char_p(encodeString)
    m_pwDecodeFilePath = wDecodeFilePath
    m_nResult = c_int32()
    m_nResult = __PPLC700_Base64Decode(m_deviceID, m_nImageTypeID, m_pEncodeString, m_pwDecodeFilePath)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPLC700_GetDecodeInkPointData(deviceID, nIndex, nTypeID)
#==========================================================================
def API_PPLC700_GetDecodeInkPointData():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPLC700_GetDecodeInkPointData
    func.argtypes = [c_int32, c_int32, c_int32]
    func.restype = c_int32
    return func

__PPLC700_GetDecodeInkPointData = API_PPLC700_GetDecodeInkPointData()

def PPLC700_GetDecodeInkPointData(deviceID, nIndex, nTypeID):
    m_deviceID = c_int32(deviceID)
    m_nIndex = c_int32(nIndex)
    m_nTypeID = c_int32(nTypeID)
    m_nResult = c_int32()
    m_nResult = __PPLC700_GetDecodeInkPointData(m_deviceID, m_nIndex, m_nTypeID)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPLC700_GetTotalDecodeInkPointsNumber(deviceID)
#==========================================================================
def API_PPLC700_GetTotalDecodeInkPointsNumber():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPLC700_GetTotalDecodeInkPointsNumber
    func.argtypes = [c_int32]
    func.restype = c_int32
    return func

__PPLC700_GetTotalDecodeInkPointsNumber = API_PPLC700_GetTotalDecodeInkPointsNumber()

def PPLC700_GetTotalDecodeInkPointsNumber(deviceID):
    m_deviceID = c_int32(deviceID)
    m_nResult = c_int32()
    m_nResult = __PPLC700_GetTotalDecodeInkPointsNumber(m_deviceID)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPLC700_SetSaveClipImageMargin(deviceID, bClipImage, nClipMarginX, nClipMarginY)
#==========================================================================
def API_PPLC700_SetSaveClipImageMargin():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPLC700_SetSaveClipImageMargin
    func.argtypes = [c_int32, c_bool, c_int32, c_int32]
    func.restype = c_int32
    return func

__PPLC700_SetSaveClipImageMargin = API_PPLC700_SetSaveClipImageMargin()

def PPLC700_SetSaveClipImageMargin(deviceID, bClipImage, nClipMarginX, nClipMarginY):
    m_deviceID = c_int32(deviceID)
    m_bClipImage = c_bool(bClipImage)
    m_nClipMarginX = c_int32(nClipMarginX)
    m_nClipMarginY = c_int32(nClipMarginY)
    m_bResult = c_int32()
    m_bResult = __PPLC700_SetSaveClipImageMargin(m_deviceID, m_bClipImage, m_nClipMarginX, m_nClipMarginY)
    return m_bResult
#==========================================================================
#
#==========================================================================
# PPLC700_SaveDrawingImage(deviceID, nImageTypeID, pwImageFilePath, nDPILevel)
#==========================================================================
def API_PPLC700_SaveDrawingImage():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPLC700_SaveDrawingImage
    func.argtypes = [c_int32, c_int32, c_wchar_p, c_int32]
    func.restype = c_int32
    return func

__PPLC700_SaveDrawingImage = API_PPLC700_SaveDrawingImage()

def PPLC700_SaveDrawingImage(deviceID, nImageTypeID, pwImageFilePath, nDPILevel):
    m_deviceID = c_int32(deviceID)
    m_nImageTypeID = c_int32(nImageTypeID)
    m_pwImageFilePath = pwImageFilePath
    m_nDPILevel = c_int32(nDPILevel)
    m_nResult = c_int32()
    m_nResult = __PPLC700_SaveDrawingImage(m_deviceID, m_nImageTypeID, m_pwImageFilePath, m_nDPILevel)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPLC700_GetInkPointData(deviceID, currentInkPoint)
#==========================================================================
def API_PPLC700_GetInkPointData():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPLC700_GetInkPointData
    func.argtypes = [c_int32, POINTER(INKPOINTDATA)]
    func.restype = c_int32
    return func

__PPLC700_GetInkPointData = API_PPLC700_GetInkPointData()

def PPLC700_GetInkPointData(deviceID, currentInkPoint):
    m_deviceID = c_int32(deviceID)
    m_pCurrentInkPoint = byref(currentInkPoint)
    m_nResult = c_int32()
    m_nResult = __PPLC700_GetInkPointData(m_deviceID, m_pCurrentInkPoint)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPLC700_GetInkPointDataTimeInfo(deviceID, nIndex)
#==========================================================================
def API_PPLC700_GetInkPointDataTimeInfo():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPLC700_GetInkPointDataTimeInfo
    func.argtypes = [c_int32, c_int32]
    func.restype = POINTER(c_char)
    return func

__PPLC700_GetInkPointDataTimeInfo = API_PPLC700_GetInkPointDataTimeInfo()

def PPLC700_GetInkPointDataTimeInfo(deviceID, nIndex):
    m_deviceID = c_int32(deviceID)
    m_nIndex = c_int32(nIndex)
    m_pChar = POINTER(c_char)
    m_pChar = __PPLC700_GetInkPointDataTimeInfo(m_deviceID, m_nIndex)
    return m_pChar
#==========================================================================
#
#==========================================================================
# PPLC700_FreeInkPointDataTimeInfo(deviceID, pData)
#==========================================================================
def API_PPLC700_FreeInkPointDataTimeInfo():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPLC700_FreeInkPointDataTimeInfo
    func.argtypes = [c_int32, c_char_p]
    func.restype = None
    return func

__PPLC700_FreeInkPointDataTimeInfo = API_PPLC700_FreeInkPointDataTimeInfo()

def PPLC700_FreeInkPointDataTimeInfo(deviceID, pData):
    m_deviceID = c_int32(deviceID)
    m_pData = pData
    __PPLC700_FreeInkPointDataTimeInfo(m_deviceID, m_pData)
#==========================================================================
#
#==========================================================================
# PPLC700_GetDeviceInfo(deviceID, nIndex, Output)
#==========================================================================
def API_PPLC700_GetDeviceInfo():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPLC700_GetDeviceInfo
    func.argtypes = [c_int32, c_int32, c_void_p]
    func.restype = c_int32
    return func

__PPLC700_GetDeviceInfo = API_PPLC700_GetDeviceInfo()

def PPLC700_GetDeviceInfo(deviceID, nIndex, Output):
    m_deviceID = c_int32(deviceID)
    m_nIndex = c_int32(nIndex)
    m_pOutput = byref(Output)
    m_nResult = c_int32()
    m_nResult = __PPLC700_GetDeviceInfo(m_deviceID, m_nIndex, m_pOutput)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPLC700_SignPadEventCallback(deviceID, SIGNPAD_EVENT_CALLBACK pSignPadEventCallback)
#==========================================================================
def API_PPLC700_SignPadEventCallback():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPLC700_SignPadEventCallback
    func.argtypes = [c_int32, SIGNPAD_EVENT_CALLBACK]
    func.restype = c_int32
    return func

__PPLC700_SignPadEventCallback = API_PPLC700_SignPadEventCallback()

def PPLC700_SignPadEventCallback(deviceID, pSignPadEventCallback):
    m_deviceID = c_int32(deviceID)
    m_pSignPadEventCallback = pSignPadEventCallback
    m_nResult = c_int32()
    m_nResult = __PPLC700_SignPadEventCallback(m_deviceID, m_pSignPadEventCallback)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPLC700_GetHWVersion(deviceID, pVersion, nMaxCount)
#==========================================================================
def API_PPLC700_GetHWVersion():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPLC700_GetHWVersion
    func.argtypes = [c_int32, c_void_p, c_int32]
    func.restype = c_int32
    return func

__PPLC700_GetHWVersion = API_PPLC700_GetHWVersion()

def PPLC700_GetHWVersion(deviceID, pVersion, nMaxCount):
    m_deviceID = c_int32(deviceID)
    m_pVersion = byref(pVersion)
    m_nMaxCount = c_int32(nMaxCount)    
    m_nResult = c_int32()
    m_nResult = __PPLC700_GetHWVersion(m_deviceID, m_pVersion, m_nMaxCount)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPLC700_GetHWPadID(deviceID, pPadID, nMaxCount)
#==========================================================================
def API_PPLC700_GetHWPadID():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPLC700_GetHWPadID
    func.argtypes = [c_int32, c_void_p, c_int32]
    func.restype = c_int32
    return func

__PPLC700_GetHWPadID = API_PPLC700_GetHWPadID()

def PPLC700_GetHWPadID(deviceID, pPadID, nMaxCount):
    m_deviceID = c_int32(deviceID)
    m_pPadID = byref(pPadID)
    m_nMaxCount = c_int32(nMaxCount)    
    m_nResult = c_int32()
    m_nResult = __PPLC700_GetHWPadID(m_deviceID, m_pPadID, m_nMaxCount)
    return m_nResult
#==========================================================================
