#=====================================================
# -*- coding: utf-8 -*-
# author : Julio - PenPower Digital Development Dept.
# Creation : 2024.09.16.
# Target Platform : Python v2.x Runtime Environment
#=====================================================

from enum import Enum
from ctypes import *
from structdefs import *

#--------------------------------------------------------------------------
# PPL398 APIs Definitions
#--------------------------------------------------------------------------
#
#==========================================================================
# PPL398_InitialDevice(deviceID, widgetPtr, x, y, nWidth, nHeight)
#==========================================================================
def API_PPL398_InitialDevice():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL398_InitialDevice
    func.argtypes = [c_int32, c_void_p, c_int32, c_int32, c_int32, c_int32]
    func.restype = c_bool
    return func

__PPL398_InitialDevice = API_PPL398_InitialDevice()

def PPL398_InitialDevice(deviceID, widgetPtr, x, y, nWidth, nHeight):
    m_deviceID = c_int32(deviceID)
    m_pWidget = cast(widgetPtr, c_void_p)
    m_x = c_int32(x)
    m_y = c_int32(y)
    m_Width = c_int32(nWidth)
    m_Height = c_int32(nHeight)
    m_bResult = c_bool()
    m_bResult = __PPL398_InitialDevice(m_deviceID, m_pWidget, m_x, m_y, m_Width, m_Height)
    return m_bResult
#==========================================================================
#
#==========================================================================
# PPL398_UnInitialDevice(deviceID)
#==========================================================================
def API_PPL398_UnInitialDevice():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL398_UnInitialDevice
    func.argtypes = [c_int32]
    func.restype = c_int32
    return func

__PPL398_UnInitialDevice = API_PPL398_UnInitialDevice()

def PPL398_UnInitialDevice(deviceID):
    m_deviceID = c_int32(deviceID)
    m_nResult = c_int32()
    m_nResult = __PPL398_UnInitialDevice(m_deviceID)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL398_AboutBox(widgetPtr)
#==========================================================================
def API_PPL398_AboutBox():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL398_AboutBox
    func.argtypes = [c_void_p]
    return func

__PPL398_AboutBox = API_PPL398_AboutBox()

def PPL398_AboutBox(widgetPtr):
    m_pWidget = cast(widgetPtr, c_void_p)
    __PPL398_AboutBox(m_pWidget)
#==========================================================================
#
#==========================================================================
# PPL398_SetPenColor(deviceID, nR, nG, nB)
#==========================================================================
def API_PPL398_SetPenColor():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL398_SetPenColor
    func.argtypes = [c_int32, c_int32, c_int32, c_int32]
    func.restype = c_int32
    return func

__PPL398_SetPenColor = API_PPL398_SetPenColor()

def PPL398_SetPenColor(deviceID, nR, nG, nB):
    m_deviceID = c_int32(deviceID)
    m_nR = c_int32(nR)
    m_nG = c_int32(nG)
    m_nB = c_int32(nB)
    m_nResult = c_int32()
    m_nResult = __PPL398_SetPenColor(m_deviceID, m_nR, m_nG, m_nB)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL398_SetPenWidth(deviceID, nWidth)
#==========================================================================
def API_PPL398_SetPenWidth():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL398_SetPenWidth
    func.argtypes = [c_int32, c_int32]
    func.restype = c_int32
    return func

__PPL398_SetPenWidth = API_PPL398_SetPenWidth()

def PPL398_SetPenWidth(deviceID, nWidth):
    m_deviceID = c_int32(deviceID)
    m_nWidth = c_int32(nWidth)
    m_nResult = c_int32()
    m_nResult = __PPL398_SetPenWidth(m_deviceID, m_nWidth)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL398_SetPenStyle(deviceID, bPressureOn)
#==========================================================================
def API_PPL398_SetPenStyle():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL398_SetPenStyle
    func.argtypes = [c_int32, c_bool]
    func.restype = c_int32
    return func

__PPL398_SetPenStyle = API_PPL398_SetPenStyle()

def PPL398_SetPenStyle(deviceID, bPressureOn):
    m_deviceID = c_int32(deviceID)
    m_bPressureOn = c_bool(bPressureOn)
    m_nResult = c_int32()
    m_nResult = __PPL398_SetPenStyle(m_deviceID, m_bPressureOn)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL398_Clear(deviceID)
#==========================================================================
def API_PPL398_Clear():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL398_Clear
    func.argtypes = [c_int32]
    func.restype = c_int32
    return func

__PPL398_Clear = API_PPL398_Clear()

def PPL398_Clear(deviceID):
    m_deviceID = c_int32(deviceID)
    m_nResult = c_int32()
    m_nResult = __PPL398_Clear(m_deviceID)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL398_Base64Encode(deviceID, nImageTypeID)
#==========================================================================
def API_PPL398_Base64Encode():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL398_Base64Encode
    func.argtypes = [c_int32, c_int32]
    func.restype = POINTER(c_char)
    return func

__PPL398_Base64Encode = API_PPL398_Base64Encode()

def PPL398_Base64Encode(deviceID, nImageTypeID):
    m_deviceID = c_int32(deviceID)
    m_nImageTypeID = c_int32(nImageTypeID)
    m_pChar = POINTER(c_char)
    m_pChar = __PPL398_Base64Encode(m_deviceID, m_nImageTypeID)
    return m_pChar
#==========================================================================
#
#==========================================================================
# PPL398_Base64EncodeFree(deviceID, pData)
#==========================================================================
def API_PPL398_Base64EncodeFree():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL398_Base64EncodeFree
    func.argtypes = [c_int32, c_char_p]
    func.restype = None
    return func

__PPL398_Base64EncodeFree = API_PPL398_Base64EncodeFree()

def PPL398_Base64EncodeFree(deviceID, pData):
    m_deviceID = c_int32(deviceID)
    m_pData = pData
    __PPL398_Base64EncodeFree(m_deviceID, m_pData)
#==========================================================================
#
#==========================================================================
# PPL398_GetTotalInkPointsNumber(deviceID)
#==========================================================================
def PPL398_GetTotalInkPointsNumber():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL398_GetTotalInkPointsNumber
    func.argtypes = [c_int32]
    func.restype = c_int32
    return func

__PPL398_GetTotalInkPointsNumber = PPL398_GetTotalInkPointsNumber()

def PPL398_GetTotalInkPointsNumber(deviceID):
    m_deviceID = c_int32(deviceID)
    m_nResult = c_int32()
    m_nResult = __PPL398_GetTotalInkPointsNumber(m_deviceID)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL398_Base64Decode(deviceID, nImageTypeID, encodeString, wDecodeFilePath)
#==========================================================================
def API_PPL398_Base64Decode():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL398_Base64Decode
    func.argtypes = [c_int32, c_int32, c_char_p, c_wchar_p]
    func.restype = c_int32
    return func

__PPL398_Base64Decode = API_PPL398_Base64Decode()

def PPL398_Base64Decode(deviceID, nImageTypeID, encodeString, wDecodeFilePath):
    m_deviceID = c_int32(deviceID)
    m_nImageTypeID = c_int32(nImageTypeID)
    m_pEncodeString = c_char_p(encodeString)
    m_pwDecodeFilePath = wDecodeFilePath
    m_nResult = c_int32()
    m_nResult = __PPL398_Base64Decode(m_deviceID, m_nImageTypeID, m_pEncodeString, m_pwDecodeFilePath)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL398_GetDecodeInkPointData(deviceID, nIndex, nTypeID)
#==========================================================================
def API_PPL398_GetDecodeInkPointData():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL398_GetDecodeInkPointData
    func.argtypes = [c_int32, c_int32, c_int32]
    func.restype = c_int32
    return func

__PPL398_GetDecodeInkPointData = API_PPL398_GetDecodeInkPointData()

def PPL398_GetDecodeInkPointData(deviceID, nIndex, nTypeID):
    m_deviceID = c_int32(deviceID)
    m_nIndex = c_int32(nIndex)
    m_nTypeID = c_int32(nTypeID)
    m_nResult = c_int32()
    m_nResult = __PPL398_GetDecodeInkPointData(m_deviceID, m_nIndex, m_nTypeID)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL398_GetTotalDecodeInkPointsNumber(deviceID)
#==========================================================================
def API_PPL398_GetTotalDecodeInkPointsNumber():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL398_GetTotalDecodeInkPointsNumber
    func.argtypes = [c_int32]
    func.restype = c_int32
    return func

__PPL398_GetTotalDecodeInkPointsNumber = API_PPL398_GetTotalDecodeInkPointsNumber()

def PPL398_GetTotalDecodeInkPointsNumber(deviceID):
    m_deviceID = c_int32(deviceID)
    m_nResult = c_int32()
    m_nResult = __PPL398_GetTotalDecodeInkPointsNumber(m_deviceID)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL398_SetSaveClipImageMargin(deviceID, bClipImage, nClipMarginX, nClipMarginY)
#==========================================================================
def API_PPL398_SetSaveClipImageMargin():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL398_SetSaveClipImageMargin
    func.argtypes = [c_int32, c_bool, c_int32, c_int32]
    func.restype = c_int32
    return func

__PPL398_SetSaveClipImageMargin = API_PPL398_SetSaveClipImageMargin()

def PPL398_SetSaveClipImageMargin(deviceID, bClipImage, nClipMarginX, nClipMarginY):
    m_deviceID = c_int32(deviceID)
    m_bClipImage = c_bool(bClipImage)
    m_nClipMarginX = c_int32(nClipMarginX)
    m_nClipMarginY = c_int32(nClipMarginY)
    m_bResult = c_int32()
    m_bResult = __PPL398_SetSaveClipImageMargin(m_deviceID, m_bClipImage, m_nClipMarginX, m_nClipMarginY)
    return m_bResult
#==========================================================================
#
#==========================================================================
# PPL398_SaveDrawingImage(deviceID, nImageTypeID, pwImageFilePath, nDPILevel)
#==========================================================================
def API_PPL398_SaveDrawingImage():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL398_SaveDrawingImage
    func.argtypes = [c_int32, c_int32, c_wchar_p, c_int32]
    func.restype = c_int32
    return func

__PPL398_SaveDrawingImage = API_PPL398_SaveDrawingImage()

def PPL398_SaveDrawingImage(deviceID, nImageTypeID, pwImageFilePath, nDPILevel):
    m_deviceID = c_int32(deviceID)
    m_nImageTypeID = c_int32(nImageTypeID)
    m_pwImageFilePath = pwImageFilePath
    m_nDPILevel = c_int32(nDPILevel)
    m_nResult = c_int32()
    m_nResult = __PPL398_SaveDrawingImage(m_deviceID, m_nImageTypeID, m_pwImageFilePath, m_nDPILevel)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL398_GetInkPointData(deviceID, currentInkPoint)
#==========================================================================
def API_PPL398_GetInkPointData():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL398_GetInkPointData
    func.argtypes = [c_int32, POINTER(INKPOINTDATA)]
    func.restype = c_int32
    return func

__PPL398_GetInkPointData = API_PPL398_GetInkPointData()

def PPL398_GetInkPointData(deviceID, currentInkPoint):
    m_deviceID = c_int32(deviceID)
    m_pCurrentInkPoint = byref(currentInkPoint)
    m_nResult = c_int32()
    m_nResult = __PPL398_GetInkPointData(m_deviceID, m_pCurrentInkPoint)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL398_GetInkPointDataTimeInfo(deviceID, nIndex)
#==========================================================================
def API_PPL398_GetInkPointDataTimeInfo():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL398_GetInkPointDataTimeInfo
    func.argtypes = [c_int32, c_int32]
    func.restype = POINTER(c_char)
    return func

__PPL398_GetInkPointDataTimeInfo = API_PPL398_GetInkPointDataTimeInfo()

def PPL398_GetInkPointDataTimeInfo(deviceID, nIndex):
    m_deviceID = c_int32(deviceID)
    m_nIndex = c_int32(nIndex)
    m_pChar = POINTER(c_char)
    m_pChar = __PPL398_GetInkPointDataTimeInfo(m_deviceID, m_nIndex)
    return m_pChar
#==========================================================================
#
#==========================================================================
# PPL398_FreeInkPointDataTimeInfo(deviceID, pData)
#==========================================================================
def API_PPL398_FreeInkPointDataTimeInfo():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL398_FreeInkPointDataTimeInfo
    func.argtypes = [c_int32, c_char_p]
    func.restype = None
    return func

__PPL398_FreeInkPointDataTimeInfo = API_PPL398_FreeInkPointDataTimeInfo()

def PPL398_FreeInkPointDataTimeInfo(deviceID, pData):
    m_deviceID = c_int32(deviceID)
    m_pData = pData
    __PPL398_FreeInkPointDataTimeInfo(m_deviceID, m_pData)
#==========================================================================
#
#==========================================================================
# PPL398_GetDeviceInfo(deviceID, nIndex, Output)
#==========================================================================
def API_PPL398_GetDeviceInfo():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL398_GetDeviceInfo
    func.argtypes = [c_int32, c_int32, c_void_p]
    func.restype = c_int32
    return func

__PPL398_GetDeviceInfo = API_PPL398_GetDeviceInfo()

def PPL398_GetDeviceInfo(deviceID, nIndex, Output):
    m_deviceID = c_int32(deviceID)
    m_nIndex = c_int32(nIndex)
    m_pOutput = byref(Output)
    m_nResult = c_int32()
    m_nResult = __PPL398_GetDeviceInfo(m_deviceID, m_nIndex, m_pOutput)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL398_SignPadEventCallback(deviceID, SIGNPAD_EVENT_CALLBACK pSignPadEventCallback)
#==========================================================================
def API_PPL398_SignPadEventCallback():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL398_SignPadEventCallback
    func.argtypes = [c_int32, SIGNPAD_EVENT_CALLBACK]
    func.restype = c_int32
    return func

__PPL398_SignPadEventCallback = API_PPL398_SignPadEventCallback()

def PPL398_SignPadEventCallback(deviceID, pSignPadEventCallback):
    m_deviceID = c_int32(deviceID)
    m_pSignPadEventCallback = pSignPadEventCallback
    m_nResult = c_int32()
    m_nResult = __PPL398_SignPadEventCallback(m_deviceID, m_pSignPadEventCallback)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL398_GetHWPenID(deviceID, pPenID, nMaxCount)
#==========================================================================
def API_PPL398_GetHWPenID():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL398_GetHWPenID
    func.argtypes = [c_int32, c_void_p, c_int32]
    func.restype = c_int32
    return func

__PPL398_GetHWPenID = API_PPL398_GetHWPenID()

def PPL398_GetHWPenID(deviceID, pPenID, nMaxCount):
    m_deviceID = c_int32(deviceID)
    m_pPenID = byref(pPenID)
    m_nMaxCount = c_int32(nMaxCount)
    m_nResult = c_int32()
    m_nResult = __PPL398_GetHWPenID(m_deviceID, m_pPenID, m_nMaxCount)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL398_GetHWVersion(deviceID, pVersion, nMaxCount)
#==========================================================================
def API_PPL398_GetHWVersion():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL398_GetHWVersion
    func.argtypes = [c_int32, c_void_p, c_int32]
    func.restype = c_int32
    return func

__PPL398_GetHWVersion = API_PPL398_GetHWVersion()

def PPL398_GetHWVersion(deviceID, pVersion, nMaxCount):
    m_deviceID = c_int32(deviceID)
    m_pVersion = byref(pVersion)
    m_nMaxCount = c_int32(nMaxCount)    
    m_nResult = c_int32()
    m_nResult = __PPL398_GetHWVersion(m_deviceID, m_pVersion, m_nMaxCount)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL398_GetHWPadID(deviceID, pPadID, nMaxCount)
#==========================================================================
def API_PPL398_GetHWPadID():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL398_GetHWPadID
    func.argtypes = [c_int32, c_void_p, c_int32]
    func.restype = c_int32
    return func

__PPL398_GetHWPadID = API_PPL398_GetHWPadID()

def PPL398_GetHWPadID(deviceID, pPadID, nMaxCount):
    m_deviceID = c_int32(deviceID)
    m_pPadID = byref(pPadID)
    m_nMaxCount = c_int32(nMaxCount)    
    m_nResult = c_int32()
    m_nResult = __PPL398_GetHWPadID(m_deviceID, m_pPadID, m_nMaxCount)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL398_DisplayHWVersion(deviceID, bOn)
#==========================================================================
def API_PPL398_DisplayHWVersion():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL398_DisplayHWVersion
    func.argtypes = [c_int32, c_bool]
    func.restype = c_int32
    return func

__PPL398_DisplayHWVersion = API_PPL398_DisplayHWVersion()

def PPL398_DisplayHWVersion(deviceID, bOn):
    m_deviceID = c_int32(deviceID)
    m_bOn = c_bool(bOn)
    m_nResult = c_int32()
    m_nResult = __PPL398_DisplayHWVersion(m_deviceID, m_bOn)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL398_OpenLCD(deviceID, bOn)
#==========================================================================
def API_PPL398_OpenLCD():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL398_OpenLCD
    func.argtypes = [c_int32, c_bool]
    func.restype = c_int32
    return func

__PPL398_OpenLCD = API_PPL398_OpenLCD()

def PPL398_OpenLCD(deviceID, bOn):
    m_deviceID = c_int32(deviceID)
    m_bOn = c_bool(bOn)
    m_nResult = c_int32()
    m_nResult = __PPL398_OpenLCD(m_deviceID, m_bOn)
    return m_nResult
#==========================================================================
