#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QScreen>
#include <QMessageBox>
#include <QDebug>
#include <QLibrary>
#include <QCloseEvent>
#include <QDir>

enum GET_INK_DATA_TYPE_ID
{
    INKDATATYPE_X = 1,
    INKDATATYPE_Y,
    INKDATATYPE_STROKEEND
};

enum ENCODE_BASE64_IMAGE_TYPE_ID
{
    EBITI_BITMAP = 1,
    EBITI_JPEG,
    EBITI_PNG,
    EBITI_INK = 6,
};

typedef struct _tagPPSDKVERSION
{
    int nMajorVersion;
    int nMinorVersion;

} PPSDKVERSION, *PPPSDKVERSION;

typedef struct _tagPPAXIS
{
    int nAXMin;
    int nAXMax;

} PPAXIS, *PPPAXIS;

enum GET_DEVICE_INFO_ID_LIST
{
    DIID_GET_STATUS = 1,
    DIID_GET_AXIS_X,
    DIID_GET_AXIS_Y,
    DIID_GET_PRESSURE,
    DIID_GET_VENDOR,
    DIID_GET_PRODUCT,
    DIID_GET_DRV_VER
};

enum IMAGE_TYPE_ID
{
    ITI_BITMAP = 1,
    ITI_JPEG,
    ITI_PNG,
    ITI_PDF = 7,
    ITI_SVG
};

enum DEVICE_TYPE_ID
{
    NONE_DEVICE = 0,
    PPL398_DEVICE = 2,
    PPL500_DEVICE = 5,
    PPL501F_DEVICE = 7,
    PPLC700_DEVICE = 3,
    PPE640_DEVICE = 4,
};

enum API_RETURN_ID
{
    ARI_SUCCESS = 0,
    ARI_FAIL = -1,
    ARI_INVALID_PARAMETERS = -2,
    ARI_DRIVER_INIT_FAIL = -3,
    ARI_DRIVER_OPEN_DEVICE_FAIL = -4,
    ARI_DRIVER_CLAIM_INTERFACE_FAIL = -5,
    ARI_DRIVER_CREATE_THREAD_FAIL = -6,
    ARI_DRIVER_SENT_CMD_FAIL = -7,
    ARI_INK_EMPTY = -8,
    ARI_SAVE_FAILE = -9,

};

typedef struct _INKPOINTDATA
{
    int nIndex;
    short nX;
    short nY;
    short nPressureValue;
    bool bStrokeEnd;

} INKPOINTDATA, *PINKPOINTDATA;

#define UNUSED(x)   (void)(x)
#define RX_DEVICE_DATA_MAX_SIZE 32

#define SIGNPAD_ENTER_BUTTON    1
#define SIGNPAD_CANCEL_BUTTON   0
#define MAX_PATH    256
typedef void (*SIGNPAD_EVENT_CALLBACK)(int nEventID);

// declare APIs...

// ==================================
// L398 APIs...
// ==================================
//
typedef bool (*PPL398_InitialDevice)(int nDeviceType, QWidget *pParentWidget, int nX, int nY, int nWidth, int nHeight);
typedef int (*PPL398_UnInitialDevice)(int nDeviceType);
typedef int (*PPL398_OpenLCD)(int nDeviceType, bool bOn);
typedef int (*PPL398_Clear)(int nDeviceType);
typedef int (*PPL398_GetHWPenID)(int nDeviceType, char* pPenID, int nMaxCount);
typedef int (*PPL398_GetHWPadID)(int nDeviceType, char* pPadID, int nMaxCount);
typedef int (*PPL398_GetHWVersion)(int nDeviceType, char* pVersion, int nMaxCount);
typedef int (*PPL398_DisplayHWVersion)(int nDeviceType, bool bOn);
typedef int (*PPL398_SetPenStyle)(int nDeviceType, bool bPressureOn);
typedef int (*PPL398_SetPenWidth)(int nDeviceType, int nPenWidth);
typedef int (*PPL398_SignPadEventCallback)(int nDeviceType, SIGNPAD_EVENT_CALLBACK pfnSignPadEventCallback);
typedef int (*PPL398_GetTotalInkPointsNumber)(int nDeviceType);
typedef int (*PPL398_GetInkPointData)(int nDeviceType, INKPOINTDATA& currentInkPoint);
typedef char* (*PPL398_GetInkPointDataTimeInfo)(int nDeviceType, int nIndex);
typedef void (*PPL398_FreeInkPointDataTimeInfo)(int nDeviceType, char* pInkPointDataTimeInfo);
typedef int (*PPL398_SaveDrawingImage)(int nDeviceType, int nImageTypeID, wchar_t* pImageFilePath, int nDPILevel);
typedef int (*PPL398_SetSaveClipImageMargin)(int nDeviceType, bool bClipImage, int nClipMarginX, int nClipMarginY);
typedef int (*PPL398_GetDeviceInfo)(int nDeviceType, int nIndex, void* pOutput);
typedef void (*PPL398_AboutBox)(QWidget *pParent);
typedef char* (*PPL398_Base64Encode)(int nDeviceType, int nImageTypeID);
typedef void (*PPL398_Base64EncodeFree)(int nDeviceType, char* pData);
typedef int (*PPL398_Base64Decode)(int nDeviceType, int nImageTypeID, const char* pEncodedData, wchar_t* pImageFilePath);
typedef int (*PPL398_GetTotalDecodeInkPointsNumber)(int nDeviceType);
typedef int (*PPL398_GetDecodeInkPointData)(int nDeviceType, int nIndex, int nTypeID);
typedef int (*PPL398_SetPenColor)(int nDeviceType, int nR, int nG, int nB);

// ==================================
// L500 APIs...
// ==================================
//
typedef bool (*PPL500_InitialDevice)(int nDeviceType, QWidget *pParentWidget, int nX, int nY, int nWidth, int nHeight);
typedef int (*PPL500_UnInitialDevice)(int nDeviceType);
typedef int (*PPL500_OpenLCD)(int nDeviceType, bool bOn);
typedef int (*PPL500_Clear)(int nDeviceType);
typedef int (*PPL500_GetHWPenID)(int nDeviceType, char* pPenID, int nMaxCount);
typedef int (*PPL500_GetHWPadID)(int nDeviceType, char* pPadID, int nMaxCount);
typedef int (*PPL500_GetHWVersion)(int nDeviceType, char* pVersion, int nMaxCount);
typedef int (*PPL500_DisplayHWVersion)(int nDeviceType, bool bOn);
typedef int (*PPL500_SetPenStyle)(int nDeviceType, bool bPressureOn);
typedef int (*PPL500_SetPenWidth)(int nDeviceType, int nPenWidth);
typedef int (*PPL500_SignPadEventCallback)(int nDeviceType, SIGNPAD_EVENT_CALLBACK pfnSignPadEventCallback);
typedef int (*PPL500_GetTotalInkPointsNumber)(int nDeviceType);
typedef int (*PPL500_GetInkPointData)(int nDeviceType, INKPOINTDATA& currentInkPoint);
typedef char* (*PPL500_GetInkPointDataTimeInfo)(int nDeviceType, int nIndex);
typedef void (*PPL500_FreeInkPointDataTimeInfo)(int nDeviceType, char* pInkPointDataTimeInfo);
typedef int (*PPL500_SaveDrawingImage)(int nDeviceType, int nImageTypeID, wchar_t* pImageFilePath, int nDPILevel);
typedef int (*PPL500_SetSaveClipImageMargin)(int nDeviceType, bool bClipImage, int nClipMarginX, int nClipMarginY);
typedef int (*PPL500_GetDeviceInfo)(int nDeviceType, int nIndex, void* pOutput);
typedef void (*PPL500_AboutBox)(QWidget *pParent);
typedef char* (*PPL500_Base64Encode)(int nDeviceType, int nImageTypeID);
typedef void (*PPL500_Base64EncodeFree)(int nDeviceType, char* pData);
typedef int (*PPL500_Base64Decode)(int nDeviceType, int nImageTypeID, const char* pEncodedData, wchar_t* pImageFilePath);
typedef int (*PPL500_GetTotalDecodeInkPointsNumber)(int nDeviceType);
typedef int (*PPL500_GetDecodeInkPointData)(int nDeviceType, int nIndex, int nTypeID);
typedef int (*PPL500_SetPenColor)(int nDeviceType, int nR, int nG, int nB);

// ==================================
// L501F APIs...
// ==================================
typedef bool (*PPL501F_InitialDevice)(int nDeviceType, QWidget *pParentWidget, int nX, int nY, int nWidth, int nHeight);
typedef int (*PPL501F_UnInitialDevice)(int nDeviceType);
typedef int (*PPL501F_OpenLCD)(int nDeviceType, bool bOn);
typedef int (*PPL501F_Clear)(int nDeviceType);
typedef int (*PPL501F_GetHWPenID)(int nDeviceType, char* pPenID, int nMaxCount);
typedef int (*PPL501F_GetHWPadID)(int nDeviceType, char* pPadID, int nMaxCount);
typedef int (*PPL501F_GetHWVersion)(int nDeviceType, char* pVersion, int nMaxCount);
typedef int (*PPL501F_DisplayHWVersion)(int nDeviceType, bool bOn);
typedef int (*PPL501F_SetPenStyle)(int nDeviceType, bool bPressureOn);
typedef int (*PPL501F_SetPenWidth)(int nDeviceType, int nPenWidth);
typedef int (*PPL501F_SignPadEventCallback)(int nDeviceType, SIGNPAD_EVENT_CALLBACK pfnSignPadEventCallback);
typedef int (*PPL501F_GetTotalInkPointsNumber)(int nDeviceType);
typedef int (*PPL501F_GetInkPointData)(int nDeviceType, INKPOINTDATA& currentInkPoint);
typedef char* (*PPL501F_GetInkPointDataTimeInfo)(int nDeviceType, int nIndex);
typedef void (*PPL501F_FreeInkPointDataTimeInfo)(int nDeviceType, char* pInkPointDataTimeInfo);
typedef int (*PPL501F_SaveDrawingImage)(int nDeviceType, int nImageTypeID, wchar_t* pImageFilePath, int nDPILevel);
typedef int (*PPL501F_SetSaveClipImageMargin)(int nDeviceType, bool bClipImage, int nClipMarginX, int nClipMarginY);
typedef int (*PPL501F_GetDeviceInfo)(int nDeviceType, int nIndex, void* pOutput);
typedef void (*PPL501F_AboutBox)(QWidget *pParent);
typedef char* (*PPL501F_Base64Encode)(int nDeviceType, int nImageTypeID);
typedef void (*PPL501F_Base64EncodeFree)(int nDeviceType, char* pData);
typedef int (*PPL501F_Base64Decode)(int nDeviceType, int nImageTypeID, const char* pEncodedData, wchar_t* pImageFilePath);
typedef int (*PPL501F_GetTotalDecodeInkPointsNumber)(int nDeviceType);
typedef int (*PPL501F_GetDecodeInkPointData)(int nDeviceType, int nIndex, int nTypeID);
typedef int (*PPL501F_SetPenColor)(int nDeviceType, int nR, int nG, int nB);
typedef int (* PPL501F_SetDisplayedFPImageAt)(int nDeviceType, QWidget *pParentWidget, int nCanvasWidth, int nCanvasHeight, int nFPLeft, int nFPTop, int nFPWidth, int nFPHeight);
typedef char* (*PPL501F_GetFPImageBase64Data)(int nDeviceType, int nImageTypeID, bool bFPImageOnly);
typedef void (*PPL501F_FreeFPImageBase64Data)(int nDeviceType, char* pFPImageBase64Data);

// ==================================
// LC700 APIs...
// ==================================
//
typedef bool (*PPLC700_InitialDevice)(int nDeviceType, QWidget *pParentWidget, int nX, int nY, int nWidth, int nHeight);
typedef int (*PPLC700_UnInitialDevice)(int nDeviceType);
typedef int (*PPLC700_Clear)(int nDeviceType);
typedef int (*PPLC700_GetHWPadID)(int nDeviceType, char* pPadID, int nMaxCount);
typedef int (*PPLC700_GetHWVersion)(int nDeviceType, char* pVersion, int nMaxCount);
typedef int (*PPLC700_SetPenStyle)(int nDeviceType, bool bPressureOn);
typedef int (*PPLC700_SetPenWidth)(int nDeviceType, int nPenWidth);
typedef int (*PPLC700_SignPadEventCallback)(int nDeviceType, SIGNPAD_EVENT_CALLBACK pfnSignPadEventCallback);
typedef int (*PPLC700_GetTotalInkPointsNumber)(int nDeviceType);
typedef int (*PPLC700_GetInkPointData)(int nDeviceType, INKPOINTDATA& currentInkPoint);
typedef char* (*PPLC700_GetInkPointDataTimeInfo)(int nDeviceType, int nIndex);
typedef void (*PPLC700_FreeInkPointDataTimeInfo)(int nDeviceType, char* pInkPointDataTimeInfo);
typedef int (*PPLC700_SaveDrawingImage)(int nDeviceType, int nImageTypeID, wchar_t* pImageFilePath, int nDPILevel);
typedef int (*PPLC700_SetSaveClipImageMargin)(int nDeviceType, bool bClipImage, int nClipMarginX, int nClipMarginY);
typedef int (*PPLC700_GetDeviceInfo)(int nDeviceType, int nIndex, void* pOutput);
typedef void (*PPLC700_AboutBox)(QWidget *pParent);
typedef char* (*PPLC700_Base64Encode)(int nDeviceType, int nImageTypeID);
typedef void (*PPLC700_Base64EncodeFree)(int nDeviceType, char* pData);
typedef int (*PPLC700_Base64Decode)(int nDeviceType, int nImageTypeID, const char* pEncodedData, wchar_t* pImageFilePath);
typedef int (*PPLC700_GetTotalDecodeInkPointsNumber)(int nDeviceType);
typedef int (*PPLC700_GetDecodeInkPointData)(int nDeviceType, int nIndex, int nTypeID);
typedef int (*PPLC700_SetPenColor)(int nDeviceType, int nR, int nG, int nB);

// ==================================
// E640 APIs...
// ==================================
//
typedef bool (*PPE640_InitialDevice)(int nDeviceType, QWidget *pParentWidget, int nX, int nY, int nWidth, int nHeight);
typedef int (*PPE640_UnInitialDevice)(int nDeviceType);
typedef int (*PPE640_Clear)(int nDeviceType);
typedef int (*PPE640_GetHWPadID)(int nDeviceType, char* pPadID, int nMaxCount);
typedef int (*PPE640_GetHWVersion)(int nDeviceType, char* pVersion, int nMaxCount);
typedef int (*PPE640_SetPenStyle)(int nDeviceType, bool bPressureOn);
typedef int (*PPE640_SetPenWidth)(int nDeviceType, int nPenWidth);
typedef int (*PPE640_SignPadEventCallback)(int nDeviceType, SIGNPAD_EVENT_CALLBACK pfnSignPadEventCallback);
typedef int (*PPE640_GetTotalInkPointsNumber)(int nDeviceType);
typedef int (*PPE640_GetInkPointData)(int nDeviceType, INKPOINTDATA& currentInkPoint);
typedef char* (*PPE640_GetInkPointDataTimeInfo)(int nDeviceType, int nIndex);
typedef void (*PPE640_FreeInkPointDataTimeInfo)(int nDeviceType, char* pInkPointDataTimeInfo);
typedef int (*PPE640_SaveDrawingImage)(int nDeviceType, int nImageTypeID, wchar_t* pImageFilePath, int nDPILevel);
typedef int (*PPE640_SetSaveClipImageMargin)(int nDeviceType, bool bClipImage, int nClipMarginX, int nClipMarginY);
typedef int (*PPE640_GetDeviceInfo)(int nDeviceType, int nIndex, void* pOutput);
typedef void (*PPE640_AboutBox)(QWidget *pParent);
typedef char* (*PPE640_Base64Encode)(int nDeviceType, int nImageTypeID);
typedef void (*PPE640_Base64EncodeFree)(int nDeviceType, char* pData);
typedef int (*PPE640_Base64Decode)(int nDeviceType, int nImageTypeID, const char* pEncodedData, wchar_t* pImageFilePath);
typedef int (*PPE640_GetTotalDecodeInkPointsNumber)(int nDeviceType);
typedef int (*PPE640_GetDecodeInkPointData)(int nDeviceType, int nIndex, int nTypeID);
typedef int (*PPE640_SetPenColor)(int nDeviceType, int nR, int nG, int nB);

namespace Ui {
class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = nullptr);
    ~MainWindow();
    bool LoadPPSignPadSDK();
    void ProcessSignPadEvent(int nEventID);

private slots:
    void on_InitButton_clicked();
    void on_UnInitButton_clicked();
    void on_ClearButton_clicked();
    void on_OpenLCDButton_clicked();
    void on_CloseLCDButton_clicked();
    void on_PenIDButton_clicked();
    void on_PadIDButton_clicked();
    void on_HWVersionButton_clicked();
    void on_cbPenWidth_currentIndexChanged(int index);
    void on_GetSizeButton_clicked();
    void on_GetPointButton_clicked();
    void on_EncodeButton_clicked();
    void on_DecodeButton_clicked();
    void on_AboutButton_clicked();
    void on_GetDeviceInfoButton_clicked();
    void on_SetClipMarginButton_clicked();
    void on_SaveDrawingImageButton_clicked();
    void on_ShowVersionOnDeviceButton_clicked();

    void on_cbPenStyle_currentIndexChanged(int index);

    void on_cbSelectDevice_currentIndexChanged(int index);

    void on_cbPenColor_currentIndexChanged(int index);

private:
    Ui::MainWindow *ui;
    QLibrary *m_plibPPSignPadSDK;

    // ==================================
    // L398 APIs...
    // ==================================
    //
    PPL398_InitialDevice m_pfn_PPL398_InitialDevice;
    PPL398_UnInitialDevice m_pfn_PPL398_UnInitialDevice;
    PPL398_OpenLCD m_pfn_PPL398_OpenLCD;
    PPL398_Clear m_pfn_PPL398_Clear;
    PPL398_GetHWPenID m_pfn_PPL398_GetHWPenID;
    PPL398_GetHWPadID m_pfn_PPL398_GetHWPadID;
    PPL398_GetHWVersion m_pfn_PPL398_GetHWVersion;
    PPL398_DisplayHWVersion m_pfn_PPL398_DisplayHWVersion;
    PPL398_SetPenStyle m_pfn_PPL398_SetPenStyle;
    PPL398_SetPenWidth m_pfn_PPL398_SetPenWidth;
    PPL398_SignPadEventCallback m_pfn_PPL398_SignPadEventCallback;
    PPL398_GetTotalInkPointsNumber m_pfn_PPL398_GetTotalInkPointsNumber;
    PPL398_GetInkPointData m_pfn_PPL398_GetInkPointData;
    PPL398_GetInkPointDataTimeInfo m_pfn_PPL398_GetInkPointDataTimeInfo;
    PPL398_FreeInkPointDataTimeInfo m_pfn_PPL398_FreeInkPointDataTimeInfo;
    PPL398_SaveDrawingImage m_pfn_PPL398_SaveDrawingImage;
    PPL398_SetSaveClipImageMargin m_pfn_PPL398_SetSaveClipImageMargin;
    PPL398_GetDeviceInfo m_pfn_PPL398_GetDeviceInfo;
    PPL398_AboutBox m_pfn_PPL398_AboutBox;
    PPL398_Base64Encode m_pfn_PPL398_Base64Encode;
    PPL398_Base64EncodeFree m_pfn_PPL398_Base64EncodeFree;
    PPL398_Base64Decode m_pfn_PPL398_Base64Decode;
    PPL398_GetTotalDecodeInkPointsNumber m_pfn_PPL398_GetTotalDecodeInkPointsNumber;
    PPL398_GetDecodeInkPointData m_pfn_PPL398_GetDecodeInkPointData;
    PPL398_SetPenColor m_pfn_PPL398_SetPenColor;

    // ==================================
    // L500 APIs...
    // ==================================
    //
    PPL500_InitialDevice m_pfn_PPL500_InitialDevice;
    PPL500_UnInitialDevice m_pfn_PPL500_UnInitialDevice;
    PPL500_OpenLCD m_pfn_PPL500_OpenLCD;
    PPL500_Clear m_pfn_PPL500_Clear;
    PPL500_GetHWPenID m_pfn_PPL500_GetHWPenID;
    PPL500_GetHWPadID m_pfn_PPL500_GetHWPadID;
    PPL500_GetHWVersion m_pfn_PPL500_GetHWVersion;
    PPL500_DisplayHWVersion m_pfn_PPL500_DisplayHWVersion;
    PPL500_SetPenStyle m_pfn_PPL500_SetPenStyle;
    PPL500_SetPenWidth m_pfn_PPL500_SetPenWidth;
    PPL500_SignPadEventCallback m_pfn_PPL500_SignPadEventCallback;
    PPL500_GetTotalInkPointsNumber m_pfn_PPL500_GetTotalInkPointsNumber;
    PPL500_GetInkPointData m_pfn_PPL500_GetInkPointData;
    PPL500_GetInkPointDataTimeInfo m_pfn_PPL500_GetInkPointDataTimeInfo;
    PPL500_FreeInkPointDataTimeInfo m_pfn_PPL500_FreeInkPointDataTimeInfo;
    PPL500_SaveDrawingImage m_pfn_PPL500_SaveDrawingImage;
    PPL500_SetSaveClipImageMargin m_pfn_PPL500_SetSaveClipImageMargin;
    PPL500_GetDeviceInfo m_pfn_PPL500_GetDeviceInfo;
    PPL500_AboutBox m_pfn_PPL500_AboutBox;
    PPL500_Base64Encode m_pfn_PPL500_Base64Encode;
    PPL500_Base64EncodeFree m_pfn_PPL500_Base64EncodeFree;
    PPL500_Base64Decode m_pfn_PPL500_Base64Decode;
    PPL500_GetTotalDecodeInkPointsNumber m_pfn_PPL500_GetTotalDecodeInkPointsNumber;
    PPL500_GetDecodeInkPointData m_pfn_PPL500_GetDecodeInkPointData;
    PPL500_SetPenColor m_pfn_PPL500_SetPenColor;

    // ==================================
    // L501F APIs...
    // ==================================
    //
    PPL501F_InitialDevice m_pfn_PPL501F_InitialDevice;
    PPL501F_UnInitialDevice m_pfn_PPL501F_UnInitialDevice;
    PPL501F_OpenLCD m_pfn_PPL501F_OpenLCD;
    PPL501F_Clear m_pfn_PPL501F_Clear;
    PPL501F_GetHWPenID m_pfn_PPL501F_GetHWPenID;
    PPL501F_GetHWPadID m_pfn_PPL501F_GetHWPadID;
    PPL501F_GetHWVersion m_pfn_PPL501F_GetHWVersion;
    PPL501F_DisplayHWVersion m_pfn_PPL501F_DisplayHWVersion;
    PPL501F_SetPenStyle m_pfn_PPL501F_SetPenStyle;
    PPL501F_SetPenWidth m_pfn_PPL501F_SetPenWidth;
    PPL501F_SignPadEventCallback m_pfn_PPL501F_SignPadEventCallback;
    PPL501F_GetTotalInkPointsNumber m_pfn_PPL501F_GetTotalInkPointsNumber;
    PPL501F_GetInkPointData m_pfn_PPL501F_GetInkPointData;
    PPL501F_GetInkPointDataTimeInfo m_pfn_PPL501F_GetInkPointDataTimeInfo;
    PPL501F_FreeInkPointDataTimeInfo m_pfn_PPL501F_FreeInkPointDataTimeInfo;
    PPL501F_SaveDrawingImage m_pfn_PPL501F_SaveDrawingImage;
    PPL501F_SetSaveClipImageMargin m_pfn_PPL501F_SetSaveClipImageMargin;
    PPL501F_GetDeviceInfo m_pfn_PPL501F_GetDeviceInfo;
    PPL501F_AboutBox m_pfn_PPL501F_AboutBox;
    PPL501F_Base64Encode m_pfn_PPL501F_Base64Encode;
    PPL501F_Base64EncodeFree m_pfn_PPL501F_Base64EncodeFree;
    PPL501F_Base64Decode m_pfn_PPL501F_Base64Decode;
    PPL501F_GetTotalDecodeInkPointsNumber m_pfn_PPL501F_GetTotalDecodeInkPointsNumber;
    PPL501F_GetDecodeInkPointData m_pfn_PPL501F_GetDecodeInkPointData;
    PPL501F_SetPenColor m_pfn_PPL501F_SetPenColor;
    PPL501F_SetDisplayedFPImageAt m_pfn_PPL501F_SetDisplayedFPImageAt;
    PPL501F_GetFPImageBase64Data m_pfn_PPL501F_GetFPImageBase64Data;
    PPL501F_FreeFPImageBase64Data m_pfn_PPL501F_FreeFPImageBase64Data;

    // ==================================
    // LC700 APIs...
    // ==================================
    //
    PPLC700_InitialDevice m_pfn_PPLC700_InitialDevice;
    PPLC700_UnInitialDevice m_pfn_PPLC700_UnInitialDevice;
    PPLC700_Clear m_pfn_PPLC700_Clear;
    PPLC700_GetHWPadID m_pfn_PPLC700_GetHWPadID;
    PPLC700_GetHWVersion m_pfn_PPLC700_GetHWVersion;
    PPLC700_SetPenStyle m_pfn_PPLC700_SetPenStyle;
    PPLC700_SetPenWidth m_pfn_PPLC700_SetPenWidth;
    PPLC700_SignPadEventCallback m_pfn_PPLC700_SignPadEventCallback;
    PPLC700_GetTotalInkPointsNumber m_pfn_PPLC700_GetTotalInkPointsNumber;
    PPLC700_GetInkPointData m_pfn_PPLC700_GetInkPointData;
    PPLC700_GetInkPointDataTimeInfo m_pfn_PPLC700_GetInkPointDataTimeInfo;
    PPLC700_FreeInkPointDataTimeInfo m_pfn_PPLC700_FreeInkPointDataTimeInfo;
    PPLC700_SaveDrawingImage m_pfn_PPLC700_SaveDrawingImage;
    PPLC700_SetSaveClipImageMargin m_pfn_PPLC700_SetSaveClipImageMargin;
    PPLC700_GetDeviceInfo m_pfn_PPLC700_GetDeviceInfo;
    PPLC700_AboutBox m_pfn_PPLC700_AboutBox;
    PPLC700_Base64Encode m_pfn_PPLC700_Base64Encode;
    PPLC700_Base64EncodeFree m_pfn_PPLC700_Base64EncodeFree;
    PPLC700_Base64Decode m_pfn_PPLC700_Base64Decode;
    PPLC700_GetTotalDecodeInkPointsNumber m_pfn_PPLC700_GetTotalDecodeInkPointsNumber;
    PPLC700_GetDecodeInkPointData m_pfn_PPLC700_GetDecodeInkPointData;
    PPLC700_SetPenColor m_pfn_PPLC700_SetPenColor;

    // ==================================
    // E640 APIs...
    // ==================================
    //
    PPE640_InitialDevice m_pfn_PPE640_InitialDevice;
    PPE640_UnInitialDevice m_pfn_PPE640_UnInitialDevice;
    PPE640_Clear m_pfn_PPE640_Clear;
    PPE640_GetHWPadID m_pfn_PPE640_GetHWPadID;
    PPE640_GetHWVersion m_pfn_PPE640_GetHWVersion;
    PPE640_SetPenStyle m_pfn_PPE640_SetPenStyle;
    PPE640_SetPenWidth m_pfn_PPE640_SetPenWidth;
    PPE640_SignPadEventCallback m_pfn_PPE640_SignPadEventCallback;
    PPE640_GetTotalInkPointsNumber m_pfn_PPE640_GetTotalInkPointsNumber;
    PPE640_GetInkPointData m_pfn_PPE640_GetInkPointData;
    PPE640_GetInkPointDataTimeInfo m_pfn_PPE640_GetInkPointDataTimeInfo;
    PPE640_FreeInkPointDataTimeInfo m_pfn_PPE640_FreeInkPointDataTimeInfo;
    PPE640_SaveDrawingImage m_pfn_PPE640_SaveDrawingImage;
    PPE640_SetSaveClipImageMargin m_pfn_PPE640_SetSaveClipImageMargin;
    PPE640_GetDeviceInfo m_pfn_PPE640_GetDeviceInfo;
    PPE640_AboutBox m_pfn_PPE640_AboutBox;
    PPE640_Base64Encode m_pfn_PPE640_Base64Encode;
    PPE640_Base64EncodeFree m_pfn_PPE640_Base64EncodeFree;
    PPE640_Base64Decode m_pfn_PPE640_Base64Decode;
    PPE640_GetTotalDecodeInkPointsNumber m_pfn_PPE640_GetTotalDecodeInkPointsNumber;
    PPE640_GetDecodeInkPointData m_pfn_PPE640_GetDecodeInkPointData;
    PPE640_SetPenColor m_pfn_PPE640_SetPenColor;

    bool m_bShowHWVersion;
    int m_nSelectedDeviceID;

protected:
    void closeEvent(QCloseEvent *event);

};

#endif // MAINWINDOW_H
