/* global jQuery */
/*eslint-disable*/

'use strict';

// API Url
var websocket = null;
var wsUrl = 'ws://localhost:7089';
var domainNameUrl = null;

// 本地端測試
var apiUrl = wsUrl + '/PPLD1000WebSignSDK/';

var loc = window.location.pathname;
domainNameUrl = loc.substring(1, loc.lastIndexOf('/'));
domainNameUrl = domainNameUrl.replaceAll("%20", " ");

/*
// 伺服器端測試
if (location.protocol != 'wss:') {
  apiUrl = wsUrl + '/PPLD1000WebSignSDK/';
//  domainNameUrl = 'ws://domainName/';
}
else {
  apiUrl = 'wss://localhost:7091/PPLD1000WebSignSDK/';
//  domainNameUrl = 'wss://domainName/';
}
*/

var consoleCmdUrl = apiUrl + 'Console_Command?jd=';
var consoleGetCmdResultUrl = apiUrl + 'Console_GetCommandResult';

// ws Command ID definition...
const CMDID_ERR_URL_PATH              = -1;
const CMDID_OUT_OF_COMMAND_RANGE      = -2;
const CMDID_INITIAL                   = 1;
const CMDID_GET_VERSION               = 2;
const CMDID_GET_SIGNPAD_ID            = 3;
const CMDID_UNINITIAL                 = 4;
const CMDID_SIGN_COMPLETED            = 5;
const CMDID_SERVICE_REVIEWS_COMPLETED = 6;
const CMDID_UPDATE_SIGN_CANVAS_INFO   = 7;
const CMDID_PUSH_WEBPAGE_TO_SIGNPAD   = 8;
const CMDID_ENABLE_SIGNPAD_MOUSE      = 9;
const CMDID_CLEAR_SIGN_CANVAS_DATA    = 10;
const CMDID_GET_SIGN_IMAGE_BASE64_DATA = 11;
const CMDID_GET_MULTI_SIGN_IMAGE_BASE64_DATA = 12;
const CMDID_MULTI_SIGN_COMPLETED = 13;

// pen width level
const PEN_WIDTH_LEVEL_1 = 1;
const PEN_WIDTH_LEVEL_2 = 2;
const PEN_WIDTH_LEVEL_3 = 3;
const PEN_WIDTH_LEVEL_4 = 4;
const PEN_WIDTH_LEVEL_5 = 5;
const PEN_WIDTH_LEVEL_6 = 6;
const PEN_WIDTH_LEVEL_7 = 7;
const PEN_WIDTH_LEVEL_8 = 8;
const PEN_WIDTH_LEVEL_9 = 9;
const PEN_WIDTH_LEVEL_10 = 10;

// pen style...
const PEN_STYLE_WITH_PRESSURE = 1;
const PEN_STYLE_FIX = 2;

// type of push webpage to signpad...
const PUSH_WEBPAGE_TYPE_AD = 1;
const PUSH_WEBPAGE_TYPE_SIGN = 2;
const PUSH_WEBPAGE_TYPE_MULTI_SIGN = 3;
const PUSH_WEBPAGE_TYPE_SERVICE_REVIEWS = 4;

// global variables definition...
var CurrentPushMode = -1;
var lastSignImageBase64Data = null;
var lastSignImageBase64Data2 = null;
var lastSignImageBase64Data3 = null;
var lastSignSVGImageBase64Data = null;
var lastSignSVGImageBase64Data2 = null;
var lastSignSVGImageBase64Data3 = null;
var lastFPFeatureBase64Data = null;
var lastFPFeatureBase64Data2 = null;
var lastFPFeatureBase64Data3 = null;
var lastPDFBase64Data = null;
var LastSignMode = -1;

var contractWindowProxy = null;
var multiSignContractWindowProxy = null;

var g_nPlaybackSignStrokeCount = 0;
var g_nTotalPlaybackSignStrokeCount = 0;
var g_playbackSignDlgModalSizeClassName = '';
var bInitWebSocket = false;

String.prototype.replaceAll = function(search, replacement) {
  var target = this;
  return target.replace(new RegExp(search, 'g'), replacement);
};

function isEmpty(str) {
    return (!str || 0 === str.length);
}

// initialize device
function Initial() {
  bInitWebSocket = true;
  initWebSocket();
}

// initialize Web Socket
function initWebSocket() {
  try {
      if ( websocket && websocket.readyState == 1 )
          websocket.close();

      websocket = new WebSocket( wsUrl );
      websocket.onopen = function (evt) {
          // CONNECTED...
          bInitWebSocket = false;

          initDevice();
      };
      websocket.onclose = function (evt) {
          // DISCONNECTED...
          if(bInitWebSocket) {
              bInitWebSocket = false;
              alert('please run WebSignDriver first !');
          }
      };
      websocket.onmessage = function (evt) {
          // message coming from local server...
          var dataInfos = JSON.parse(evt.data);
          processCmdResult(dataInfos);

	   if(pollingConsoleGetCommandResult) {
		ConsoleGetCommandResult();
	   }
      };       
      websocket.onerror = function (evt) {
          // ERROR : value at evt.data !
//            alert('initWebSocket() error: ' + evt.data);
      };
  }
  catch (exception) {
      // exception error !
      bInitWebSocket = false;
      alert('initWebSocket() exception error: ' + exception);
  }
}

// initialize device
function initDevice() {

  document.getElementById("displayType").innerHTML = '初始化签字板设备...';

  // initial device...
  var jsParamm =
  {
    "Command": CMDID_INITIAL,
    "Data": null
  };
  var strCmdJsonData = JSON.stringify(jsParamm);

  // send urlInitDevice to initial device...
  var urlInitDevice = consoleCmdUrl + strCmdJsonData;
  websocket.send(urlInitDevice);
 
  pollingConsoleGetCommandResult = true;
}

var pollingConsoleGetCommandResult = false;
function ConsoleGetCommandResult() {
  ///////////////////////
  (function poll() {
      var timeId = setTimeout(function() {
          clearTimeout(timeId);
          if(pollingConsoleGetCommandResult)
          {
            // send consoleGetCmdResultUrl...
            websocket.send(consoleGetCmdResultUrl);
          }
      }, 50);
  }());
}

function processCmdResult(wsResponse) {
  var Command = wsResponse.Command;
  var Result = wsResponse.Result;

  if(Command == CMDID_OUT_OF_COMMAND_RANGE) {
  	alert('Out Of Command Range !');
  }
  else if(Command == CMDID_ERR_URL_PATH) {
  	alert('Invalid URL Path !');
  }
  else if(Command == CMDID_INITIAL) {
  	if(Result == 'Success') {
          pollingConsoleGetCommandResult = false;
          document.getElementById("displayType").innerHTML = '签字板设备已连接上。';
          document.getElementById("ShowContractBtn").disabled = false;
          document.getElementById("MultiSignBtn").disabled = false;
          document.getElementById("ShowADBtn").disabled = false;
          document.getElementById("HWIDBtn").disabled = false;
          document.getElementById("ScoreBtn").disabled = false;
          document.getElementById("GetVersionBtn").disabled = false;
          PushADWebPageToSignPad();
       } else if(Result == 'Failed') {
          pollingConsoleGetCommandResult = false;
          alert('SignPad Device Not Found !');
       } 
  }
  else if(Command == CMDID_GET_VERSION) {
  	if(Result == 'Success') {
          pollingConsoleGetCommandResult = false;
          var Version = wsResponse.Data;
          alert('PPwsWebSignDriver Version : ' + Version);
       } else if(Result == 'Failed') {
          pollingConsoleGetCommandResult = false;
          alert('Failed to get version !');
       } 
  }
  else if(Command == CMDID_GET_SIGNPAD_ID) {
  	if(Result == 'Success') {
          pollingConsoleGetCommandResult = false;          
          var SignPadID = wsResponse.Data;
          document.getElementById("HWID").innerHTML = SignPadID;
       }
  }
  else if(Command == CMDID_PUSH_WEBPAGE_TO_SIGNPAD) {
  	var nPushWebPageType = parseInt(wsResponse.Data);
	if(nPushWebPageType == PUSH_WEBPAGE_TYPE_AD) {
      	   if(Result == 'Success') {
             pollingConsoleGetCommandResult = false;
             document.getElementById("displayType").innerHTML = '推屏广告页面成功。';
          }
          else if(Result == 'Failed') {
         	pollingConsoleGetCommandResult = false;
             alert('Failed to push AD webpage !');
         }             
	}
	else if(nPushWebPageType == PUSH_WEBPAGE_TYPE_SIGN) {
          if(Result == 'Success') {
             document.getElementById("displayType").innerHTML = '推屏空白合同页面成功。';
          }
          else if(Result == 'ExitWebPageDueToSignPadError') {
             pollingConsoleGetCommandResult = false;                
             document.getElementById("displayType").innerHTML = 'SignPad已被拔除! 请插上后，按F5或离开网页重新执行。';
          }
          else if(Result == 'ExitWebPage') {
             pollingConsoleGetCommandResult = false;
             document.getElementById("ReviewContractBtn").disabled = false;
             document.getElementById("ContractSelect").disabled = false;
             document.getElementById("PlaybackSignBtn").disabled = false;
             document.getElementById("PlaybackSignSelect").disabled = false;

             // get (current web page saved as) pdf base64 data from wsResponse.Data2...                
             // get sign image base64 data from wsResponse.Data3...
             // get sign SVG image base64 data from wsResponse.Data4...
             // get FP Feature base64 data from wsResponse.Data5...
             lastPDFBase64Data = wsResponse.Data2;
             lastSignImageBase64Data = wsResponse.Data3;
             lastSignSVGImageBase64Data = wsResponse.Data4;
             lastFPFeatureBase64Data = wsResponse.Data5;

             PushADWebPageToSignPad();                
          }
          else if(Result == 'Failed') {
             pollingConsoleGetCommandResult = false;
             alert('Failed to push Contract webpage !');
          }
	}
	else if(nPushWebPageType == PUSH_WEBPAGE_TYPE_MULTI_SIGN) {
          if(Result == 'Success') {
             document.getElementById("displayType").innerHTML = '推屏单页多签页面成功。';
          }
          else if(Result == 'ExitWebPageDueToSignPadError') {
             pollingConsoleGetCommandResult = false;                
             document.getElementById("displayType").innerHTML = 'SignPad已被拔除! 请插上后，按F5或离开网页重新执行。';
          }
          else if(Result == 'ExitWebPage') {
             pollingConsoleGetCommandResult = false;
             document.getElementById("ReviewContractBtn").disabled = false;
             document.getElementById("ContractSelect").disabled = false;
             document.getElementById("PlaybackSignBtn").disabled = false;
             document.getElementById("PlaybackSignSelect").disabled = false;

             // get (current web page saved as) pdf base64 data from wsResponse.Data2...                
             // get multi sign image base64 data 1 from wsResponse.Data3...
             // get multi sign image base64 data 2 from wsResponse.Data4...
             // get multi sign image base64 data 3 from wsResponse.Data5...
             // get multi sign SVG image base64 data 1 from wsResponse.Data6...
             // get multi sign SVG image base64 data 2 from wsResponse.Data7...
             // get multi sign SVG image base64 data 3 from wsResponse.Data8...
             // get multi sign FP Feature base64 data 1 from wsResponse.Data9...
             // get multi sign FP Feature base64 data 2 from wsResponse.Data10...
             // get multi sign FP Feature base64 data 3 from wsResponse.Data11...
             lastPDFBase64Data = wsResponse.Data2;
             lastSignImageBase64Data = wsResponse.Data3;
             lastSignImageBase64Data2 = wsResponse.Data4;
             lastSignImageBase64Data3 = wsResponse.Data5;
             lastSignSVGImageBase64Data = wsResponse.Data6;
             lastSignSVGImageBase64Data2 = wsResponse.Data7;
             lastSignSVGImageBase64Data3 = wsResponse.Data8;
             lastFPFeatureBase64Data = wsResponse.Data9;
             lastFPFeatureBase64Data2 = wsResponse.Data10;
             lastFPFeatureBase64Data3 = wsResponse.Data11;

             PushADWebPageToSignPad();                
          }
          else if(Result == 'Failed') {
             pollingConsoleGetCommandResult = false;
             alert('Failed to push Multiple Sign webpage !');
          }             
	}
	else if(nPushWebPageType == PUSH_WEBPAGE_TYPE_SERVICE_REVIEWS) {
          if(Result == 'Success') {
             document.getElementById("displayType").innerHTML = '推屏服务评价页面成功。';
          }
          else if(Result == 'ExitWebPageDueToSignPadError') {
             pollingConsoleGetCommandResult = false;                
             document.getElementById("displayType").innerHTML = 'SignPad已被拔除! 请插上后，按F5或离开网页重新执行。';
          }
          else if(Result == 'ExitWebPage') {
             pollingConsoleGetCommandResult = false;
             document.getElementById("SCOREID").innerHTML = wsResponse.Data2 + ' 星';
             PushADWebPageToSignPad();                
          }
          else if(Result == 'Failed') {
             pollingConsoleGetCommandResult = false;
             alert('Failed to push Service Reviews webpage !');
          }             
	}
  }
  else if(Command == CMDID_UNINITIAL) {
  }
}

// uninitialize device
function uninitDevice() {
  pollingConsoleGetCommandResult = false;

  // uninitial device...
  var jsParamm =
  {
    "Command": CMDID_UNINITIAL,
    "Data": null
  };
  var strCmdJsonData = JSON.stringify(jsParamm);

  // send urlUninitDevice...
  var urlUninitDevice = consoleCmdUrl + strCmdJsonData;
  websocket.send(urlUninitDevice);
}

window.onbeforeunload = function (e) {
    uninitDevice();
    var milliseconds = 500;
    var start = new Date().getTime();

    while (true) {
        if (new Date().getTime() - start > milliseconds) {
            break;
        }
    }

    if(contractWindowProxy) {
      contractWindowProxy.close()
      contractWindowProxy = null
    }
  
    if(multiSignContractWindowProxy) {
      multiSignContractWindowProxy.close()
      multiSignContractWindowProxy = null
    }  
}

function PushContractWebPageToSignPad() {
  if(CurrentPushMode===0) {
    return;
  }

  CurrentPushMode = 0;
  LastSignMode = 1;

  document.getElementById("displayType").innerHTML = '正在推屏空白合同页面...';

  // push contract webpage to signpad...
  var jsParamm =
  {
    "Command": CMDID_PUSH_WEBPAGE_TO_SIGNPAD,
    "Data": 
    {
      "type": PUSH_WEBPAGE_TYPE_SIGN,
      "url": encodeURIComponent(domainNameUrl + '/pushed.html'),
    }
  };
  var strCmdJsonData = JSON.stringify(jsParamm);

  // send urlPushContractWebPageToSignPad...
  var urlPushContractWebPageToSignPad = consoleCmdUrl + strCmdJsonData;
  websocket.send(urlPushContractWebPageToSignPad);

  pollingConsoleGetCommandResult = true;
}

function PushADWebPageToSignPad() {
  if(CurrentPushMode === 1) {
    CurrentPushMode = 2;
  }
  else {
    CurrentPushMode = 1;
  }

  document.getElementById("displayType").innerHTML = '正在推屏广告页面...';

  // push ad webpage to signpad...
  var jsParamm =
  {
    "Command": CMDID_PUSH_WEBPAGE_TO_SIGNPAD,
    "Data": 
    {
      "type": PUSH_WEBPAGE_TYPE_AD,
      "url": encodeURIComponent(domainNameUrl + '/AD' + CurrentPushMode + '.html'),
    }
  };
  var strCmdJsonData = JSON.stringify(jsParamm);

  // send urlPushADWebPageToSignPad...
  var urlPushADWebPageToSignPad = consoleCmdUrl + strCmdJsonData;
  websocket.send(urlPushADWebPageToSignPad);

  pollingConsoleGetCommandResult = true;
}

function GetVersion() {
  // get version...
  var jsParamm =
  {
    "Command": CMDID_GET_VERSION,
    "Data": null
  };
  var strCmdJsonData = JSON.stringify(jsParamm);

  // send urlGetVersion...
  var urlGetVersion = consoleCmdUrl + strCmdJsonData;
  websocket.send(urlGetVersion);

  pollingConsoleGetCommandResult = true;
}

function GetHWID() {
  // get signpad id...
  var jsParamm =
  {
    "Command": CMDID_GET_SIGNPAD_ID,
    "Data": null
  };
  var strCmdJsonData = JSON.stringify(jsParamm);

  // send urlGetHWID...
  var urlGetHWID = consoleCmdUrl + strCmdJsonData;
  websocket.send(urlGetHWID);

  pollingConsoleGetCommandResult = true;
}

function PushServiceReviewsWebPageToSignPad() {
  if(CurrentPushMode===3) {
    return;
  }
  CurrentPushMode = 3;
  document.getElementById("SCOREID").innerHTML = '';
  document.getElementById("displayType").innerHTML = '正在推屏服务评价页面...';

  // push service reviews webpage to signpad...
  var jsParamm =
  {
    "Command": CMDID_PUSH_WEBPAGE_TO_SIGNPAD,
    "Data": 
    {
      "type": PUSH_WEBPAGE_TYPE_SERVICE_REVIEWS,
      "url": encodeURIComponent(domainNameUrl + '/Score.html'),
    }
  };
  var strCmdJsonData = JSON.stringify(jsParamm);

  // send urlPushServiceReviewsWebPageToSignPad...
  var urlPushServiceReviewsWebPageToSignPad = consoleCmdUrl + strCmdJsonData;
  websocket.send(urlPushServiceReviewsWebPageToSignPad);

  pollingConsoleGetCommandResult = true;
}

function CheckContract() {
  var psVal = $('#ContractSelect').val();

  if(LastSignMode === 1)
  {
    if(psVal === '0') {
      if(isEmpty(lastPDFBase64Data) === true) {
        document.getElementById("displayType").innerHTML = 'No PDF Base64 Data !';
      } else {
        downloadPDFBase64File(lastPDFBase64Data, "signed.pdf");
      }
    }
    else if(psVal === '1') {
      OpenNewContractWebPage();
    }
    else {
      alert('Error !');
    } 
  }
  else if(LastSignMode === 2)
  {
    if(psVal === '0') {
      if(isEmpty(lastPDFBase64Data) === true) {
        document.getElementById("displayType").innerHTML = 'No PDF Base64 Data !';
      } else {
        downloadPDFBase64File(lastPDFBase64Data, "signed.pdf");
      }
    }
    else if(psVal === '1') {
      OpenNewMultiSignContractWebPage();
    }
    else {
      alert('Error !');
    } 
  }
}

function PushMultiSignWebPageToSignPad() {
  if(CurrentPushMode===4) {
    return;
  }
  CurrentPushMode = 4;
  LastSignMode = 2;

  document.getElementById("displayType").innerHTML = '正在推屏单页多签页面...';
  
  // push multiple sign webpage to signpad...
  var jsParamm =
  {
    "Command": CMDID_PUSH_WEBPAGE_TO_SIGNPAD,
    "Data": 
    {
      "type": PUSH_WEBPAGE_TYPE_MULTI_SIGN,
      "url": encodeURIComponent(domainNameUrl + '/MultiSignPage.html'),
    }
  };
  var strCmdJsonData = JSON.stringify(jsParamm);

  // send urlPushMultiSignWebPageToSignPad...
  var urlPushMultiSignWebPageToSignPad = consoleCmdUrl + strCmdJsonData;
  websocket.send(urlPushMultiSignWebPageToSignPad);

  pollingConsoleGetCommandResult = true;
}

function downloadPDFBase64File(contentBase64, fileName) {
  const linkSource = `data:application/pdf;base64,${contentBase64}`;
  const downloadLink = document.createElement('a');
  document.body.appendChild(downloadLink);

  downloadLink.href = linkSource;
  downloadLink.target = '_self';
  downloadLink.download = fileName;
  downloadLink.click(); 
}

function OpenNewContractWebPage() {
  if(contractWindowProxy) {
    contractWindowProxy.close()
		contractWindowProxy = null
  }

	contractWindowProxy = window.open('contract.html', "_blank");

  if(contractWindowProxy) { 
    PostSignImageDataToContractWebPage();
  }
}

function OpenNewMultiSignContractWebPage() {
  if(multiSignContractWindowProxy) {
    multiSignContractWindowProxy.close()
		multiSignContractWindowProxy = null
  }

	multiSignContractWindowProxy = window.open('multisign_contract.html', "_blank");

  if(multiSignContractWindowProxy) {
    PostSignImageDataToMultiSignContractWebPage();
  }
}

function PostSignImageDataToContractWebPage() {
  var timeId = setTimeout(function() {
    clearTimeout(timeId);
    contractWindowProxy.postMessage(lastSignImageBase64Data, '*');
  }, 200);
}

function PostSignImageDataToMultiSignContractWebPage() {
  var timeId = setTimeout(function() {
    clearTimeout(timeId);
    
    var msgData = null;

    if(lastSignImageBase64Data) {
      msgData = '<1>' + lastSignImageBase64Data;
      multiSignContractWindowProxy.postMessage(msgData, "*"); 
    }

    if(lastSignImageBase64Data2) {
      msgData = '<2>' + lastSignImageBase64Data2;
      multiSignContractWindowProxy.postMessage(msgData, "*");
    }

    if(lastSignImageBase64Data3) {
      msgData = '<3>' + lastSignImageBase64Data3;
      multiSignContractWindowProxy.postMessage(msgData, "*");
    }
  }, 200);
}

function PlaybackSignature() {
  var playbackSignSelectedVal = $('#PlaybackSignSelect').val();
  if(playbackSignSelectedVal === '0') {
    if(isEmpty(lastSignSVGImageBase64Data) === true) {
      document.getElementById("displayType").innerHTML = 'No Sign SVG Image Base64 Data !';
    } else {
      PlaybackSignSVGData(lastSignSVGImageBase64Data);
    }
  }
  else if(playbackSignSelectedVal === '1') {
    if(isEmpty(lastSignSVGImageBase64Data2) === true) {
      document.getElementById("displayType").innerHTML = 'No Sign SVG Image Base64 Data !';
    } else {
      PlaybackSignSVGData(lastSignSVGImageBase64Data2);
    }
  }
  else if(playbackSignSelectedVal === '2') {
    if(isEmpty(lastSignSVGImageBase64Data3) === true) {
      document.getElementById("displayType").innerHTML = 'No Sign SVG Image Base64 Data !';
    } else {
      PlaybackSignSVGData(lastSignSVGImageBase64Data3);
    }
  }
}

function PlaybackSignSVGData(base64Data) {
  DecodeSignSVGSample(base64Data);  
  $('#playbackSVGImageModal').modal('show');
  $('#playbackSVGImageModal').on('hidden.bs.modal', function (e) {
    // call closePlaybackSVGImageModal()...
    closePlaybackSVGImageModal();
  })

  g_nPlaybackSignStrokeCount = 0;
  ClearSVGInfo();
  StartPlaybackSignature();
}

function DecodeSignSVGSample(base64Data) {
    // decode base64Data as SVG XML Data...
    var signSVGXMLSample = atob(base64Data);

    // insert signSVGXMLSample into document hidden 'div' element...
    var div = document.createElement('div');
    div.id = 'SignSVGXMLSample';
    div.innerHTML = signSVGXMLSample;
    div.style = 'display: none;';
    var modal_svgXMLDataSource = document.getElementById("svgXMLDataSource");
    modal_svgXMLDataSource.appendChild(div);

    // get total polyline count from 'SignSVGXMLSample' element...
    var polylineList = document.querySelectorAll("#SignSVGXMLSample polyline");
    g_nTotalPlaybackSignStrokeCount = polylineList.length;

    // clone element from 'SignSVGXMLSample svg' into 'svg_demo'...
    var svgTagInSignSVGXMLSample = document.querySelector("#SignSVGXMLSample svg");
    var modal_svgXMLDataTarget = document.getElementById("svgXMLDataTarget");
    modal_svgXMLDataTarget.appendChild(svgTagInSignSVGXMLSample.cloneNode(true));
  
    // set 'svgXMLDataTarget svg' element id...
    var targetSVGTag = document.querySelector("#svgXMLDataTarget svg");
    targetSVGTag.setAttribute('id', 'svg_box');

  $('#playbackSignDlg').toggleClass(g_playbackSignDlgModalSizeClassName);
}

function ClearSVGInfo() {
  var polylineList = document.querySelectorAll("#svg_box polyline");
  if(polylineList) {
    for (var i = 0; i < polylineList.length; i++) {
      var currentPolyline = polylineList[i];
      currentPolyline.setAttribute('points', '');
    }
  }

  var circleList = document.querySelectorAll("#svg_box circle");
  if(circleList) {
    for (var i = 0; i < circleList.length; i++) {
      var currentCircle = circleList[i];
      currentCircle.setAttribute('r', '');
    }
  }
}

function StartPlaybackSignature() {
  (function keepPlaybackSignStroke() {
      var timeId = setTimeout(function() {
          clearTimeout(timeId);

          if(g_nPlaybackSignStrokeCount < g_nTotalPlaybackSignStrokeCount)
          {
            var signSVGXMLSamplePolylineList = document.querySelectorAll("#SignSVGXMLSample polyline");
            var polylineList = document.querySelectorAll("#svg_box polyline");

            if(signSVGXMLSamplePolylineList && polylineList) {
              // set current sign stroke polyline info into svg-box...
              var currentSignSVGXMLSamplePolyline = signSVGXMLSamplePolylineList[g_nPlaybackSignStrokeCount];
              var points = currentSignSVGXMLSamplePolyline.getAttribute('points');

              var currentPolyline = polylineList[g_nPlaybackSignStrokeCount];
              currentPolyline.setAttribute('points', points);

              g_nPlaybackSignStrokeCount++;
              keepPlaybackSignStroke();
            }
          }
      }, 10);
  }());
}

function closePlaybackSVGImageModal() {
  if(g_nTotalPlaybackSignStrokeCount > 0) {
    g_nTotalPlaybackSignStrokeCount = 0;
    $('#playbackSignDlg').toggleClass(g_playbackSignDlgModalSizeClassName); 
  }

  // clear svgboxTag and signSVGXMLSampleTag...
  var svgboxTag = document.getElementById("svg_box");
  if(svgboxTag) {
    svgboxTag.remove();
  } 

  var signSVGXMLSampleTag = document.getElementById("SignSVGXMLSample");
  if(signSVGXMLSampleTag) {
    signSVGXMLSampleTag.remove();
  }
}

function playInPlaybackSVGImageModal() {
  g_nPlaybackSignStrokeCount = 99999;
  ClearSVGInfo();
  g_nPlaybackSignStrokeCount = 0;    
  StartPlaybackSignature();
}
