/* global jQuery */
/*eslint-disable*/

'use strict';

// API Url
var websocket = null;
var wsUrl = 'ws://localhost:7090';

// 本地端測試
var apiUrl = wsUrl + '/PPLD1000WebSignSDK/';
var signpadCmdUrl = apiUrl + 'SignPad_Command?jd=';
var signpadGetCmdResultUrl = apiUrl + 'SignPad_GetCommandResult';

// Http Command ID definition...
const CMDID_ERR_URL_PATH = -1;
const CMDID_OUT_OF_COMMAND_RANGE = -2;
const CMDID_INITIAL = 1;
const CMDID_GET_VERSION = 2;
const CMDID_GET_SIGNPAD_ID = 3;
const CMDID_UNINITIAL = 4;
const CMDID_SIGN_COMPLETED = 5;
const CMDID_SERVICE_REVIEWS_COMPLETED = 6;
const CMDID_UPDATE_SIGN_CANVAS_INFO = 7;
const CMDID_PUSH_WEBPAGE_TO_SIGNPAD = 8;
const CMDID_ENABLE_SIGNPAD_MOUSE = 9;
const CMDID_CLEAR_SIGN_CANVAS_DATA = 10;
const CMDID_GET_SIGN_IMAGE_BASE64_DATA = 11;
const CMDID_GET_MULTI_SIGN_IMAGE_BASE64_DATA = 12;
const CMDID_MULTI_SIGN_COMPLETED = 13;
const CMDID_GET_FINAL_SIGN_IMAGE_BASE64_DATA = 16;
const CMDID_GET_FINAL_MULTI_SIGN_IMAGE_BASE64_DATA = 17;

// pen width level
const PEN_WIDTH_LEVEL_1 = 1;
const PEN_WIDTH_LEVEL_2 = 2;
const PEN_WIDTH_LEVEL_3 = 3;
const PEN_WIDTH_LEVEL_4 = 4;
const PEN_WIDTH_LEVEL_5 = 5;
const PEN_WIDTH_LEVEL_6 = 6;
const PEN_WIDTH_LEVEL_7 = 7;
const PEN_WIDTH_LEVEL_8 = 8;
const PEN_WIDTH_LEVEL_9 = 9;
const PEN_WIDTH_LEVEL_10 = 10;

// pen style...
const PEN_STYLE_WITH_PRESSURE = 1;
const PEN_STYLE_FIX = 2;

// global variables definition...
var bInitWebSocket = false;
var canvas;
var context;
var isPolling = false;

// initialize device
function Initial() {
  bInitWebSocket = true;
  initWebSocket();
}

// initialize Web Socket
function initWebSocket() {
  try {
      if ( websocket && websocket.readyState == 1 )
          websocket.close();

      websocket = new WebSocket( wsUrl );
      websocket.onopen = function (evt) {
          // CONNECTED...
          bInitWebSocket = false;

          initDevice();
      };
      websocket.onclose = function (evt) {
          // DISCONNECTED...
          if(bInitWebSocket) {
              bInitWebSocket = false;
              alert('please run WebSignDriver first !');
          }
      };
      websocket.onmessage = function (evt) {
          // message coming from local server...
          var dataInfos = JSON.parse(evt.data);
          processCmdResult(dataInfos);

	   if(pollingSignPadGetCommandResult) {
		SignPadGetCommandResult();
	   }
      };       
      websocket.onerror = function (evt) {
          // ERROR : value at evt.data !
            alert('initWebSocket() error: ' + evt.data);
      };
  }
  catch (exception) {
      // exception error !
      bInitWebSocket = false;
      alert('initWebSocket() exception error: ' + exception);
  }
}

function initDevice() {
  EnableSignPadMouse('true');

  canvas = document.getElementById('ppCanvas');
  if(canvas.getContext) {
      context = canvas.getContext('2d');
  }

  ShowContract();
  isPolling = true;
  UpdateCanvasPosition();
  ClearInk();
}

var pollingSignPadGetCommandResult = false;
function SignPadGetCommandResult() {
  ///////////////////////
  (function poll() {
      var timeId = setTimeout(function() {
          clearTimeout(timeId);
          if(pollingSignPadGetCommandResult)
          {
		// send signpadGetCmdResultUrl...
		websocket.send(signpadGetCmdResultUrl);				
          }
      }, 50);
  }());
}

function processCmdResult(httpResponse) {
  var Command = httpResponse.Command;
  var Result = httpResponse.Result;

  if(Command == CMDID_UPDATE_SIGN_CANVAS_INFO) {
  	if(Result == 'Success') {
          pollingSignPadGetCommandResult = false;
       } else if(Result == 'Failed') {
          pollingSignPadGetCommandResult = false;
       } 
  }
  else if(Command == CMDID_GET_FINAL_SIGN_IMAGE_BASE64_DATA) {
       if(Result == 'Success') {
          var image = httpResponse.Data;
          drawImage(image);
          // get sign image base64 data...
          GetSignImageBase64Data();
       }
       else if(Result == 'Failed') {
          pollingSignPadGetCommandResult = false;
          SignCompleted('false', 'false');
       }
  }
  else if(Command == CMDID_GET_SIGN_IMAGE_BASE64_DATA) {
       if(Result == 'Success') {
          pollingSignPadGetCommandResult = false;

          // get (current web page saved as) pdf base64 data from httpResponse.Data...          
          // get sign image base64 data from httpResponse.Data2...
          // get sign SVG image base64 data from httpResponse.Data3...
          // get FP Feature base64 data from httpResponse.Data4...
          var pdfBase64Data = httpResponse.Data;
          var signImageBase64Data = httpResponse.Data2;
          var signSVGImageBase64Data = httpResponse.Data3;
          var fpFeatureBase64Data = httpResponse.Data4;

          SignCompleted('true', 'true');
       }
       else if(Result == 'Failed') {
          pollingSignPadGetCommandResult = false;
          SignCompleted('false', 'false');
       }
  }
}

function EnableSignPadMouse(strEnable) {
  // enable/disable mouse...
  var jsParam =
  {
    "Command": CMDID_ENABLE_SIGNPAD_MOUSE,
    "Data": strEnable
  };
  var strCmdJsonData = JSON.stringify(jsParam);

  // send urlEnableSignPadMouse...
  var urlEnableSignPadMouse = signpadCmdUrl + strCmdJsonData;
  websocket.send(urlEnableSignPadMouse);
 
  pollingSignPadGetCommandResult = true;
}

function ShowContract() {
  document.getElementById("SignBody").className = "SignBody show-class";
  window.scrollTo(0, 0);
  var scrolledCt = document.getElementById("scrolledCt");
  scrolledCt.scrollTop = 0;
}

function ScrollUp() {
  document.documentElement.scrollTop = document.documentElement.scrollTop - 120;
}

function ScrollDown() {
  document.documentElement.scrollTop = document.documentElement.scrollTop + 120;
}

function drawImage(base64) {
  var dataUrl = 'data:image/png;base64,';
  dataUrl = dataUrl + base64;
  canvas = document.getElementById('ppCanvas');
  var img = new Image();

  img.addEventListener('load', function() {
      context.drawImage(this, 0, 0, canvas.width, canvas.height);
  }, false);

  img.src = dataUrl;
}

function getPixelValue(styleString) {
  if(styleString) {
    var pxIndex = 0;
    pxIndex = styleString.indexOf('px');
    if(pxIndex!=-1) {
      return parseInt(styleString.substr(0,pxIndex));
    }
  }

  return 0;
}

function getPosition (element) {
  var rect = element.getBoundingClientRect();
  var x = rect.left;
  var y = rect.top;

  var style = element.currentStyle || window.getComputedStyle(element);

  var LeftOffset = 0;
  var TopOffset = 0;

  TopOffset += getPixelValue(style.paddingTop);
  LeftOffset += getPixelValue(style.paddingLeft);
  TopOffset += getPixelValue(style.getPropertyValue('border-top-width'));
  LeftOffset += getPixelValue(style.getPropertyValue('border-left-width'));

  return { x: x+LeftOffset, y: y+TopOffset };
}

function IsElementVisibleInViewPort(element) {
  var pos = getPosition(element);
  //var bcr = element.getBoundingClientRect();
  var realTop = (pos.y)*window.devicePixelRatio;
  var realleft = (pos.x)*window.devicePixelRatio;
  var realwidth = element.width*window.devicePixelRatio;
  var realheight = element.height*window.devicePixelRatio;

  var parentElementrealwidth = window.innerWidth*window.devicePixelRatio;
  var parentElementrealheight = window.innerHeight*window.devicePixelRatio;

  var relativeLeft = realleft;
  var relativeTop = realTop;

  var relativeRight = relativeLeft+realwidth;
  var relativeBottom = relativeTop+realheight;

  if(relativeLeft<0 || relativeTop<0) {
    return false;
  }

  if(relativeRight>parentElementrealwidth || relativeBottom>parentElementrealheight) {
    return false;
  }

  return true;
}

var PrerealTop = -2;
var Prerealleft = -2;
var Prerealwidth = -2;
var Prerealheight = -2;

function UpdateCanvasPosition() {

    (function poll() {
        var timeId = setTimeout(function() {
            clearTimeout(timeId);

            var element = document.getElementById('ppCanvas');
            var pos = getPosition(element);

            var realTop = (pos.y)*window.devicePixelRatio;
            var realleft = (pos.x)*window.devicePixelRatio;
            var realwidth = element.width*window.devicePixelRatio;
            var realheight = element.height*window.devicePixelRatio;

            var IsVisibleInViewPort = IsElementVisibleInViewPort(element);
            if(IsVisibleInViewPort===false)
            {
              realTop = -1;
              realleft = -1;
              realwidth = -1;
              realheight = -1;
            }

            console.log('Canvas information : Top:' + realTop.toFixed(0) + ', left:' + realleft.toFixed(0) + ',' + 'Width:' + realwidth.toFixed(0) + ', Height:' + realheight.toFixed(0));
            var RequestParameter = 'nLeft=' + realleft.toFixed(0) + '&nTop=' + realTop.toFixed(0) + '&nWidth=' + realwidth.toFixed(0) + '&nHeight=' + realheight.toFixed(0);

            if(isPolling)
            {
              if(realTop!=PrerealTop || realleft!=Prerealleft || realwidth!=Prerealwidth || realheight!=Prerealheight)
              {
                // update sign canvas info...
                var jsParam =
                {
                  "Command": CMDID_UPDATE_SIGN_CANVAS_INFO,
                  "Data":
                  {
                    "ID": 1,
                    "PenWidthLevel": PEN_WIDTH_LEVEL_3,
                    "PenStyle": PEN_STYLE_WITH_PRESSURE,
                    "LeftTopPosition": realleft.toFixed(0).toString() + ',' + realTop.toFixed(0).toString(),
                    "Width": realwidth.toFixed(0),
                    "Height": realheight.toFixed(0),
                  }
                };
                var strCmdJsonData = JSON.stringify(jsParam);

 		   // send urlUpdateSignCanvasInfo...
		   var urlUpdateSignCanvasInfo = signpadCmdUrl + strCmdJsonData;
		   websocket.send(urlUpdateSignCanvasInfo);

		   pollingSignPadGetCommandResult = true;
              }

              if(isPolling) {
                poll();
              } else {}
            }

            PrerealTop = realTop;
            Prerealleft = realleft;
            Prerealwidth = realwidth;
            Prerealheight = realheight;

        }, 100);
    }());
}

window.onbeforeunload = function(e) {
/*  
  Uninitial();

  var milliseconds = 10;
  var start = new Date().getTime();

  while(true) {
    if ((new Date().getTime() - start) > milliseconds)
    break;
  }
*/  
}

function Uninitial() {
    pollingSignPadGetCommandResult = false;

    // disable mouse...
    EnableSignPadMouse('false');
}

function ClearInk() {

  // clear sign canvas data...
  var jsParam =
  {
    "Command": CMDID_CLEAR_SIGN_CANVAS_DATA,
    "Data": null
  };
  var strCmdJsonData = JSON.stringify(jsParam);

  // send urlClearInk...
  var urlClearInk = signpadCmdUrl + strCmdJsonData;
  websocket.send(urlClearInk);

  pollingSignPadGetCommandResult = true;
  context.clearRect(0, 0, canvas.width, canvas.height);
}

function Resign() {
  ClearInk();
}

function SignDone() {
  isPolling = false;

  // disable mouse...
  EnableSignPadMouse('false');
  DisableButton();

  // get final sign image base64 data...
  GetFinalSignImageBase64Data();
}

function DisableButton() {
  document.getElementById("SignButtons").style.display = "none";
  document.getElementById("Content_Scroll_Buttons").style.display = "none";
}

function GetSignImageBase64Data() {
  // save sign canvas into localImageFilePath...
  var jsParam =
  {
    "Command": CMDID_GET_SIGN_IMAGE_BASE64_DATA,
    "EnableCurrentWebPageSavedAsPDFBase64Data": true,
    "CropImageHorizontalMargin": -1,
    "CropImageVerticalMargin": -1
  };
  var strCmdJsonData = JSON.stringify(jsParam);

  // send urlGetSignImageBase64Data...
  var urlGetSignImageBase64Data = signpadCmdUrl + strCmdJsonData;
  websocket.send(urlGetSignImageBase64Data);

  pollingSignPadGetCommandResult = true;
}

function SignCompleted(strReturnPDFBase64Data, strReturnSignImageBase64Data)
{
  // sign completed and back to console web page...
  var jsParam =
  {
    "Command": CMDID_SIGN_COMPLETED,
    "Data": strReturnPDFBase64Data,
    "Data2": strReturnSignImageBase64Data,
  };
  var strCmdJsonData = JSON.stringify(jsParam);

  // send urlSignCompleted...
  var urlSignCompleted = signpadCmdUrl + strCmdJsonData;
  websocket.send(urlSignCompleted);

  pollingSignPadGetCommandResult = true;
}

function GetFinalSignImageBase64Data() {
  // get final sign image base64 data...
  var jsParam =
  {
    "Command": CMDID_GET_FINAL_SIGN_IMAGE_BASE64_DATA,
    "Data": null
  };
  var strCmdJsonData = JSON.stringify(jsParam);

  // send urlGetFinalSignImageBase64Data...
  var urlGetFinalSignImageBase64Data = signpadCmdUrl + strCmdJsonData;
  websocket.send(urlGetFinalSignImageBase64Data);

  pollingSignPadGetCommandResult = true;
}
