/* global jQuery */
/*eslint-disable*/

'use strict';

// API Url
var websocket = null;
var wsUrl = 'ws://localhost:7060';

// Http Command ID definition...
const CMDID_ERR_URL_PATH = -1;
const CMDID_OUT_OF_COMMAND_RANGE = -2;
const CMDID_INITIAL = 1;
const CMDID_GET_VERSION = 2;
const CMDID_GET_SIGNPAD_ID = 3;
const CMDID_UNINITIAL = 4;
const CMDID_SIGN_COMPLETED = 5;
const CMDID_SERVICE_REVIEWS_COMPLETED = 6;
const CMDID_UPDATE_SIGN_CANVAS_INFO = 7;
const CMDID_PUSH_WEBPAGE_TO_SIGNPAD = 8;
const CMDID_ENABLE_SIGNPAD_MOUSE = 9;
const CMDID_CLEAR_SIGN_CANVAS_DATA = 10;
const CMDID_GET_SIGN_IMAGE_BASE64_DATA = 11;
const CMDID_GET_MULTI_SIGN_IMAGE_BASE64_DATA = 12;
const CMDID_MULTI_SIGN_COMPLETED = 13;
const CMDID_GET_FINAL_SIGN_IMAGE_BASE64_DATA = 16;
const CMDID_GET_FINAL_MULTI_SIGN_IMAGE_BASE64_DATA = 17;
const CMDID_CLOSE_PUSH_WEBPAGE_TYPE_SIGN = 18;
const CMDID_CLOSE_PUSH_WEBPAGE_TYPE_MULTI_SIGN = 19;

// pen width level
const PEN_WIDTH_LEVEL_1 = 1;
const PEN_WIDTH_LEVEL_2 = 2;
const PEN_WIDTH_LEVEL_3 = 3;
const PEN_WIDTH_LEVEL_4 = 4;
const PEN_WIDTH_LEVEL_5 = 5;
const PEN_WIDTH_LEVEL_6 = 6;
const PEN_WIDTH_LEVEL_7 = 7;
const PEN_WIDTH_LEVEL_8 = 8;
const PEN_WIDTH_LEVEL_9 = 9;
const PEN_WIDTH_LEVEL_10 = 10;

// pen style...
const PEN_STYLE_WITH_PRESSURE = 1;
const PEN_STYLE_FIX = 2;

// global variables definition...
var bInitWebSocket = false;
var canvas = null;
var context = null;
var isPolling = false;

var CurrentSignIndex = 0;
var lastSignImageBase64Data1 = null;
var lastSignImageBase64Data2 = null;
var lastSignImageBase64Data3 = null;
var lastFPFeatureBase64Data1 = null;
var lastFPFeatureBase64Data2 = null;
var lastFPFeatureBase64Data3 = null;
var bForceBackToMainPage = false;

// initialize device
function Initial() {
  bInitWebSocket = true;
  initWebSocket();
}

// initialize Web Socket
function initWebSocket() {
  try {
      if ( websocket && websocket.readyState == 1 )
          websocket.close();

      websocket = new WebSocket( wsUrl );
      websocket.onopen = function (evt) {
          // CONNECTED...
          bInitWebSocket = false;
          initDevice();
      };
      websocket.onclose = function (evt) {
          // DISCONNECTED...
          if(bInitWebSocket) {
              bInitWebSocket = false;
              const platform = navigator.platform.toLowerCase();
              if (platform.includes('win')) {
                alert('please run PPWSWebSignDriver.exe first !');
              } else if (platform.includes('linux')) {
                alert('please run WebSignDriver first !');
              }
          }
      };
      websocket.onmessage = function (evt) {
          // message coming from local server...
          var dataInfos = JSON.parse(evt.data);
          processCmdResult(dataInfos);
      };       
      websocket.onerror = function (evt) {
          // ERROR : value at evt.data !
            alert('initWebSocket() error: ' + evt.data);
      };
  }
  catch (exception) {
      // exception error !
      bInitWebSocket = false;
      alert('initWebSocket() exception error: ' + exception);
  }
}

function initDevice() {
  EnableSignPadMouse('true');
};

function processCmdResult(httpResponse) {
  var Command = httpResponse.Command;
  var Result = httpResponse.Result;

  if(Command == CMDID_ENABLE_SIGNPAD_MOUSE) {
  	if(Result == 'Success') {
       } else if(Result == 'Failed') {
       } 
  }
  else if(Command == CMDID_UPDATE_SIGN_CANVAS_INFO) {
  	if(Result == 'Success') {
       } else if(Result == 'Failed') {
       } 
  }
  else if(Command == CMDID_CLEAR_SIGN_CANVAS_DATA) {
  	if(Result == 'Success') {
       } else if(Result == 'Failed') {
       } 
  }
  else if(Command == CMDID_GET_MULTI_SIGN_IMAGE_BASE64_DATA) {
       if(Result == 'Success' || Result == 'Failed') {
          // get sign image base64 data from httpResponse.Data...
          // get sign SVG image base64 data from httpResponse.Data2...          
          // get FP Feature base64 data from httpResponse.Data3...
          var signImageBase64Data = httpResponse.Data;
          var signSVGImageBase64Data = httpResponse.Data2;
          var fpFeatureBase64Data = httpResponse.Data3;

          displaySignImage(signImageBase64Data, fpFeatureBase64Data);
       }
  }
  else if(Command == CMDID_MULTI_SIGN_COMPLETED) {
  	if(Result == 'Success') {
       } else if(Result == 'Failed') {
       } 
  }
  else if(Command == CMDID_CLOSE_PUSH_WEBPAGE_TYPE_MULTI_SIGN) {
    if (CurrentSignIndex > 0) {
      bForceBackToMainPage = false;
    } else {
      if (bForceBackToMainPage) {
      } else {
        bForceBackToMainPage = true;
        BackToMainPage();
      }
    }
  }
}

String.prototype.replaceAll = function(search, replacement) {
  var target = this;
  return target.replace(new RegExp(search, 'g'), replacement);
};

$(function() {
  var ClearAndReSign=function() {
    // clear sign image...
    ClearInk();
  }

  var SignConfirmAndDone=function() {
    isPolling = false;
    canvas = null;
    context = null;
 
    // get sign image base64 data...
    GetSignImageBase64Data();

    $("canvas").remove();
    $(this).dialog("close");
  }

  $("#MultiSignDialog").dialog({    
    modal: true,
    autoOpen: false,
    width : 1000,
    resizable: false,
    draggable: false,
    title: "Signature",
    buttons: {
      "Clear": ClearAndReSign,
      "OK": SignConfirmAndDone
    }
  });

  $(".ui-dialog-titlebar-close").click( function() { 

    isPolling = false;
    canvas = null;
    context = null;
    PrerealTop = -2;
    Prerealleft = -2;
    Prerealwidth = -2;
    Prerealheight = -2;

    // clear sign image...
    ClearInk();
    
    CurrentSignIndex = 0;
    $("canvas").remove();

    // Disable sign canvas area...
    DisableSignCanvasArea();
   
    $(this).dialog("close");
    //alert("Click 'X' BUTTON !");
    });  
});

function User1Sign() {
  canvas = document.createElement("canvas");
  canvas.setAttribute("id", "ppCanvas");
  canvas.width = 960;
  canvas.height = 450
  $("#MultiSignDialog").append(canvas);
  
  context = canvas.getContext("2d");
  
  // fill a rectangle...
  context.fillStyle = "white";
  context.fillRect(0, 0, canvas.width, canvas.height);

  isPolling = true;
  UpdateSignCanvasPosition();
  
  CurrentSignIndex = 1;
  $("#MultiSignDialog").dialog("open"); 
}

function User1SignBase64Image() {
  var signBase64ImageArea = null;
  signBase64ImageArea = $('#User1SignBase64ImageArea'); 
  signBase64ImageArea.val(lastSignImageBase64Data1);
}

function User2Sign() {
  canvas = document.createElement("canvas");
  canvas.setAttribute("id", "ppCanvas");
  canvas.width = 960;
  canvas.height = 450
  $("#MultiSignDialog").append(canvas);
  
  context = canvas.getContext("2d");
  
  // fill a rectangle...
  context.fillStyle = "white";
  context.fillRect(0, 0, canvas.width, canvas.height);

  isPolling = true;  
  UpdateSignCanvasPosition();

  CurrentSignIndex = 2;
  $("#MultiSignDialog").dialog("open"); 
}

function User2SignBase64Image() {
  var signBase64ImageArea = null;
  signBase64ImageArea = $('#User2SignBase64ImageArea'); 
  signBase64ImageArea.val(lastSignImageBase64Data2);
}

function User3Sign() {
  canvas = document.createElement("canvas");
  canvas.setAttribute("id", "ppCanvas");
  canvas.width = 960;
  canvas.height = 450
  $("#MultiSignDialog").append(canvas);
  
  context = canvas.getContext("2d");
  
  // fill a rectangle...
  context.fillStyle = "white";
  context.fillRect(0, 0, canvas.width, canvas.height);

  isPolling = true;  
  UpdateSignCanvasPosition();

  CurrentSignIndex = 3;
  $("#MultiSignDialog").dialog("open"); 
}

function User3SignBase64Image() {
  var signBase64ImageArea = null;
  signBase64ImageArea = $('#User3SignBase64ImageArea'); 
  signBase64ImageArea.val(lastSignImageBase64Data3);
}

function EnableSignPadMouse(strEnable) {
  // enable/disable mouse...
  var jsParam =
  {
    "Command": CMDID_ENABLE_SIGNPAD_MOUSE,
    "Data": strEnable
  };
  var strCmdJsonData = JSON.stringify(jsParam);

  // send urlEnableSignPadMouse...
  var urlEnableSignPadMouse = strCmdJsonData;
  websocket.send(urlEnableSignPadMouse);
};

window.onbeforeunload = function(e) {
/*  
  Uninitial();

  var milliseconds = 10;
  var start = new Date().getTime();

  while(true) {
    if ((new Date().getTime() - start) > milliseconds)
    break;
  }
*/  
};

function Uninitial() {
    // disable mouse...
    EnableSignPadMouse('false');    
//    DisableSignCanvasArea();
//    ClearInk();
};

function ScrollUp() {
  document.documentElement.scrollTop = document.documentElement.scrollTop - 120;
};

function ScrollDown() {
  document.documentElement.scrollTop = document.documentElement.scrollTop + 120;
};

function drawImage(base64) {
  var dataUrl = 'data:image/png;base64,';
  dataUrl = dataUrl + base64;
  canvas = document.getElementById('ppCanvas');

  if(canvas != null)
  {
    var img = new Image();

    img.addEventListener('load', function() {
        context.drawImage(this, 0, 0, canvas.width, canvas.height);
    }, false);

    img.src = dataUrl;
  }
}

function getPixelValue(styleString) {
  if(styleString) {
    var pxIndex = 0;
    pxIndex = styleString.indexOf('px');
    if(pxIndex!=-1) {
      return parseInt(styleString.substr(0,pxIndex));
    }
  }

  return 0;
};

function getPosition (element) {
  var rect = element.getBoundingClientRect();
  var x = rect.left;
  var y = rect.top;

  var style = element.currentStyle || window.getComputedStyle(element);

  var LeftOffset = 0;
  var TopOffset = 0;

  TopOffset += getPixelValue(style.paddingTop);
  LeftOffset += getPixelValue(style.paddingLeft);
  TopOffset += getPixelValue(style.getPropertyValue('border-top-width'));
  LeftOffset += getPixelValue(style.getPropertyValue('border-left-width'));

  return { x: x+LeftOffset, y: y+TopOffset };
};

function IsElementVisibleInViewPort(element) {
  var pos = getPosition(element);
  //var bcr = element.getBoundingClientRect();
  var realTop = (pos.y)*window.devicePixelRatio;
  var realleft = (pos.x)*window.devicePixelRatio;
  var realwidth = element.width*window.devicePixelRatio;
  var realheight = element.height*window.devicePixelRatio;
  var parentElementrealwidth = window.innerWidth*window.devicePixelRatio;
  var parentElementrealheight = window.innerHeight*window.devicePixelRatio;

  var relativeLeft = realleft;
  var relativeTop = realTop;

  var relativeRight = relativeLeft+realwidth;
  var relativeBottom = relativeTop+realheight;

  if(relativeLeft<0 || relativeTop<0) {
    return false;
  }

  if(relativeRight>parentElementrealwidth || relativeBottom>parentElementrealheight) {
    return false;
  }

  return true;
};

var PrerealTop = -2;
var Prerealleft = -2;
var Prerealwidth = -2;
var Prerealheight = -2;

function UpdateSignCanvasPosition() {

    (function poll() {
        var timeId = setTimeout(function() {

            clearTimeout(timeId);            
            var element = document.getElementById('ppCanvas');

            if(element === null)
            {
              realTop = PrerealTop;
              realleft = Prerealleft;
              realwidth = Prerealwidth;
              realheight = Prerealheight;
            }
            else
            {
              var pos = getPosition(element);
              var realTop = (pos.y)*window.devicePixelRatio;
              var realleft = (pos.x)*window.devicePixelRatio;
              var realwidth = element.width*window.devicePixelRatio;
              var realheight = element.height*window.devicePixelRatio;
  
              var IsVisibleInViewPort = IsElementVisibleInViewPort(element);
              if(IsVisibleInViewPort===false)
              {
                realTop = -1;
                realleft = -1;
                realwidth = -1;
                realheight = -1;
              }  
            }

            console.log('Canvas information : Top:' + realTop.toFixed(0) + ', left:' + realleft.toFixed(0) + ',' + 'Width:' + realwidth.toFixed(0) + ', Height:' + realheight.toFixed(0));
            var RequestParameter = 'nLeft=' + realleft.toFixed(0) + '&nTop=' + realTop.toFixed(0) + '&nWidth=' + realwidth.toFixed(0) + '&nHeight=' + realheight.toFixed(0);

            if(isPolling)
            {
              if(realTop!=PrerealTop || realleft!=Prerealleft || realwidth!=Prerealwidth || realheight!=Prerealheight)
              {
                // update sign canvas info...
                var jsParam =
                {
                  "Command": CMDID_UPDATE_SIGN_CANVAS_INFO,
                  "Data":
                  {
                    "ID": 1,
                    "PenWidthLevel": PEN_WIDTH_LEVEL_3,
                    "PenStyle": PEN_STYLE_WITH_PRESSURE,
                    "LeftTopPosition": realleft.toFixed(0).toString() + ',' + realTop.toFixed(0).toString(),
                    "Width": realwidth.toFixed(0),
                    "Height": realheight.toFixed(0),
                  }
                }
                var strCmdJsonData = JSON.stringify(jsParam);

 		   // send urlUpdateSignCanvasInfo...
		   var urlUpdateSignCanvasInfo = strCmdJsonData;
		   websocket.send(urlUpdateSignCanvasInfo);
              }

              if(isPolling) {
                poll();
              } else {}
            }

            PrerealTop = realTop;
            Prerealleft = realleft;
            Prerealwidth = realwidth;
            Prerealheight = realheight;

        }, 100);
    }());
};

function ClearInk() {
  // clear sign canvas data...
  var jsParam =
  {
    "Command": CMDID_CLEAR_SIGN_CANVAS_DATA,
    "Data": null
  };
  var strCmdJsonData = JSON.stringify(jsParam);

  // send urlClearInk...
  var urlClearInk = strCmdJsonData;
  websocket.send(urlClearInk);

  // fill a rectangle...
  context.fillStyle = "white";
  context.fillRect(0, 0, canvas.width, canvas.height);   
};

function ImageExist(filePath)
{
   var img = new Image();
   img.src = filePath;
   return img.height != 0;
}

function BackToMainPage() {
  isPolling = false;  
  EnableSignPadMouse('false');
  DisablePartialUIs();
  SignCompleted('true', 'true', 'true', 'true');
};

function DisablePartialUIs() {
  document.getElementById("User1SignBtn").style.display = "none";
  document.getElementById("User1Base64UIs").style.display = "none";
  document.getElementById("User1FPFeatureBase64UIs").style.display = "none";
  document.getElementById("User2SignBtn").style.display = "none";
  document.getElementById("User2Base64UIs").style.display = "none";
  document.getElementById("User2FPFeatureBase64UIs").style.display = "none";
  document.getElementById("User3SignBtn").style.display = "none";
  document.getElementById("User3Base64UIs").style.display = "none";
  document.getElementById("User3FPFeatureBase64UIs").style.display = "none";
  document.getElementById("BackToMainPageBtn").style.display = "none";
  document.getElementById("Content_Scroll_Buttons").style.display = "none";

  $("#User1SignBtn").remove();
  $("#User1Base64UIs").remove();
  $("#User1FPFeatureBase64UIs").remove();
  $("#User21SignBtn").remove();
  $("#User2Base64UIs").remove();
  $("#User2FPFeatureBase64UIs").remove();
  $("#User3SignBtn").remove();
  $("#User3Base64UIs").remove();
  $("#User3FPFeatureBase64UIs").remove();
}

function DisableSignCanvasArea() {
  // Disable sign canvas area...
  var jsParam =
  {
    "Command": CMDID_UPDATE_SIGN_CANVAS_INFO,
    "Data":
    {
      "ID": 1,
      "PenWidthLevel": PEN_WIDTH_LEVEL_3,
      "PenStyle": PEN_STYLE_WITH_PRESSURE,
      "LeftTopPosition": '-1,-1',
      "Width": -1,
      "Height": -1,
    }
  };
  var strCmdJsonData = JSON.stringify(jsParam);

  // send urlDisableSignCanvasArea...
  var urlDisableSignCanvasArea = strCmdJsonData;
  websocket.send(urlDisableSignCanvasArea);

  PrerealTop = -2;
  Prerealleft = -2;
  Prerealwidth = -2;
  Prerealheight = -2;
}

function SignCompleted(strReturnMultiSignImageBase64Data1, strReturnMultiSignImageBase64Data2, strReturnMultiSignImageBase64Data3, strReturnPDFBase64Data)
{
  // sign completed and back to console web page...
  var jsParam =
  {
    "Command": CMDID_MULTI_SIGN_COMPLETED,
    "EnableCurrentWebPageSavedAsPDFBase64Data": true,    
    "Data": strReturnPDFBase64Data,
    "Data2": strReturnMultiSignImageBase64Data1,
    "Data3": strReturnMultiSignImageBase64Data2,
    "Data4": strReturnMultiSignImageBase64Data3,
    };
  var strCmdJsonData = JSON.stringify(jsParam);

  // send urlSignCommpleted...
  var urlSignCommpleted = strCmdJsonData;
  websocket.send(urlSignCommpleted);
}

function GetSignImageBase64Data() {
  // save sign canvas into localImageFilePath...
  var jsParam =
  {
    "Command": CMDID_GET_MULTI_SIGN_IMAGE_BASE64_DATA,
    "ID": CurrentSignIndex,
    "CropImageHorizontalMargin": 5,
    "CropImageVerticalMargin": 5
  };
  var strCmdJsonData = JSON.stringify(jsParam);

  // send urlGetSignImageBase64Data...
  var urlGetSignImageBase64Data = strCmdJsonData;
  websocket.send(urlGetSignImageBase64Data);
}

function displaySignImage(signImageBase64Data, fpFeatureBase64Data) { 
  var signBase64ImageArea = null;
  var fpBase64FeatureArea = null;
  DisableSignCanvasArea();  

  var dataSignBase64Image = 'data:image/png;base64,' + signImageBase64Data;
  var userSignImage;

  if(CurrentSignIndex === 1)
  {
    lastSignImageBase64Data1 = signImageBase64Data;    
    signBase64ImageArea = $('#User1SignBase64ImageArea');
    userSignImage = document.getElementById("User1SignImg");
    lastFPFeatureBase64Data1 = fpFeatureBase64Data;
    fpBase64FeatureArea = $('#User1FPBase64FeatureArea');
  }
  else if(CurrentSignIndex === 2)
  {
    lastSignImageBase64Data2 = signImageBase64Data;
    signBase64ImageArea = $('#User2SignBase64ImageArea');
    userSignImage = document.getElementById("User2SignImg");
    lastFPFeatureBase64Data2 = fpFeatureBase64Data;
    fpBase64FeatureArea = $('#User2FPBase64FeatureArea');
  }
  else if(CurrentSignIndex === 3)
  {
    lastSignImageBase64Data3 = signImageBase64Data;
    signBase64ImageArea = $('#User3SignBase64ImageArea');
    userSignImage = document.getElementById("User3SignImg");
    lastFPFeatureBase64Data3 = fpFeatureBase64Data;
    fpBase64FeatureArea = $('#User3FPBase64FeatureArea');
  }

  CurrentSignIndex = 0;
  userSignImage.src = dataSignBase64Image;
  signBase64ImageArea.val(signImageBase64Data);
  fpBase64FeatureArea.val(fpFeatureBase64Data);
  ClearInk();
}

function User1FPBase64Feature() {
  var fpBase64FeatureArea = null;
  fpBase64FeatureArea = $('#User1FPBase64FeatureArea'); 
  fpBase64FeatureArea.val(lastFPFeatureBase64Data1);
}

function User2FPBase64Feature() {
  var fpBase64FeatureArea = null;
  fpBase64FeatureArea = $('#User2FPBase64FeatureArea'); 
  fpBase64FeatureArea.val(lastFPFeatureBase64Data2);
}

function User3FPBase64Feature() {
  var fpBase64FeatureArea = null;
  fpBase64FeatureArea = $('#User3FPBase64FeatureArea'); 
  fpBase64FeatureArea.val(lastFPFeatureBase64Data3);
}
