//
//  ViewController.swift
//  PPIDCardSDK_Example
//

import UIKit
import PPIDCardSDK

class ViewController: UIViewController, PPIDCardCaptureViewDelegate {
    
    @IBOutlet var segmentControl: UISegmentedControl!
    @IBOutlet var imageView: UIImageView!
    @IBOutlet var textView: UITextView!
    @IBOutlet var demoButton: UIButton!

    var sampleView: PPIDCardCaptureView? = nil
    var switchButton: UIButton? = nil
    var torchButton: UIButton? = nil
    var focusButton: UIButton? = nil
    var captureButton: UIButton? = nil
    var restartButton: UIButton? = nil
    var resultButton: UIButton? = nil

    var torchOn: Bool? = false
    var toFrontCamera: Bool? = false
    var borderLayer: CAShapeLayer? = nil;

    override func viewDidLoad() {
        
        self.segmentControl.isHidden = true
        self.imageView.isHidden = true
        self.textView.isHidden = true

        super.viewDidLoad()
    }

    
    // MARK: - delegate - 偵測狀態
    func captureViewDidDetect(with status: PPIDCardDetectStatus, cornerPoints: [NSValue]!) {
        DispatchQueue.main.async {
            // 顯示狀態
            print(String(format: "!! captureViewDidDetect !! %@ (%@)", String(reflecting:status), cornerPoints ?? ""))
                        
            if(cornerPoints != nil)
            {
                // 繪製框線
                self.borderLayer?.removeFromSuperlayer()

                let path = UIBezierPath()
                path.move(to: cornerPoints[0].cgPointValue)
                path.addLine(to: cornerPoints[1].cgPointValue)
                path.addLine(to: cornerPoints[2].cgPointValue)
                path.addLine(to: cornerPoints[3].cgPointValue)
                path.addLine(to: cornerPoints[0].cgPointValue)
                
                self.borderLayer = CAShapeLayer()
                self.borderLayer?.path = path.cgPath
                self.borderLayer?.strokeColor = UIColor.orange.cgColor
                self.borderLayer?.fillColor = UIColor.clear.cgColor
                self.borderLayer?.lineWidth = 3
                
                self.sampleView!.layer.addSublayer(self.borderLayer!)
            }
        }
    }
    
    // MARK: - delegate - 辨識結果
    func captureViewDidCapture(withJpgData jpgData: Data!) {
        
        print("!! captureViewDidCapture !!")
        
        self.borderLayer?.removeFromSuperlayer()
        self.imageView.image = UIImage(data: jpgData)
        self.imageView.isHidden = false
    }
    
    
    @IBAction func onClickCaptureView(_ sender: UIButton) {
        
        self.showCaptureView()
    }
    
    func showCaptureView() {
        self.segmentControl.isHidden = true
        self.imageView.isHidden = true
        self.textView.isHidden = true
        self.demoButton.isHidden = true
        
        // sample : use capture view
        let btnHeight : CGFloat = 100
        var testFrame : CGRect = self.view.frame
        
        testFrame.size.height -= btnHeight

        
        
        // MARK: - initialize範例
        let signature = "PENPOWER"
        self.sampleView = PPIDCardCaptureView(frame: testFrame, signature: signature)

        if self.sampleView != nil
        {
            // MARK: property - 指定代理
            self.sampleView?.delegate = self
            
            self.sampleView?.backgroundColor = UIColor.black
            self.view.addSubview(self.sampleView!)
        }
        else
        {
            // Failed reason will be dumped in termial
        }
                 
        // MARK: -
        
        // 測試用按鈕
        self.addButtons(btnHeight: btnHeight)
    }

    @objc dynamic func onClickSwitch() {
        
        self.toFrontCamera = !self.toFrontCamera!

        // MARK: method - 切換前後鏡頭
        self.sampleView?.switch(toFrontCamera: self.toFrontCamera!)
        self.torchOn = false
    }

    @objc dynamic func onClickTorch() {
        
        self.torchOn = !self.torchOn!

        // MARK: method - 手電筒開關
        self.sampleView?.torchTurn(on: self.torchOn!)
    }

    @objc dynamic func onClickFocus() {
        
        // MARK: method - 手動對焦
        self.sampleView?.focus(with: CGPoint(x: (self.sampleView?.frame.midX)!, y: (self.sampleView?.frame.midY)!))
    }

    @objc dynamic func onClickCapture() {
        
        // MARK: method - 手動拍照
        self.sampleView?.capture()
    }
    
    @objc dynamic func onClickRestart() {
        
        // MARK: method - 重啟
        self.sampleView?.restart()
    }
    
    @objc dynamic func onClickResult() {
        
        self.demoButton.isHidden = false
        
        self.sampleView!.delegate = nil;
        self.sampleView!.removeFromSuperview()
        self.sampleView = nil

        self.switchButton!.removeFromSuperview()
        self.switchButton = nil

        self.torchButton!.removeFromSuperview()
        self.torchButton = nil

        self.focusButton!.removeFromSuperview()
        self.focusButton = nil

        self.captureButton!.removeFromSuperview()
        self.captureButton = nil

        self.restartButton!.removeFromSuperview()
        self.restartButton = nil

        self.resultButton!.removeFromSuperview()
        self.resultButton = nil
    }
    
    func addButtons (btnHeight: CGFloat ) {
                
        let btnWidth : CGFloat = self.view.frame.size.width/6;
        let originY = self.view.frame.size.height - btnHeight

        self.switchButton = UIButton(frame: CGRect(x: 0, y: originY, width: btnWidth, height: btnHeight))
        self.switchButton?.setTitle("Switch", for: .normal)
        self.switchButton?.setTitleColor(.black, for: .normal)
        self.switchButton?.backgroundColor = UIColor.white
        self.switchButton?.addTarget(self, action: #selector(onClickSwitch), for: UIControlEvents.touchUpInside)
        self.view.addSubview(self.switchButton!)

        self.torchButton = UIButton(frame: CGRect(x: (self.switchButton?.frame.maxX)!, y: originY, width: btnWidth, height:btnHeight))
        self.torchButton?.setTitle("Torch", for: .normal)
        self.torchButton?.setTitleColor(.black, for: .normal)
        self.torchButton?.backgroundColor = UIColor.white
        self.torchButton?.addTarget(self, action: #selector(onClickTorch), for: UIControlEvents.touchUpInside)
        self.view.addSubview(self.torchButton!)

        self.focusButton = UIButton(frame: CGRect(x: (self.torchButton?.frame.maxX)!, y: originY, width: btnWidth, height: btnHeight))
        self.focusButton?.setTitle("Focus", for: .normal)
        self.focusButton?.setTitleColor(.black, for: .normal)
        self.focusButton?.backgroundColor = UIColor.white
        self.focusButton?.addTarget(self, action: #selector(onClickFocus), for: UIControlEvents.touchUpInside)
        self.view.addSubview(self.focusButton!)

        self.captureButton = UIButton(frame: CGRect(x: (self.focusButton?.frame.maxX)!, y: originY, width: btnWidth, height: btnHeight))
        self.captureButton?.setTitle("Capture", for: .normal)
        self.captureButton?.setTitleColor(.black, for: .normal)
        self.captureButton?.backgroundColor = UIColor.white
        self.captureButton?.addTarget(self, action: #selector(onClickCapture), for: UIControlEvents.touchUpInside)
        self.view.addSubview(self.captureButton!)

        self.restartButton = UIButton(frame: CGRect(x: (self.captureButton?.frame.maxX)!, y: originY, width: btnWidth, height: btnHeight))
        self.restartButton?.setTitle("Restart", for: .normal)
        self.restartButton?.setTitleColor(.black, for: .normal)
        self.restartButton?.backgroundColor = UIColor.white
        self.restartButton?.addTarget(self, action: #selector(onClickRestart), for: UIControlEvents.touchUpInside)
        self.view.addSubview(self.restartButton!)

        self.resultButton = UIButton(frame: CGRect(x: (self.restartButton?.frame.maxX)!, y: originY, width: btnWidth, height: btnHeight))
        self.resultButton?.setTitle("Result", for: .normal)
        self.resultButton?.setTitleColor(.black, for: .normal)
        self.resultButton?.backgroundColor = UIColor.white
        self.resultButton?.addTarget(self, action: #selector(onClickResult), for: UIControlEvents.touchUpInside)
        self.view.addSubview(self.resultButton!)
    }
}
