//
//  PPIDCardResultModel.h
//  PPIDCardSDK
//

#import <UIKit/UIKit.h>

@interface PPIDCardResultModel : NSObject

#pragma mark - Field properties

/// 父
@property (nonatomic, retain) NSString *father;

/// 母
@property (nonatomic, retain) NSString *mother;

/// 姓名
@property (nonatomic, retain) NSString *name;

/// 姓名拼音
@property (nonatomic, retain) NSString *namePinyin;

/// 性別
@property (nonatomic, retain) NSString *sex;

/// 生日
@property (nonatomic, retain) NSString *birthday;

/// 住址
@property (nonatomic, retain) NSString *address;

/// 配偶
@property (nonatomic, retain) NSString *partner;

/// 役別
@property (nonatomic, retain) NSString *military;

/// 出生地
@property (nonatomic, retain) NSString *birthPlace;

/// 統一編號
@property (nonatomic, retain) NSString *identityNumber;

/// 序號
@property (nonatomic, retain) NSString *serialNumber;

/// 發證日期
@property (nonatomic, retain) NSString *issueDate;

/// 大頭照
@property (nonatomic, retain) UIImage *idPhoto;



#pragma mark - Access properties

/// 證件影像
@property (nonatomic, retain) NSData *jpgData;

/// 辨識結果
/// @note 0：成功 \n
/// -200：影像模糊 \n
/// -201：影像影像反光 \n
/// -5：授權錯誤 \n
/// <0：無法辨識
@property (nonatomic, assign) int retCode;




#pragma mark - Instance methods

/// 合併結果欄位
/// @param mergeModel 要合併的辨識結果物件
- (void)mergeResultWithModel:(PPIDCardResultModel *)mergeModel;

@end
