//
//  PPDriverLicenseResultModel.h
//  PPIDCardSDK
//

#import <UIKit/UIKit.h>

@interface PPDriverLicenseResultModel : NSObject

/// 駕照號碼
@property (nonatomic, retain) NSString *licenseNumber;

/// 補照次數
@property (nonatomic, retain) NSString *reissueCount;

/// 姓名
@property (nonatomic, retain) NSString *name;

/// 性別
@property (nonatomic, retain) NSString *sex;

/// 生日
@property (nonatomic, retain) NSString *birthday;

/// 血型
@property (nonatomic, retain) NSString *bloodType;

/// 住址
@property (nonatomic, retain) NSString *address;

/// 有效日期
@property (nonatomic, retain) NSString *effectiveDate;

/// 管轄編號
@property (nonatomic, retain) NSString *jurisdictionNumber;

/// 持照條件
@property (nonatomic, retain) NSString *licenseCondition;

/// 駕照種類
@property (nonatomic, retain) NSString *licenseType;

/// 發照日期
@property (nonatomic, retain) NSString *issueDate;

/// 審驗日期
@property (nonatomic, retain) NSString *verificationDate;

/// 證件影像
@property (nonatomic, retain) NSData *jpgData;

/// 辨識結果
/// @note 0：成功 \n
/// -200：影像模糊 \n
/// -201：影像影像反光 \n
/// -5：授權錯誤 \n
/// <0：無法辨識
@property (nonatomic, assign) int retCode;

@end
