//
//  PPIDCardAppearanceModel.h
//  PPIDCardSDK
//
//  Created by Eddie Hu on 2020/10/26.
//  Copyright © 2020 Eddie Hu. All rights reserved.
//

#import <UIKit/UIKit.h>

////////////////////////////////////////////////////////////////////////////////////////////////////

static NSString * const PPIDCardTextID_IDCardFrontSide = @"PPIDCardTextID_IDCardFrontSide";
static NSString * const PPIDCardTextID_IDCardBackSide = @"PPIDCardTextID_IDCardBackSide";
static NSString * const PPIDCardTextID_CaptureGuide = @"PPIDCardTextID_CaptureGuide";
static NSString * const PPIDCardTextID_ModifyGuide = @"PPIDCardTextID_ModifyGuide";
static NSString * const PPIDCardTextID_RotateToLandscape = @"PPIDCardTextID_RotateToLandscape";
static NSString * const PPIDCardTextID_Cancel = @"PPIDCardTextID_Cancel";
static NSString * const PPIDCardTextID_Done = @"PPIDCardTextID_Done";
static NSString * const PPIDCardTextID_Capture = @"PPIDCardTextID_Capture";
static NSString * const PPIDCardTextID_AutoCapture = @"PPIDCardTextID_AutoCapture";
static NSString * const PPIDCardTextID_ReCapture = @"PPIDCardTextID_ReCapture";
static NSString * const PPIDCardTextID_BackSideCapture = @"PPIDCardTextID_BackSideCapture";
static NSString * const PPIDCardTextID_SwitchToManual = @"PPIDCardTextID_SwitchToManual";
static NSString * const PPIDCardTextID_SwitchToAuto = @"PPIDCardTextID_SwitchToAuto";
static NSString * const PPIDCardTextID_TurnToFrontSide = @"PPIDCardTextID_TurnToFrontSide";
static NSString * const PPIDCardTextID_TurnToBackSide = @"PPIDCardTextID_TurnToBackSide";
static NSString * const PPIDCardTextID_ReadyToCapture = @"PPIDCardTextID_ReadyToCapture";
static NSString * const PPIDCardTextID_PressCaptureButton = @"PPIDCardTextID_PressCaptureButton";
static NSString * const PPIDCardTextID_FailedToConnectCamera = @"PPIDCardTextID_FailedToConnectCamera";
static NSString * const PPIDCardTextID_FailedToCapture = @"PPIDCardTextID_FailedToCapture";
static NSString * const PPIDCardTextID_FailedToDetectEdge = @"PPIDCardTextID_FailedToDetectEdge";
static NSString * const PPIDCardTextID_NotInValidArea = @"PPIDCardTextID_NotInValidArea";
static NSString * const PPIDCardTextID_ImageTooSmall = @"PPIDCardTextID_ImageTooSmall";
static NSString * const PPIDCardTextID_FailedToAdjustImage = @"PPIDCardTextID_FailedToAdjustImage";
static NSString * const PPIDCardTextID_ImageBlur = @"PPIDCardTextID_ImageBlur";
static NSString * const PPIDCardTextID_ImageReflection = @"PPIDCardTextID_ImageReflection";
static NSString * const PPIDCardTextID_NoLicense = @"PPIDCardTextID_NoLicense";
static NSString * const PPIDCardTextID_FailedToRecognize = @"PPIDCardTextID_FailedToRecognize";
static NSString * const PPIDCardTextID_FailedToDetectFace = @"PPIDCardTextID_FailedToDetectFace";
static NSString * const PPIDCardTextID_NoKeyField = @"PPIDCardTextID_NoKeyField";
static NSString * const PPIDCardTextID_UnsupportType = @"PPIDCardTextID_UnsupportType";


////////////////////////////////////////////////////////////////////////////////////////////////////



@interface PPIDCardAppearanceModel : NSObject

/// 所有文字內容
@property (nonatomic, retain) NSMutableDictionary *textDict;

/// 背景顏色
@property (nonatomic, retain) UIColor *BGColor;



/// 文字按鈕一般顏色
@property (nonatomic, retain) UIColor *textButtonNormalColor;

/// 文字按鈕按下顏色
@property (nonatomic, retain) UIColor *textButtonHighlightColor;

/// 上下說明文字顏色
@property (nonatomic, retain) UIColor *infoTextColor;



/// 中央狀態文字顏色
@property (nonatomic, retain) UIColor *statusTextColor;

/// 中央狀態背景顏色
@property (nonatomic, retain) UIColor *statusBGColor;

/// 偵測四邊線段顏色
@property (nonatomic, retain) UIColor *detectedBorderColor;

/// 調整四角錨點顏色
@property (nonatomic, retain) UIColor *modifyAnchorColor;

/// 無效區域遮罩顏色
@property (nonatomic, retain) UIColor *invalidAreaMaskColor;



/// 限制landscape方向拍照影像
@property (nonatomic, retain) UIImage *horzCaptureAlertImage;

/// 拍照按鈕一般影像
@property (nonatomic, retain) UIImage *captureButtonNormalImage;

/// 拍照按鈕按下影像
@property (nonatomic, retain) UIImage *captureButtonHighlightImage;

/// 取消按鈕一般影像
@property (nonatomic, retain) UIImage *cancelButtonNormalImage;

/// 取消按鈕按下影像
@property (nonatomic, retain) UIImage *cancelButtonHighlightImage;



/// 設定顯示文字
/// @param value 顯示文字
/// @param textID 字串ID
/// @note 字串ID : 預設內容 \n
///  PPIDCardTextID_IDCardFrontSide : 身分證 正面 \n
///  PPIDCardTextID_IDCardBackSide : 身分證 反面 \n
///  PPIDCardTextID_CaptureGuide : 請平面滿版拍攝，並避免模糊、反光 \n
///  PPIDCardTextID_ModifyGuide : 請確認圓點對準證件四角，可拖曳圓點裁切 \n
///  PPIDCardTextID_RotateToLandscape : 請將手機轉至橫向拍照 \n
///  PPIDCardTextID_Cancel : 取消 \n
///  PPIDCardTextID_Done : 完成 \n
///  PPIDCardTextID_Capture : 拍照 \n
///  PPIDCardTextID_AutoCapture : 自動拍 \n
///  PPIDCardTextID_ReCapture : 重拍 \n
///  PPIDCardTextID_BackSideCapture : 拍反面 \n
///  PPIDCardTextID_SwitchToManual : 切換手動拍 \n
///  PPIDCardTextID_SwitchToAuto : 切換自動拍 \n
///  PPIDCardTextID_TurnToFrontSide : 請翻到正面 \n
///  PPIDCardTextID_TurnToBackSide : 請翻到反面 \n
///  PPIDCardTextID_ReadyToCapture : 準備拍照 \n
///  PPIDCardTextID_PressCaptureButton : 請按下拍照按鈕 \n
///  PPIDCardTextID_FailedToConnectCamera : 無法連接相機 \n
///  PPIDCardTextID_FailedToCapture : 拍照失敗 \n
///  PPIDCardTextID_FailedToDetectEdge : 偵測不到四邊 \n
///  PPIDCardTextID_NotInValidArea : 不在有效範圍內 \n
///  PPIDCardTextID_ImageTooSmall : 影像太小 \n
///  PPIDCardTextID_FailedToAdjustImage : 影像校正失敗 \n
///  PPIDCardTextID_ImageBlur : 影像模糊 \n
///  PPIDCardTextID_ImageReflection : 影像反光 \n
///  PPIDCardTextID_FailedToRecognize : 辨識失敗 \n
- (void)setValue:(NSString *)value withTextID:(NSString *)textID;

/// 預設顯示樣式
+ (PPIDCardAppearanceModel *)defaultAppearanceModel;

@end
