//
//  PPIDCardResultModel.h
//  PPIDCardSDK
//

#import <UIKit/UIKit.h>

@interface PPIDCardResultModel : NSObject

@property (nonatomic, assign) NSInteger retCode;

#pragma mark - Field properties

/// 父
@property (nonatomic, retain) NSString *father;

/// 母
@property (nonatomic, retain) NSString *mother;

/// 姓名
@property (nonatomic, retain) NSString *name;

/// 性別
@property (nonatomic, retain) NSString *sex;

/// 生日
@property (nonatomic, retain) NSString *birthday;

/// 住址
@property (nonatomic, retain) NSString *address;

/// 配偶
@property (nonatomic, retain) NSString *partner;

/// 役別
@property (nonatomic, retain) NSString *military;

/// 出生地
@property (nonatomic, retain) NSString *birthPlace;

/// 統一編號
@property (nonatomic, retain) NSString *identityNumber;

/// 序號
@property (nonatomic, retain) NSString *serialNumber;

/// 發證日期
@property (nonatomic, retain) NSString *issueDate;



#pragma mark - Instance methods

/// 合併結果欄位
/// @param mergeModel 要合併的辨識結果物件
- (void)mergeResultWithModel:(PPIDCardResultModel *)mergeModel;

@end
