//
//  IDCardSDKExample.swift
//
//
//  ----------------------------------
//  !! BEFORE USING PPIDCardSDK !!
//  ----------------------------------
//  1. Add "PPIDCardSDK.xcframework" in xcodeproj
//
//  2. Add PPIDCardSDK-Bridging-Header path in xcodeproj
//     -> Build Settings
//        -> Swift Compiler - Code Generation
//           -> ObjectiveC Bridging Header
//


import Foundation

class IDCardSDKExample
{
    let sdk = IDCardSDK();
    var imagePath = "";
    
    func presentCaptureInterface(_ viewController: UIViewController)
    {

    }
    
    func recognize() -> String
    {
        var result = ""
        let signature = "20170309czvv2204sm4798g03q4q1rkyonxahxty0451d558v01b6pr355efp9x76y0m0e974832"
        
        let path = Bundle.main.path(forResource: "ocrImg", ofType: "jpg")
        let resultModel = self.sdk.recognizeImage(withPath: path, signature: signature)
        
        let path_b = Bundle.main.path(forResource: "ocrImg_b", ofType: "jpg")
        let resultModel_b = self.sdk.recognizeImage(withPath: path_b, signature: signature)
        
        resultModel?.mergeResult(with: resultModel_b)
        
        
        if(resultModel!.retCode < 0)
        {
            // recognition failed
            result = String(format:"failed with code : %d", resultModel!.retCode);
        }
        else
        {
            if((resultModel!.name) != nil)
            {
                result = result.appending(String(format:"\n姓名: %@", resultModel!.name))
            }
            
            if((resultModel!.birthday) != nil)
            {
                result = result.appending(String(format:"\n出生年月日: %@", resultModel!.birthday))
            }
            
            if((resultModel!.sex) != nil)
            {
                result = result.appending(String(format:"\n性別: %@", resultModel!.sex))
            }
            
            if((resultModel!.issueDate) != nil)
            {
                result = result.appending(String(format:"\n發證日期: %@", resultModel!.issueDate))
            }
            
            if((resultModel!.identityNumber) != nil)
            {
                result = result.appending(String(format:"\n身分證號: %@", resultModel!.identityNumber))
            }
            
            if((resultModel!.father) != nil)
            {
                result = result.appending(String(format:"\n父: %@", resultModel!.father))
            }
            
            if((resultModel!.mother) != nil)
            {
                result = result.appending(String(format:"\n母: %@", resultModel!.mother))
            }
            
            if((resultModel!.partner) != nil)
            {
                result = result.appending(String(format:"\n配偶: %@", resultModel!.partner))
            }
            
            if((resultModel!.military) != nil)
            {
                result = result.appending(String(format:"\n役別: %@", resultModel!.military))
            }
            
            if((resultModel!.birthPlace) != nil)
            {
                result = result.appending(String(format:"\n出生地: %@", resultModel!.birthPlace))
            }
                    
            if((resultModel!.address) != nil)
            {
                result = result.appending(String(format:"\n住址: %@", resultModel!.address))
            }
                    
            if((resultModel!.serialNumber) != nil)
            {
                result = result.appending(String(format:"\n背面序號: %@", resultModel!.serialNumber))
            }
        }
        
        result = resultModel!.description
        
        return result
    }
}
