//
//  IDCardSDKExample.swift
//
//
//  ----------------------------------
//  !! BEFORE USING IDCardSDK !!
//  ----------------------------------
//  1. Add "libstdc++.tbd", "CoreMedia.framework", "CoreMotion.framework", "AVFoundation.framework" in xcodeproj
//     -> Build Phases
//        ->Link Binary with Libraries
//
//  2. Add IDCardSDK-Bridging-Header path in xcodeproj
//     -> Build Settings
//        -> Swift Compiler - Code Generation
//           -> ObjectiveC Bridging Header
//
//  3. Add "-ObjC" in xcodeproj
//     -> Build Settings
//        -> Linking
//           -> Other Linker Flags
//
//
//

//#define DarkBlueColor       [UIColor colorWithHexString:@"#2c538f"]

import Foundation

class IDCardSDKExample
{
    let sdk = IDCardSDK();
    var imagePath = "";
    
    func presentCaptureInterface(_ viewController: UIViewController)
    {
        self.sdk.presentCaptureInterface(from: viewController,
                                         targetLineColor: UIColor.orange,
                                         toolbarBGColor: UIColor.lightGray,
                                         
                                         didCaptureImage: {imagePath in
                                            self.imagePath = imagePath!
                                            self.sdk.dismissCaptureInterface()},
                                         
                                         didClickCancel: {
                                            self.sdk.dismissCaptureInterface()})
    }
    
    func recognize() -> String
    {
        var result = ""
        let signature = "20170309czvv2204sm4798g03q4q1rkyonxahxty0451d558v01b6pr355efp9x76y0m0e974832"
        var resultData: NSData?
        let retCode = self.sdk.recognizeImage(withPath: self.imagePath, signature: signature, resultData: &resultData)
        
        
        if(retCode < 0)
        {
            // recognition failed
            result = String(format:"failed with code : %d", retCode);
        }
        else
        {
            // recognition success
            let byteCount = resultData!.length
            var recogResult = [Int16](repeating:0, count: byteCount)
            
            resultData?.getBytes(&recogResult, range: NSMakeRange(0, byteCount))
            
            var i=0
            
            while i<byteCount {
                
                // 0代表結束
                if(recogResult[i] == 0)
                {
                    break;
                }
                
                let mType = recogResult[i]
                i+=1
                
                let len = Int(recogResult[i])
                i+=1
                
                //////////////////////////////////////////////////
                
                var title = ""
                
                switch(mType)
                {
                case Int16(ID_IDCARD_NAME):
                    title = "姓名: "
                    
                case Int16(ID_IDCARD_BIRTHDAY):
                    title = "出生年月日: "
                    
                case Int16(ID_IDCARD_SEX):
                    title = "性別: "
                    
                case Int16(ID_IDCARD_ISSUEDATE):
                    title = "發證日期: "
                    
                case Int16(ID_IDCARD_IDNO):
                    title = "統一編號: "
                    
                case Int16(ID_IDCARD_FATHER):
                    title = "父: "
                    
                case Int16(ID_IDCARD_MOTHER):
                    title = "母: "
                    
                case Int16(ID_IDCARD_PARTNER):
                    title = "配偶: "
                    
                case Int16(ID_IDCARD_MILITARY):
                    title = "役別: "
                    
                case Int16(ID_IDCARD_BIRTHPLACE):
                    title = "出生地: "
                    
                case Int16(ID_IDCARD_ADDRESS):
                    title = "住址: "
                    
                case Int16(ID_IDCARD_SN):
                    title = "背面序號: "
                    
                default:
                    title = String(format:"未定義欄位(%d): ", mType)
                }
                
                //////////////////////////////////////////////////
                
                var content = ""
                
                for _ in 0..<len
                {
                    
                    content = String(format:"%@%C", content, recogResult[i]);
                    i+=1;
                }
                
                result = String(format:"%@%@%@\n", result, title, content);
            }
        }
        
        return result
    }
}
