//
//  IDCardSDK.h
//  IDCardSDK
//

#import <UIKit/UIKit.h>

#define ID_IDCARD_FATHER				6001
#define ID_IDCARD_MOTHER				6002
#define ID_IDCARD_NAME					5051
#define ID_IDCARD_SEX					6004
#define ID_IDCARD_BIRTHDAY				6005
#define ID_IDCARD_ADDRESS				5054
#define ID_IDCARD_PARTNER				6007
#define ID_IDCARD_MILITARY				6008
#define ID_IDCARD_BIRTHPLACE			6009
#define ID_IDCARD_IDNO					6010
#define ID_IDCARD_ISSUEDATE				6011
#define ID_IDCARD_SN					6012

@interface IDCardSDK : NSObject

/**
 * Present capture interface
 *
 * @param viewController UIViewController where capture interface present from.
 * @param targetLineColor UIColor of taret corner line.
 * @param toolbarBGColor UIColor of toolbar background.
 * @param didCaptureImage Block method called after cpaturing image.
 * @param didClickCancel Block method called after clicking cancel button.
 */
- (void)presentCaptureInterfaceFromViewController:(UIViewController *)viewController
                                  targetLineColor:(UIColor *)targetLineColor
                                   toolbarBGColor:(UIColor *)toolbarBGColor
                                  didCaptureImage:(void (^)(NSString *))didCaptureImage
                                   didClickCancel:(void (^)(void))didClickCancel;


/**
 * Dismiss capture interface
 */
- (void)dismissCaptureInterface;


/**
 * Recognize image
 *
 * @param imagePath Recognition target file path
 * @param signature Signature
 * @param resultData Recognition result data
 * @return Recognition result code
 */
- (NSInteger)recognizeImageWithPath:(NSString *)imagePath signature:(NSString *)signature resultData:(NSData **)resultData;


@end
