//
//  ViewController.m
//  Example
//
//  ----------------------------------
//  !! BEFORE USING IDCardSDK !!
//  ----------------------------------
//  1. Add "libstdc++.tbd", "CoreMedia.framework", "CoreMotion.framework", "AVFoundation.framework" in xcodeproj
//     -> Build Phases
//        ->Link Binary with Libraries
//
//  2. Add IDCardSDK-Bridging-Header path in xcodeproj
//     -> Build Settings
//        -> Swift Compiler - Code Generation
//           -> ObjectiveC Bridging Header
//
//  3. Add "-ObjC" in xcodeproj
//     -> Build Settings
//        -> Linking
//           -> Other Linker Flags
//


#import "ViewController.h"
#import "IDCardSDK.h"

@interface ViewController ()
@property (nonatomic, strong) IDCardSDK *sdk;
@property (nonatomic, strong) NSString *imagePath;
@end

@implementation ViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view, typically from a nib.
    
    self.sdk = [[IDCardSDK alloc] init];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}


- (IBAction)onClickCapture:(id)sender
{
    [self.sdk presentCaptureInterfaceFromViewController:self
                                        targetLineColor:[UIColor orangeColor]
                                         toolbarBGColor:[UIColor grayColor]
                                        didCaptureImage:^(NSString *imagePath){
                                            
                                            NSLog(@"path: %@", imagePath);
                                            self.imagePath = imagePath;
                                            [self.sdk dismissCaptureInterface];
                                        }
                                         didClickCancel:^{
                                             
                                             [self.sdk dismissCaptureInterface];
                                         }];
}


- (IBAction)onClickRecognize:(id)sender
{
    NSString *result = @"";
    NSString *signature = @"20170309czvv2204sm4798g03q4q1rkyonxahxty0451d558v01b6pr355efp9x76y0m0e974832";
    NSData *resultData = nil;
    
    NSInteger retCode = [self.sdk recognizeImageWithPath:self.imagePath
                                               signature:signature
                                              resultData:&resultData];
    
    if(retCode < 0)
    {
        // recognition failed
        result = [NSString stringWithFormat:@"failed with code : %ld", (long)retCode];
    }
    else
    {
        // recognition success
        
        NSInteger size = [resultData length]/sizeof(unichar);
        unichar *recogResult = (unichar *)resultData.bytes;
        NSInteger i=0;
        
        while(i<size)
        {
            // 0代表結束
            if(recogResult[i] == 0)
            {
                break;
            }
            
            NSInteger mType = recogResult[i++];
            NSInteger len = recogResult[i++];
            NSString *title = @"";
            
            switch(mType)
            {
                case ID_IDCARD_NAME:
                    title = @"姓名: ";
                    break;
                    
                case ID_IDCARD_BIRTHDAY:
                    title = @"出生年月日: ";
                    break;
                    
                case ID_IDCARD_SEX:
                    title = @"性別: ";
                    break;
                    
                case ID_IDCARD_ISSUEDATE:
                    title = @"發證日期: ";
                    break;
                    
                case ID_IDCARD_IDNO:
                    title = @"統一編號: ";
                    break;
                    
                case ID_IDCARD_FATHER:
                    title = @"父: ";
                    break;
                    
                case ID_IDCARD_MOTHER:
                    title = @"母: ";
                    break;
                    
                case ID_IDCARD_PARTNER:
                    title = @"配偶: ";
                    break;
                    
                case ID_IDCARD_MILITARY:
                    title = @"役別: ";
                    break;
                    
                case ID_IDCARD_BIRTHPLACE:
                    title = @"出生地: ";
                    break;
                    
                case ID_IDCARD_ADDRESS:
                    title = @"住址: ";
                    break;
                    
                case ID_IDCARD_SN:
                    title = @"背面序號: ";
                    break;
                    
                default:
                    title = [NSString stringWithFormat:@"未定義欄位(%ld): ", (long)mType];
                    break;
            }
            
            
            NSString *content = [NSString stringWithCharacters:recogResult+i length:len];
            i+=len;
            result = [result stringByAppendingFormat:@"%@%@\n", title, content];
        }
    }
    
    //////////////////////////////////////////////////
    // show result
    
    NSLog(@"%@", result);
    
    UIAlertController *alertController = [UIAlertController alertControllerWithTitle:@""
                                                                             message:result
                                                                      preferredStyle:UIAlertControllerStyleAlert];
    
    UIAlertAction *okAction = [UIAlertAction actionWithTitle:@"Ok" style:UIAlertActionStyleDefault handler:nil];
    [alertController addAction:okAction];
    
    [self presentViewController:alertController animated:YES completion:nil];
}

@end
